/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.Util;

class UpdatableBlobStream
extends InputStream {
    private boolean materialized;
    private InputStream stream;
    private long pos;
    private final EmbedBlob blob;
    private final long maxPos;

    UpdatableBlobStream(EmbedBlob embedBlob, InputStream inputStream) throws IOException {
        this(embedBlob, inputStream, 0L, Long.MAX_VALUE);
    }

    UpdatableBlobStream(EmbedBlob embedBlob, InputStream inputStream, long l, long l2) throws IOException {
        this.blob = embedBlob;
        this.stream = inputStream;
        this.maxPos = l + l2;
        if (l > 0L) {
            this.skip(l);
        }
    }

    private void updateIfRequired() throws IOException {
        if (this.materialized) {
            return;
        }
        if (this.blob.isMaterialized()) {
            this.materialized = true;
            try {
                this.stream = this.blob.getBinaryStream();
            }
            catch (SQLException sQLException) {
                throw Util.newIOException(sQLException);
            }
            InputStreamUtil.skipFully(this.stream, this.pos);
        }
    }

    @Override
    public int read() throws IOException {
        this.updateIfRequired();
        if (this.pos >= this.maxPos) {
            return -1;
        }
        int n = this.stream.read();
        if (n >= 0) {
            ++this.pos;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.updateIfRequired();
        long l = this.maxPos - this.pos;
        if (l == 0L && n2 > 0) {
            return -1;
        }
        int n3 = (int)Math.min((long)n2, l);
        int n4 = this.stream.read(byArray, n, n3);
        if (n4 > 0) {
            this.pos += (long)n4;
        }
        return n4;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public long skip(long l) throws IOException {
        this.updateIfRequired();
        long l2 = this.stream.skip(l);
        if (l2 > 0L) {
            this.pos += l2;
        }
        return l2;
    }
}

