/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

class OffsetOrderVisitor<T extends QueryTreeNode>
implements Visitor {
    private static final Comparator<QueryTreeNode> COMPARATOR = new Comparator<QueryTreeNode>(){

        @Override
        public int compare(QueryTreeNode queryTreeNode, QueryTreeNode queryTreeNode2) {
            return queryTreeNode.getBeginOffset() - queryTreeNode2.getBeginOffset();
        }
    };
    private final Class<T> nodeClass;
    private final TreeSet<T> nodes = new TreeSet<QueryTreeNode>(COMPARATOR);
    private final int lowOffset;
    private final int highOffset;

    OffsetOrderVisitor(Class<T> clazz, int n, int n2) {
        this.nodeClass = clazz;
        this.lowOffset = n;
        this.highOffset = n2;
    }

    @Override
    public Visitable visit(Visitable visitable) throws StandardException {
        QueryTreeNode queryTreeNode;
        if (this.nodeClass.isInstance(visitable) && (queryTreeNode = (QueryTreeNode)this.nodeClass.cast(visitable)).getBeginOffset() >= this.lowOffset && queryTreeNode.getEndOffset() < this.highOffset) {
            this.nodes.add(queryTreeNode);
        }
        return visitable;
    }

    @Override
    public boolean visitChildrenFirst(Visitable visitable) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public boolean skipChildren(Visitable visitable) throws StandardException {
        return false;
    }

    SortedSet<T> getNodes() {
        return this.nodes;
    }
}

