/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.labelingrules;

import com.jrockit.mc.common.jvm.JVMCommandLineToolkit;
import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.common.mbean.LocalMBeanToolkit;
import com.jrockit.mc.common.util.Resource;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.idesupport.IDESupportFactory;
import com.jrockit.mc.core.labelingrules.Messages;
import com.jrockit.mc.core.labelingrules.NamingRule;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class NameConverter {
    private final List<NamingRule> rules = new ArrayList<NamingRule>();
    private static final String ATTRIBUTE_ICON = "icon";
    private static final Comparator<NamingRule> COMPARATOR = new Comparator<NamingRule>(){

        @Override
        public int compare(NamingRule o1, NamingRule o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };
    private static final NameConverter INSTANCE = new NameConverter();

    public static NameConverter getInstance() {
        return INSTANCE;
    }

    NameConverter() {
        this.initializeRulesFromExtensions();
    }

    public String format(JVMDescriptor descriptor) {
        Object[] values = this.prepareValues(descriptor);
        NamingRule rule = this.getMatchingRule(values);
        if (rule != null) {
            return rule.format(values);
        }
        return MessageFormat.format(Messages.NameConverter_LOCAL_NAME_TEMPLATE, descriptor);
    }

    public Resource getImageResource(JVMDescriptor descriptor) {
        NamingRule rule = this.getMatchingRule(this.prepareValues(descriptor));
        return rule == null ? null : rule.getImageResource();
    }

    void addNamingRule(NamingRule rule) {
        this.rules.add(rule);
        Collections.sort(this.rules, COMPARATOR);
    }

    public List<NamingRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    private NamingRule getMatchingRule(Object[] values) {
        for (NamingRule rule : this.rules) {
            try {
                if (!rule.matches(values)) continue;
                return rule;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private void initializeRulesFromExtensions() {
        IExtension[] extensions;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint("com.jrockit.mc.core.labelingRules");
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals("rule")) {
                    try {
                        this.rules.add(this.createRule(config));
                    }
                    catch (Exception e) {
                        CorePlugin.getDefault().getLogger().log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        Collections.sort(this.rules, COMPARATOR);
    }

    private NamingRule createRule(IConfigurationElement config) throws Exception {
        String name = config.getAttribute("name");
        try {
            int priority = Integer.parseInt(config.getAttribute("priority"));
            String matchingPart = config.getAttribute("match");
            String formattingPart = config.getAttribute("format");
            return new NamingRule(name, matchingPart, formattingPart, priority, this.getIcon(config));
        }
        catch (Exception e) {
            throw new Exception("Problem instantiating naming rule named " + name);
        }
    }

    private Resource getIcon(IConfigurationElement configElement) {
        String iconName = configElement.getAttribute(ATTRIBUTE_ICON);
        if (iconName != null) {
            String extendingPluginId = configElement.getDeclaringExtension().getContributor().getName();
            return new Resource(extendingPluginId, iconName);
        }
        return null;
    }

    private Object[] prepareValues(JVMDescriptor descriptor) {
        return new Object[]{descriptor.getJavaVersion(), descriptor.getJvmType(), descriptor.getJvmArch(), this.getValidName(descriptor), descriptor.getJavaCommandLine(), descriptor.getPid() != null ? String.valueOf(descriptor.getPid()) : "", descriptor.isDebug()};
    }

    private String getValidName(JVMDescriptor descriptor) {
        Integer pid = descriptor.getPid();
        if (pid != null && pid == LocalMBeanToolkit.getThisPID() && descriptor.isAttachable().booleanValue()) {
            return String.valueOf(IDESupportFactory.getIDESupport().getIdentity()) + ".this";
        }
        String name = JVMCommandLineToolkit.getMainClassOrJar((String)descriptor.getJavaCommandLine());
        if (name != null && name.length() > 0) {
            return name;
        }
        return Messages.NameConverter_UNKNOWN_LOCAL_JVM;
    }
}

