/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.fields;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.internal.model.FLRFrame;
import com.jrockit.mc.flightrecorder.internal.model.FLRStackTrace;
import com.jrockit.mc.flightrecorder.provider.Field;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;

public final class TopFrameMethodField
extends Field {
    private final IField m_field;

    public TopFrameMethodField(IEventType type, String attributIdentifier, IField field) {
        super(type, "(" + attributIdentifier + ".method)");
        this.m_field = field;
        this.setName("Stacktrace (Top Frame : Method)");
        this.setDescription("The method on top of the stack");
        this.setFieldType(FieldType.OBJECT);
        this.setContentType(UnitLookup.METHOD.getIdentifier());
        this.setVisible(false);
        this.setSynthetic(true);
    }

    @Override
    public Object getValue(IEvent event) {
        FLRStackTrace s;
        FLRFrame frame;
        Object o = this.m_field.getValue(event);
        if (o instanceof FLRStackTrace && (frame = (s = (FLRStackTrace)o).getValidTopFrame()) != null) {
            return frame.getMethod();
        }
        return null;
    }
}

