/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ChartSelectionModel;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChart;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;

final class TimelineChart
extends SynchronousXYChart {
    static final int MIN_ROW_HEIGHT = 20;
    static final int MAX_ROW_HEIGHT = 500;
    static final int DEF_ROW_HEIGHT = 40;
    static final int ROW_RESIZE_STEP = 20;
    private static final int ROW_MARGIN_TOP = 3;
    private static final int ROW_MARGIN_BOTTOM = 3;
    private int currentRowHeight = 40;
    private final List<Row> rows;
    private final Map<ChartItem, Row> itemsToRows;
    private final Set selectedRows = new TreeSet<Row>(new RowComparator());
    private final Set selectionBlockers = new HashSet();
    private int lastHoverMode;
    private int lastMoveMode;
    private final Set<RowListener> rowListeners = new HashSet<RowListener>();

    TimelineChart(SynchronousXYItemsModel synchronousXYItemsModel) {
        super(synchronousXYItemsModel, (PaintersModel)new PaintersModel.Default());
        this.rows = new ArrayList<Row>();
        this.itemsToRows = new HashMap<ChartItem, Row>();
        this.setBottomBased(false);
        this.setZoomMode(1);
        this.setMouseZoomingEnabled(false);
        this.setMousePanningEnabled(false);
        this.setAccelerationPriority(1.0f);
    }

    Row addRow() {
        Row row = new Row();
        int n = this.rows.size();
        row.setIndex(n);
        this.rows.add(row);
        row.setHeight(this.currentRowHeight, true);
        row.updateOffset();
        this.updateChart();
        this.notifyRowsAdded(Collections.singletonList(row));
        return row;
    }

    Row addRow(int n) {
        Row row = new Row();
        row.setIndex(n);
        this.rows.add(n, row);
        row.setHeight(this.currentRowHeight, true);
        this.updateRowOffsets(n);
        this.updateRowIndexes(n + 1);
        this.updateChart();
        this.notifyRowsAdded(Collections.singletonList(row));
        return row;
    }

    Row removeRow(int n) {
        return this.removeRow(this.rows.get(n));
    }

    Row removeRow(Row row) {
        row.clearItems();
        this.rows.remove(row);
        int n = row.getIndex();
        this.updateRowIndexes(n);
        this.updateRowOffsets(n);
        this.updateChart();
        this.notifyRowsRemoved(Collections.singletonList(row));
        return row;
    }

    boolean hasRows() {
        return !this.rows.isEmpty();
    }

    int getRowsCount() {
        return this.rows.size();
    }

    Row getRow(int n) {
        return this.rows.get(n);
    }

    Row getRow(ChartItem chartItem) {
        return this.itemsToRows.get(chartItem);
    }

    void setRowHeight(int n, int n2) {
        this.setRowHeight(n, n2, true);
    }

    void setRowHeight(int n, int n2, boolean bl) {
        Row row = this.rows.get(n);
        boolean bl2 = row.setHeight(n2, bl);
        this.updateRowOffsets(n + 1);
        if (bl2) {
            this.notifyRowsResized(Collections.singletonList(row));
        }
        this.updateChart();
    }

    int getRowHeight(int n) {
        return this.rows.get(n).getHeight();
    }

    void increaseRowHeights(boolean bl) {
        if (this.rows.isEmpty()) {
            return;
        }
        int n = bl ? 20 : 1;
        ArrayList<Row> arrayList = new ArrayList<Row>(this.rows.size());
        for (Row row : this.rows) {
            if (!row.setHeight(row.getHeight() + n, bl)) continue;
            arrayList.add(row);
        }
        this.updateRowOffsets(0);
        if (!arrayList.isEmpty()) {
            this.notifyRowsResized(arrayList);
        }
        this.updateChart();
        this.currentRowHeight += n;
    }

    void decreaseRowHeights(boolean bl) {
        if (this.rows.isEmpty()) {
            return;
        }
        int n = bl ? 20 : 1;
        ArrayList<Row> arrayList = new ArrayList<Row>(this.rows.size());
        for (Row row : this.rows) {
            if (!row.setHeight(row.getHeight() - n, bl)) continue;
            arrayList.add(row);
        }
        this.updateRowOffsets(0);
        if (!arrayList.isEmpty()) {
            this.notifyRowsResized(arrayList);
        }
        this.updateChart();
        this.currentRowHeight = Math.max(this.currentRowHeight - n, 20);
    }

    void resetRowHeights() {
        if (this.rows.isEmpty()) {
            return;
        }
        ArrayList<Row> arrayList = new ArrayList<Row>(this.rows.size());
        for (Row row : this.rows) {
            if (!row.setHeight(40, true)) continue;
            arrayList.add(row);
        }
        this.updateRowOffsets(0);
        if (!arrayList.isEmpty()) {
            this.notifyRowsResized(new ArrayList<Row>(this.rows));
        }
        this.updateChart();
        this.currentRowHeight = 40;
    }

    Row getRowAt(int n) {
        n = (int)((long)n + this.getOffsetY());
        for (Row row : this.rows) {
            int n2 = row.getOffset();
            if (n < n2) {
                return null;
            }
            if (n > (n2 += row.getHeight())) continue;
            return row;
        }
        return null;
    }

    Row getNearestRow(int n, int n2, boolean bl) {
        Object object;
        int n3;
        if (this.rows.size() == 0) {
            return null;
        }
        n = (int)((long)n + this.getOffsetY());
        if (bl && n < (n3 = ((Row)(object = this.rows.get(0))).getOffset() + ((Row)object).getHeight()) - n2) {
            return null;
        }
        for (Row row : this.rows) {
            int n4 = row.getOffset();
            if (n < n4 - n2) {
                return null;
            }
            if (n <= n4 + n2) {
                return row;
            }
            if (n < (n4 += row.getHeight()) - n2) {
                return null;
            }
            if (n > n4 + n2) continue;
            return row;
        }
        return null;
    }

    private void updateRowOffsets(int n) {
        int n2 = this.rows.size();
        if (n >= n2) {
            return;
        }
        for (int i = n; i < n2; ++i) {
            this.rows.get(i).updateOffset();
        }
    }

    void addRowListener(RowListener rowListener) {
        this.rowListeners.add(rowListener);
    }

    void removeRowListener(RowListener rowListener) {
        this.rowListeners.remove(rowListener);
    }

    private void notifyRowsAdded(final List<Row> list) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (RowListener rowListener : TimelineChart.this.rowListeners) {
                    rowListener.rowsAdded(list);
                }
            }
        });
    }

    private void notifyRowsRemoved(final List<Row> list) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (RowListener rowListener : TimelineChart.this.rowListeners) {
                    rowListener.rowsRemoved(list);
                }
            }
        });
    }

    private void notifyRowsResized(final List<Row> list) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (RowListener rowListener : TimelineChart.this.rowListeners) {
                    rowListener.rowsResized(list);
                }
            }
        });
    }

    boolean selectRow(Row row) {
        if (!this.selectedRows.add(row)) {
            return false;
        }
        this.repaintRows();
        return true;
    }

    boolean unselectRow(Row row) {
        if (!this.selectedRows.remove(row)) {
            return false;
        }
        this.repaintRows();
        return true;
    }

    boolean setSelectedRow(Row row) {
        if (row == null) {
            return this.clearRowsSelection();
        }
        if (this.selectedRows.size() == 1 && this.selectedRows.contains(row)) {
            return false;
        }
        this.selectedRows.clear();
        this.selectedRows.add(row);
        this.repaintRows();
        return true;
    }

    boolean toggleRowSelection(Row row) {
        if (this.selectedRows.contains(row)) {
            return this.unselectRow(row);
        }
        return this.selectRow(row);
    }

    boolean clearRowsSelection() {
        if (this.selectedRows.isEmpty()) {
            return false;
        }
        this.selectedRows.clear();
        this.repaintRows();
        return true;
    }

    boolean isRowSelected(Row row) {
        return this.selectedRows.contains(row);
    }

    boolean isRowSelection() {
        return !this.selectedRows.isEmpty();
    }

    List<Row> getSelectedRows() {
        return new ArrayList<Row>(this.selectedRows);
    }

    void updateSelection(boolean bl, Object object) {
        int n = this.selectionBlockers.size();
        if (bl) {
            this.selectionBlockers.remove(object);
        } else {
            this.selectionBlockers.add(object);
        }
        if (this.selectionBlockers.size() == n) {
            return;
        }
        ChartSelectionModel chartSelectionModel = this.getSelectionModel();
        if (chartSelectionModel == null) {
            return;
        }
        if (this.selectionBlockers.isEmpty()) {
            chartSelectionModel.setHoverMode(this.lastHoverMode);
        } else {
            this.lastHoverMode = chartSelectionModel.getHoverMode();
            this.lastMoveMode = chartSelectionModel.getMoveMode();
            chartSelectionModel.setHoverMode(100);
        }
    }

    long maxOffsetX() {
        return super.getMaxOffsetX();
    }

    double viewWidth(double d) {
        return super.getViewWidth(d);
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        super.processMouseWheelEvent(mouseWheelEvent);
    }

    protected ChartContext getChartContext(ChartItem chartItem) {
        if (chartItem == null) {
            return super.getChartContext(null);
        }
        return this.itemsToRows.get(chartItem).getContext();
    }

    protected void computeDataBounds() {
        LongRect.clear((LongRect)this.dataBounds);
        if (this.rows == null) {
            return;
        }
        for (Row row : this.rows) {
            RowContext rowContext = (RowContext)row.getContext();
            if (LongRect.isClear((LongRect)this.dataBounds)) {
                LongRect.set((LongRect)this.dataBounds, (LongRect)rowContext.bounds);
                continue;
            }
            LongRect.add((LongRect)this.dataBounds, (LongRect)rowContext.bounds);
        }
        this.dataBounds.y = 0L;
        Iterator<Row> iterator = this.rows.size() > 0 ? this.rows.get(this.rows.size() - 1) : null;
        this.dataBounds.height = iterator != null ? (long)(((Row)((Object)iterator)).getOffset() + ((Row)((Object)iterator)).getHeight()) : 0L;
    }

    protected void updateChart() {
        this.updateRowBounds();
        super.updateChart();
    }

    protected void itemsAdded(List<ChartItem> list) {
        this.updateRowBounds();
        super.itemsAdded(list);
    }

    protected void itemsRemoved(List<ChartItem> list) {
        this.updateRowBounds();
        super.itemsRemoved(list);
    }

    protected void itemsChanged(List<ChartItemChange> list) {
        this.updateRowBounds();
        super.itemsChanged(list);
    }

    protected void paintersChanged(List<ItemPainter> list) {
        this.updateRowBounds();
        super.paintersChanged(list);
    }

    void addItemsImpl(SynchronousXYItem[] synchronousXYItemArray, ItemPainter[] itemPainterArray, Row row) {
        for (SynchronousXYItem synchronousXYItem : synchronousXYItemArray) {
            this.itemsToRows.put((ChartItem)synchronousXYItem, row);
        }
        this.paintersModel().addPainters((ChartItem[])synchronousXYItemArray, itemPainterArray);
        this.itemsModel().addItems(synchronousXYItemArray);
    }

    void removeItemsImpl(SynchronousXYItem[] synchronousXYItemArray) {
        this.itemsModel().removeItems(synchronousXYItemArray);
        this.paintersModel().removePainters((ChartItem[])synchronousXYItemArray);
        for (SynchronousXYItem synchronousXYItem : synchronousXYItemArray) {
            this.itemsToRows.remove(synchronousXYItem);
        }
    }

    void invalidateRepaint() {
        this.invalidateImage();
        this.repaintDirty();
    }

    private SynchronousXYItemsModel itemsModel() {
        return (SynchronousXYItemsModel)this.getItemsModel();
    }

    private PaintersModel.Default paintersModel() {
        return (PaintersModel.Default)this.getPaintersModel();
    }

    private void updateRowIndexes(int n) {
        for (int i = n; i < this.rows.size(); ++i) {
            this.rows.get(i).setIndex(i);
        }
    }

    private void repaintRows() {
        this.invalidateImage();
        this.repaintDirty();
    }

    private void repaintRows(int n) {
        for (int i = n; i < this.rows.size(); ++i) {
            ChartContext chartContext = this.rows.get(i).getContext();
            this.invalidateImage(new Rectangle(0, Utils.checkedInt((double)chartContext.getViewportOffsetY()), this.getWidth(), chartContext.getViewportHeight()));
        }
        this.repaintDirty();
    }

    private void updateRowBounds() {
        if (this.rows == null) {
            return;
        }
        for (Row row : this.rows) {
            ((RowContext)row.getContext()).updateBounds();
        }
    }

    public static interface RowListener {
        public void rowsAdded(List<Row> var1);

        public void rowsRemoved(List<Row> var1);

        public void rowsResized(List<Row> var1);
    }

    private static class RowComparator
    implements Comparator<Row> {
        private RowComparator() {
        }

        @Override
        public int compare(Row row, Row row2) {
            int n;
            int n2 = row.getIndex();
            return n2 < (n = row2.getIndex()) ? -1 : (n2 == n ? 0 : 1);
        }
    }

    private class RowContext
    extends SynchronousXYChart.Context {
        private final Row row;
        private final LongRect bounds;
        private double scaleY;
        private int marginTop;
        private int marginBottom;

        RowContext(Row row) {
            super((SynchronousXYChart)TimelineChart.this);
            this.row = row;
            this.marginTop = 3;
            this.marginBottom = 3;
            this.bounds = new LongRect();
        }

        protected void updateBounds() {
            LongRect.clear((LongRect)this.bounds);
            PaintersModel.Default default_ = TimelineChart.this.paintersModel();
            int n = this.row.getItemsCount();
            for (int i = 0; i < n; ++i) {
                ChartItem chartItem = this.row.getItem(i);
                ItemPainter itemPainter = default_.getPainter(chartItem);
                LongRect longRect = itemPainter.getItemBounds(chartItem);
                if (LongRect.isClear((LongRect)this.bounds)) {
                    LongRect.set((LongRect)this.bounds, (LongRect)longRect);
                    continue;
                }
                if (LongRect.isEmpty((LongRect)longRect)) {
                    LongRect.add((LongRect)this.bounds, (long)longRect.x, (long)longRect.height);
                    continue;
                }
                LongRect.add((LongRect)this.bounds, (LongRect)longRect);
            }
            double d = this.scaleY;
            this.scaleY = (double)(this.row.getHeight() - this.marginTop - this.marginBottom) / (double)(this.bounds.height == 0L ? 1L : this.bounds.height);
            if (this.scaleY != d) {
                TimelineChart.this.invalidateImage(Utils.checkedRectangle((LongRect)this.getViewRect(this.bounds)));
            }
        }

        public boolean isBottomBased() {
            return true;
        }

        public boolean fitsHeight() {
            return true;
        }

        public long getDataOffsetY() {
            return this.bounds.y;
        }

        public long getDataHeight() {
            return this.bounds.height;
        }

        public long getViewHeight() {
            return this.row.getHeight();
        }

        public long getViewportOffsetY() {
            return (long)this.row.getOffset() - TimelineChart.this.getOffsetY();
        }

        public int getViewportHeight() {
            return this.row.getHeight();
        }

        public double getViewY(double d) {
            return this.getViewY(d, false);
        }

        public double getReversedViewY(double d) {
            return this.getViewY(d, true);
        }

        public double getViewHeight(double d) {
            return d * this.scaleY;
        }

        public double getDataY(double d) {
            return this.getDataY(d, false);
        }

        public double getReversedDataY(double d) {
            return this.getDataY(d, true);
        }

        public double getDataHeight(double d) {
            return d / this.scaleY;
        }

        private double getViewY(double d, boolean bl) {
            if (this.isBottomBased() && !bl || !this.isBottomBased() && bl) {
                return (double)this.row.getHeight() - (d - (double)this.bounds.y) * this.scaleY - (double)TimelineChart.this.getOffsetY() + (double)TimelineChart.this.getViewInsets().top - (double)this.marginBottom + (double)this.row.getOffset();
            }
            return (d - (double)this.bounds.y) * this.scaleY - (double)TimelineChart.this.getOffsetY() + (double)TimelineChart.this.getViewInsets().top + (double)this.marginTop + (double)this.row.getOffset();
        }

        private double getDataY(double d, boolean bl) {
            if (this.isBottomBased() && !bl || !this.isBottomBased() && bl) {
                return (double)this.bounds.y - (d + (double)TimelineChart.this.getViewInsets().bottom - (double)this.marginBottom - (double)TimelineChart.this.getOffsetY() - (double)TimelineChart.this.getHeight()) / this.scaleY;
            }
            return (d + (double)TimelineChart.this.getOffsetY() - (double)TimelineChart.this.getViewInsets().top - (double)this.marginTop) / this.scaleY + (double)this.bounds.y;
        }
    }

    class Row {
        private int rowIndex;
        private int rowOffset;
        private int rowHeight;
        private final List<SynchronousXYItem> items = new ArrayList<SynchronousXYItem>();
        private final RowContext context;

        Row() {
            this.context = new RowContext(this);
        }

        int getIndex() {
            return this.rowIndex;
        }

        private void updateOffset() {
            if (this.rowIndex != 0) {
                Row row = (Row)TimelineChart.this.rows.get(this.rowIndex - 1);
                this.rowOffset = row.rowOffset + row.rowHeight;
            } else {
                this.rowOffset = 0;
            }
        }

        int getOffset() {
            return this.rowOffset;
        }

        private boolean setHeight(int n, boolean bl) {
            n = Math.max(20, n);
            n = Math.min(500, n);
            if (bl) {
                n = n / 20 * 20;
            }
            boolean bl2 = this.rowHeight != n;
            this.rowHeight = n;
            return bl2;
        }

        int getHeight() {
            return this.rowHeight;
        }

        void addItems(SynchronousXYItemsModel synchronousXYItemsModel, PaintersModel paintersModel) {
            int n = synchronousXYItemsModel.getItemsCount();
            SynchronousXYItem[] synchronousXYItemArray = new SynchronousXYItem[n];
            for (int i = 0; i < n; ++i) {
                synchronousXYItemArray[i] = synchronousXYItemsModel.getItem(i);
            }
            ItemPainter[] itemPainterArray = new ItemPainter[n];
            for (int i = 0; i < n; ++i) {
                itemPainterArray[i] = paintersModel.getPainter((ChartItem)synchronousXYItemArray[i]);
            }
            this.addItems(synchronousXYItemArray, itemPainterArray);
        }

        void addItems(SynchronousXYItem[] synchronousXYItemArray, ItemPainter[] itemPainterArray) {
            for (SynchronousXYItem synchronousXYItem : synchronousXYItemArray) {
                this.items.add(synchronousXYItem);
            }
            TimelineChart.this.addItemsImpl(synchronousXYItemArray, itemPainterArray, this);
        }

        void removeItems(SynchronousXYItemsModel synchronousXYItemsModel) {
            int n = synchronousXYItemsModel.getItemsCount();
            SynchronousXYItem[] synchronousXYItemArray = new SynchronousXYItem[n];
            for (int i = 0; i < n; ++i) {
                synchronousXYItemArray[i] = synchronousXYItemsModel.getItem(i);
            }
            this.removeItems(synchronousXYItemArray);
        }

        void removeItems(SynchronousXYItem[] synchronousXYItemArray) {
            TimelineChart.this.removeItemsImpl(synchronousXYItemArray);
            for (SynchronousXYItem synchronousXYItem : synchronousXYItemArray) {
                this.items.remove(synchronousXYItem);
            }
        }

        int getItemsCount() {
            return this.items.size();
        }

        ChartItem getItem(int n) {
            return (ChartItem)this.items.get(n);
        }

        SynchronousXYItem[] getItems() {
            return this.items.toArray(new SynchronousXYItem[this.items.size()]);
        }

        boolean containsItem(ChartItem chartItem) {
            return this.items.contains(chartItem);
        }

        ChartContext getContext() {
            return this.context;
        }

        private void setIndex(int n) {
            this.rowIndex = n;
        }

        private void clearItems() {
            if (this.items.size() == 0) {
                return;
            }
            TimelineChart.this.removeItemsImpl(this.getItems());
        }
    }
}

