/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.webapp.AbstractButton;

public class ButtonData
extends RequestData {
    private static final String BUTTON_EXTENSION_POINT = "org.eclipse.help.webapp.toolbarButton";
    private List allButtons;

    public ButtonData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
    }

    public AbstractButton[] getButtons() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(BUTTON_EXTENSION_POINT);
        if (this.allButtons == null) {
            this.allButtons = new ArrayList();
            int i = 0;
            while (i < elements.length) {
                Object obj = null;
                try {
                    obj = elements[i].createExecutableExtension("class");
                }
                catch (CoreException e) {
                    HelpWebappPlugin.logError("Create extension failed:[org.eclipse.help.webapp.toolbarButton].", e);
                }
                if (obj instanceof AbstractButton) {
                    this.allButtons.add(obj);
                }
                ++i;
            }
            Collections.sort(this.allButtons);
        }
        ArrayList<AbstractButton> buttonList = new ArrayList<AbstractButton>();
        Iterator iter = this.allButtons.iterator();
        while (iter.hasNext()) {
            AbstractButton button = (AbstractButton)iter.next();
            buttonList.add(button);
        }
        AbstractButton[] buttons = buttonList.toArray(new AbstractButton[buttonList.size()]);
        return buttons;
    }

    public String getImageUrl(AbstractButton button) {
        return String.valueOf(this.request.getContextPath()) + button.getImageURL();
    }
}

