/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBindList;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpInformHandler;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import com.sun.jmx.snmp.daemon.SnmpResponseHandler;
import com.sun.jmx.snmp.daemon.SnmpSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;

class SnmpSession
implements SnmpDefinitions,
Runnable {
    protected transient SnmpAdaptorServer adaptor;
    protected transient SnmpSocket informSocket = null;
    private transient Hashtable<SnmpInformRequest, SnmpInformRequest> informRequestList = new Hashtable();
    private transient Stack<SnmpInformRequest> informRespq = new Stack();
    private transient Thread myThread = null;
    private transient SnmpInformRequest syncInformReq;
    SnmpQManager snmpQman = null;
    private boolean isBeingCancelled = false;

    public SnmpSession(SnmpAdaptorServer snmpAdaptorServer) throws SocketException {
        this.adaptor = snmpAdaptorServer;
        this.snmpQman = new SnmpQManager();
        SnmpResponseHandler snmpResponseHandler = new SnmpResponseHandler(snmpAdaptorServer, this.snmpQman);
        this.initialize(snmpAdaptorServer, snmpResponseHandler);
    }

    public SnmpSession() throws SocketException {
    }

    protected synchronized void initialize(SnmpAdaptorServer snmpAdaptorServer, SnmpResponseHandler snmpResponseHandler) throws SocketException {
        this.informSocket = new SnmpSocket(snmpResponseHandler, snmpAdaptorServer.getAddress(), snmpAdaptorServer.getBufferSize());
        this.myThread = new Thread((Runnable)this, "SnmpSession");
        this.myThread.start();
    }

    synchronized boolean isSessionActive() {
        return this.adaptor.isActive() && this.myThread != null && this.myThread.isAlive();
    }

    SnmpSocket getSocket() {
        return this.informSocket;
    }

    SnmpQManager getSnmpQManager() {
        return this.snmpQman;
    }

    private synchronized boolean syncInProgress() {
        return this.syncInformReq != null;
    }

    private synchronized void setSyncMode(SnmpInformRequest snmpInformRequest) {
        this.syncInformReq = snmpInformRequest;
    }

    private synchronized void resetSyncMode() {
        if (this.syncInformReq == null) {
            return;
        }
        this.syncInformReq = null;
        if (this.thisSessionContext()) {
            return;
        }
        this.notifyAll();
    }

    boolean thisSessionContext() {
        return Thread.currentThread() == this.myThread;
    }

    SnmpInformRequest makeAsyncRequest(InetAddress inetAddress, String string, SnmpInformHandler snmpInformHandler, SnmpVarBindList snmpVarBindList, int n) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException("SNMP adaptor server not ONLINE");
        }
        SnmpInformRequest snmpInformRequest = new SnmpInformRequest(this, this.adaptor, inetAddress, string, n, snmpInformHandler);
        snmpInformRequest.start(snmpVarBindList);
        return snmpInformRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForResponse(SnmpInformRequest snmpInformRequest, long l) {
        if (!snmpInformRequest.inProgress()) {
            return;
        }
        this.setSyncMode(snmpInformRequest);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "waitForResponse", "Session switching to sync mode for inform request " + snmpInformRequest.getRequestId());
        }
        long l2 = l <= 0L ? System.currentTimeMillis() + 6000000L : System.currentTimeMillis() + l;
        while ((snmpInformRequest.inProgress() || this.syncInProgress()) && (l = l2 - System.currentTimeMillis()) > 0L) {
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                if (!this.informRespq.removeElement(snmpInformRequest)) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                this.processResponse(snmpInformRequest);
            }
            catch (Exception exception) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "waitForResponse", "Got unexpected exception", exception);
            }
        }
        this.resetSyncMode();
    }

    @Override
    public void run() {
        this.myThread = Thread.currentThread();
        this.myThread.setPriority(5);
        SnmpInformRequest snmpInformRequest = null;
        while (this.myThread != null) {
            try {
                snmpInformRequest = this.nextResponse();
                if (snmpInformRequest == null) continue;
                this.processResponse(snmpInformRequest);
            }
            catch (ThreadDeath threadDeath) {
                this.myThread = null;
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "run", "ThreadDeath, session thread unexpectedly shutting down");
                }
                throw threadDeath;
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSession.class.getName(), "run", "Session thread shutting down");
        }
        this.myThread = null;
    }

    private void processResponse(SnmpInformRequest snmpInformRequest) {
        while (snmpInformRequest != null && this.myThread != null) {
            try {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSession.class.getName(), "processResponse", "Processing response to req = " + snmpInformRequest.getRequestId());
                }
                snmpInformRequest.processResponse();
                snmpInformRequest = null;
            }
            catch (Exception exception) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "processResponse", "Got unexpected exception", exception);
                }
                snmpInformRequest = null;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "processResponse", "Out of memory error in session thread", outOfMemoryError);
                }
                Thread.yield();
            }
        }
    }

    synchronized void addInformRequest(SnmpInformRequest snmpInformRequest) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException("SNMP adaptor is not ONLINE or session is dead...");
        }
        this.informRequestList.put(snmpInformRequest, snmpInformRequest);
    }

    synchronized void removeInformRequest(SnmpInformRequest snmpInformRequest) {
        if (!this.isBeingCancelled) {
            this.informRequestList.remove(snmpInformRequest);
        }
        if (this.syncInformReq != null && this.syncInformReq == snmpInformRequest) {
            this.resetSyncMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllRequests() {
        SnmpInformRequest[] snmpInformRequestArray;
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            if (this.informRequestList.isEmpty()) {
                return;
            }
            this.isBeingCancelled = true;
            snmpInformRequestArray = new SnmpInformRequest[this.informRequestList.size()];
            Iterator<SnmpInformRequest> iterator = this.informRequestList.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                SnmpInformRequest snmpInformRequest = iterator.next();
                snmpInformRequestArray[n++] = snmpInformRequest;
                iterator.remove();
            }
            this.informRequestList.clear();
        }
        for (int i = 0; i < snmpInformRequestArray.length; ++i) {
            snmpInformRequestArray[i].cancelRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResponse(SnmpInformRequest snmpInformRequest) {
        SnmpInformRequest snmpInformRequest2 = snmpInformRequest;
        if (this.isSessionActive()) {
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                this.informRespq.push(snmpInformRequest);
                this.notifyAll();
            }
        } else if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "addResponse", "Adaptor not ONLINE or session thread dead, so inform response is dropped..." + snmpInformRequest.getRequestId());
        }
    }

    private synchronized SnmpInformRequest nextResponse() {
        if (this.informRespq.isEmpty()) {
            try {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSession.class.getName(), "nextResponse", "Blocking for response");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.informRespq.isEmpty()) {
            return null;
        }
        SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.informRespq.firstElement();
        this.informRespq.removeElementAt(0);
        return snmpInformRequest;
    }

    private synchronized void cancelAllResponses() {
        if (this.informRespq != null) {
            this.syncInformReq = null;
            this.informRespq.removeAllElements();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void destroySession() {
        this.cancelAllRequests();
        this.cancelAllResponses();
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            this.informSocket.close();
            this.informSocket = null;
        }
        this.snmpQman.stopQThreads();
        this.snmpQman = null;
        this.killSessionThread();
    }

    private synchronized void killSessionThread() {
        if (this.myThread != null && this.myThread.isAlive()) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSession.class.getName(), "killSessionThread", "Destroying session");
            }
            if (!this.thisSessionContext()) {
                this.myThread = null;
                this.notifyAll();
            } else {
                this.myThread = null;
            }
        }
    }

    protected void finalize() {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSession.class.getName(), "finalize", "Shutting all servers");
        }
        if (this.informRespq != null) {
            this.informRespq.removeAllElements();
        }
        this.informRespq = null;
        if (this.informSocket != null) {
            this.informSocket.close();
        }
        this.informSocket = null;
        this.snmpQman = null;
    }
}

