/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Ser;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import java.util.Objects;

public final class OffsetTime
implements Temporal,
TemporalAdjuster,
Comparable<OffsetTime>,
Serializable {
    public static final OffsetTime MIN = LocalTime.MIN.atOffset(ZoneOffset.MAX);
    public static final OffsetTime MAX = LocalTime.MAX.atOffset(ZoneOffset.MIN);
    private static final long serialVersionUID = 7264499704384272492L;
    private final LocalTime time;
    private final ZoneOffset offset;

    public static OffsetTime now() {
        return OffsetTime.now(Clock.systemDefaultZone());
    }

    public static OffsetTime now(ZoneId zoneId) {
        return OffsetTime.now(Clock.system(zoneId));
    }

    public static OffsetTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        return OffsetTime.ofInstant(instant, clock.getZone().getRules().getOffset(instant));
    }

    public static OffsetTime of(LocalTime localTime, ZoneOffset zoneOffset) {
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime of(int n, int n2, int n3, int n4, ZoneOffset zoneOffset) {
        return new OffsetTime(LocalTime.of(n, n2, n3, n4), zoneOffset);
    }

    public static OffsetTime ofInstant(Instant instant, ZoneId zoneId) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        long l = instant.getEpochSecond() + (long)zoneOffset.getTotalSeconds();
        int n = (int)Math.floorMod(l, 86400L);
        LocalTime localTime = LocalTime.ofNanoOfDay((long)n * 1000000000L + (long)instant.getNano());
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof OffsetTime) {
            return (OffsetTime)temporalAccessor;
        }
        try {
            LocalTime localTime = LocalTime.from(temporalAccessor);
            ZoneOffset zoneOffset = ZoneOffset.from(temporalAccessor);
            return new OffsetTime(localTime, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain OffsetTime from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName(), dateTimeException);
        }
    }

    public static OffsetTime parse(CharSequence charSequence) {
        return OffsetTime.parse(charSequence, DateTimeFormatter.ISO_OFFSET_TIME);
    }

    public static OffsetTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.parse(charSequence, OffsetTime::from);
    }

    private OffsetTime(LocalTime localTime, ZoneOffset zoneOffset) {
        this.time = Objects.requireNonNull(localTime, "time");
        this.offset = Objects.requireNonNull(zoneOffset, "offset");
    }

    private OffsetTime with(LocalTime localTime, ZoneOffset zoneOffset) {
        if (this.time == localTime && this.offset.equals(zoneOffset)) {
            return this;
        }
        return new OffsetTime(localTime, zoneOffset);
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased() || temporalField == ChronoField.OFFSET_SECONDS;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isTimeBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.time.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return this.offset.getTotalSeconds();
            }
            return this.time.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetTime withOffsetSameLocal(ZoneOffset zoneOffset) {
        return zoneOffset != null && zoneOffset.equals(this.offset) ? this : new OffsetTime(this.time, zoneOffset);
    }

    public OffsetTime withOffsetSameInstant(ZoneOffset zoneOffset) {
        if (zoneOffset.equals(this.offset)) {
            return this;
        }
        int n = zoneOffset.getTotalSeconds() - this.offset.getTotalSeconds();
        LocalTime localTime = this.time.plusSeconds(n);
        return new OffsetTime(localTime, zoneOffset);
    }

    public LocalTime toLocalTime() {
        return this.time;
    }

    public int getHour() {
        return this.time.getHour();
    }

    public int getMinute() {
        return this.time.getMinute();
    }

    public int getSecond() {
        return this.time.getSecond();
    }

    public int getNano() {
        return this.time.getNano();
    }

    @Override
    public OffsetTime with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalTime) {
            return this.with((LocalTime)temporalAdjuster, this.offset);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            return this.with(this.time, (ZoneOffset)temporalAdjuster);
        }
        if (temporalAdjuster instanceof OffsetTime) {
            return (OffsetTime)temporalAdjuster;
        }
        return (OffsetTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public OffsetTime with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                ChronoField chronoField = (ChronoField)temporalField;
                return this.with(this.time, ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l)));
            }
            return this.with(this.time.with(temporalField, l), this.offset);
        }
        return temporalField.adjustInto(this, l);
    }

    public OffsetTime withHour(int n) {
        return this.with(this.time.withHour(n), this.offset);
    }

    public OffsetTime withMinute(int n) {
        return this.with(this.time.withMinute(n), this.offset);
    }

    public OffsetTime withSecond(int n) {
        return this.with(this.time.withSecond(n), this.offset);
    }

    public OffsetTime withNano(int n) {
        return this.with(this.time.withNano(n), this.offset);
    }

    public OffsetTime truncatedTo(TemporalUnit temporalUnit) {
        return this.with(this.time.truncatedTo(temporalUnit), this.offset);
    }

    @Override
    public OffsetTime plus(TemporalAmount temporalAmount) {
        return (OffsetTime)temporalAmount.addTo(this);
    }

    @Override
    public OffsetTime plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.time.plus(l, temporalUnit), this.offset);
        }
        return temporalUnit.addTo(this, l);
    }

    public OffsetTime plusHours(long l) {
        return this.with(this.time.plusHours(l), this.offset);
    }

    public OffsetTime plusMinutes(long l) {
        return this.with(this.time.plusMinutes(l), this.offset);
    }

    public OffsetTime plusSeconds(long l) {
        return this.with(this.time.plusSeconds(l), this.offset);
    }

    public OffsetTime plusNanos(long l) {
        return this.with(this.time.plusNanos(l), this.offset);
    }

    @Override
    public OffsetTime minus(TemporalAmount temporalAmount) {
        return (OffsetTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public OffsetTime minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public OffsetTime minusHours(long l) {
        return this.with(this.time.minusHours(l), this.offset);
    }

    public OffsetTime minusMinutes(long l) {
        return this.with(this.time.minusMinutes(l), this.offset);
    }

    public OffsetTime minusSeconds(long l) {
        return this.with(this.time.minusSeconds(l), this.offset);
    }

    public OffsetTime minusNanos(long l) {
        return this.with(this.time.minusNanos(l), this.offset);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return (R)this.offset;
        }
        if (temporalQuery == TemporalQueries.zoneId() | temporalQuery == TemporalQueries.chronology() || temporalQuery == TemporalQueries.localDate()) {
            return null;
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return (R)this.time;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return temporalQuery.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.NANO_OF_DAY, this.time.toNanoOfDay()).with(ChronoField.OFFSET_SECONDS, this.offset.getTotalSeconds());
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        OffsetTime offsetTime = OffsetTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            long l = offsetTime.toEpochNano() - this.toEpochNano();
            switch ((ChronoUnit)temporalUnit) {
                case NANOS: {
                    return l;
                }
                case MICROS: {
                    return l / 1000L;
                }
                case MILLIS: {
                    return l / 1000000L;
                }
                case SECONDS: {
                    return l / 1000000000L;
                }
                case MINUTES: {
                    return l / 60000000000L;
                }
                case HOURS: {
                    return l / 3600000000000L;
                }
                case HALF_DAYS: {
                    return l / 43200000000000L;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return temporalUnit.between(this, offsetTime);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public OffsetDateTime atDate(LocalDate localDate) {
        return OffsetDateTime.of(localDate, this.time, this.offset);
    }

    private long toEpochNano() {
        long l = this.time.toNanoOfDay();
        long l2 = (long)this.offset.getTotalSeconds() * 1000000000L;
        return l - l2;
    }

    @Override
    public int compareTo(OffsetTime offsetTime) {
        if (this.offset.equals(offsetTime.offset)) {
            return this.time.compareTo(offsetTime.time);
        }
        int n = Long.compare(this.toEpochNano(), offsetTime.toEpochNano());
        if (n == 0) {
            n = this.time.compareTo(offsetTime.time);
        }
        return n;
    }

    public boolean isAfter(OffsetTime offsetTime) {
        return this.toEpochNano() > offsetTime.toEpochNano();
    }

    public boolean isBefore(OffsetTime offsetTime) {
        return this.toEpochNano() < offsetTime.toEpochNano();
    }

    public boolean isEqual(OffsetTime offsetTime) {
        return this.toEpochNano() == offsetTime.toEpochNano();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            return this.time.equals(offsetTime.time) && this.offset.equals(offsetTime.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.time.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.time.toString() + this.offset.toString();
    }

    private Object writeReplace() {
        return new Ser(9, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.time.writeExternal(objectOutput);
        this.offset.writeExternal(objectOutput);
    }

    static OffsetTime readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        LocalTime localTime = LocalTime.readExternal(objectInput);
        ZoneOffset zoneOffset = ZoneOffset.readExternal(objectInput);
        return OffsetTime.of(localTime, zoneOffset);
    }
}

