/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.ConstructorProperties;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import sun.swing.SwingUtilities2;

public class JTree
extends JComponent
implements Scrollable,
Accessible {
    private static final String uiClassID = "TreeUI";
    protected transient TreeModel treeModel;
    protected transient TreeSelectionModel selectionModel;
    protected boolean rootVisible;
    protected transient TreeCellRenderer cellRenderer;
    protected int rowHeight;
    private boolean rowHeightSet = false;
    private transient Hashtable<TreePath, Boolean> expandedState;
    protected boolean showsRootHandles;
    private boolean showsRootHandlesSet = false;
    protected transient TreeSelectionRedirector selectionRedirector;
    protected transient TreeCellEditor cellEditor;
    protected boolean editable;
    protected boolean largeModel;
    protected int visibleRowCount;
    protected boolean invokesStopCellEditing;
    protected boolean scrollsOnExpand;
    private boolean scrollsOnExpandSet = false;
    protected int toggleClickCount = 2;
    protected transient TreeModelListener treeModelListener;
    private transient Stack<Stack<TreePath>> expandedStack;
    private TreePath leadPath;
    private TreePath anchorPath;
    private boolean expandsSelectedPaths;
    private boolean settingUI;
    private boolean dragEnabled;
    private DropMode dropMode = DropMode.USE_SELECTION;
    private transient DropLocation dropLocation;
    private int expandRow = -1;
    private TreeTimer dropTimer;
    private transient TreeExpansionListener uiTreeExpansionListener;
    private static int TEMP_STACK_SIZE = 11;
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String TREE_MODEL_PROPERTY = "model";
    public static final String ROOT_VISIBLE_PROPERTY = "rootVisible";
    public static final String SHOWS_ROOT_HANDLES_PROPERTY = "showsRootHandles";
    public static final String ROW_HEIGHT_PROPERTY = "rowHeight";
    public static final String CELL_EDITOR_PROPERTY = "cellEditor";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String LARGE_MODEL_PROPERTY = "largeModel";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String VISIBLE_ROW_COUNT_PROPERTY = "visibleRowCount";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    public static final String SCROLLS_ON_EXPAND_PROPERTY = "scrollsOnExpand";
    public static final String TOGGLE_CLICK_COUNT_PROPERTY = "toggleClickCount";
    public static final String LEAD_SELECTION_PATH_PROPERTY = "leadSelectionPath";
    public static final String ANCHOR_SELECTION_PATH_PROPERTY = "anchorSelectionPath";
    public static final String EXPANDS_SELECTED_PATHS_PROPERTY = "expandsSelectedPaths";

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("JTree");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("colors");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("blue"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("violet"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("red"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("yellow"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("sports");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("basketball"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("soccer"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("football"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hockey"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("food");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hot dogs"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("pizza"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ravioli"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("bananas"));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    protected static TreeModel createTreeModel(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (object instanceof Object[] || object instanceof Hashtable || object instanceof Vector) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            DynamicUtilTreeNode.createChildren(defaultMutableTreeNode, object);
        } else {
            defaultMutableTreeNode = new DynamicUtilTreeNode((Object)"root", object);
        }
        return new DefaultTreeModel(defaultMutableTreeNode, false);
    }

    public JTree() {
        this(JTree.getDefaultTreeModel());
    }

    public JTree(Object[] objectArray) {
        this(JTree.createTreeModel(objectArray));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public JTree(Vector<?> vector) {
        this(JTree.createTreeModel(vector));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public JTree(Hashtable<?, ?> hashtable) {
        this(JTree.createTreeModel(hashtable));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public JTree(TreeNode treeNode) {
        this(treeNode, false);
    }

    public JTree(TreeNode treeNode, boolean bl) {
        this(new DefaultTreeModel(treeNode, bl));
    }

    @ConstructorProperties(value={"model"})
    public JTree(TreeModel treeModel) {
        this.expandedStack = new Stack();
        this.expandedState = new Hashtable();
        this.setLayout(null);
        this.rowHeight = 16;
        this.visibleRowCount = 20;
        this.rootVisible = true;
        this.selectionModel = new DefaultTreeSelectionModel();
        this.cellRenderer = null;
        this.scrollsOnExpand = true;
        this.setOpaque(true);
        this.expandsSelectedPaths = true;
        this.updateUI();
        this.setModel(treeModel);
    }

    public TreeUI getUI() {
        return (TreeUI)this.ui;
    }

    public void setUI(TreeUI treeUI) {
        if (this.ui != treeUI) {
            this.settingUI = true;
            this.uiTreeExpansionListener = null;
            try {
                super.setUI(treeUI);
            }
            finally {
                this.settingUI = false;
            }
        }
    }

    @Override
    public void updateUI() {
        this.setUI((TreeUI)UIManager.getUI(this));
        SwingUtilities.updateRendererOrEditorUI(this.getCellRenderer());
        SwingUtilities.updateRendererOrEditorUI(this.getCellEditor());
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        TreeCellRenderer treeCellRenderer2 = this.cellRenderer;
        this.cellRenderer = treeCellRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, treeCellRenderer2, this.cellRenderer);
        this.invalidate();
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange(EDITABLE_PROPERTY, bl2, bl);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl2 ? AccessibleState.EDITABLE : null, bl ? AccessibleState.EDITABLE : null);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setCellEditor(TreeCellEditor treeCellEditor) {
        TreeCellEditor treeCellEditor2 = this.cellEditor;
        this.cellEditor = treeCellEditor;
        this.firePropertyChange(CELL_EDITOR_PROPERTY, treeCellEditor2, treeCellEditor);
        this.invalidate();
    }

    public TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel treeModel) {
        this.clearSelection();
        TreeModel treeModel2 = this.treeModel;
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (this.accessibleContext != null) {
            if (this.treeModel != null) {
                this.treeModel.removeTreeModelListener((TreeModelListener)((Object)this.accessibleContext));
            }
            if (treeModel != null) {
                treeModel.addTreeModelListener((TreeModelListener)((Object)this.accessibleContext));
            }
        }
        this.treeModel = treeModel;
        this.clearToggledPaths();
        if (this.treeModel != null) {
            Object object;
            if (this.treeModelListener == null) {
                this.treeModelListener = this.createTreeModelListener();
            }
            if (this.treeModelListener != null) {
                this.treeModel.addTreeModelListener(this.treeModelListener);
            }
            if ((object = this.treeModel.getRoot()) != null && !this.treeModel.isLeaf(object)) {
                this.expandedState.put(new TreePath(object), Boolean.TRUE);
            }
        }
        this.firePropertyChange(TREE_MODEL_PROPERTY, treeModel2, this.treeModel);
        this.invalidate();
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean bl) {
        boolean bl2 = this.rootVisible;
        this.rootVisible = bl;
        this.firePropertyChange(ROOT_VISIBLE_PROPERTY, bl2, this.rootVisible);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
    }

    public void setShowsRootHandles(boolean bl) {
        boolean bl2 = this.showsRootHandles;
        TreeModel treeModel = this.getModel();
        this.showsRootHandles = bl;
        this.showsRootHandlesSet = true;
        this.firePropertyChange(SHOWS_ROOT_HANDLES_PROPERTY, bl2, this.showsRootHandles);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
        this.invalidate();
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public void setRowHeight(int n) {
        int n2 = this.rowHeight;
        this.rowHeight = n;
        this.rowHeightSet = true;
        this.firePropertyChange(ROW_HEIGHT_PROPERTY, n2, this.rowHeight);
        this.invalidate();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public void setLargeModel(boolean bl) {
        boolean bl2 = this.largeModel;
        this.largeModel = bl;
        this.firePropertyChange(LARGE_MODEL_PROPERTY, bl2, bl);
    }

    public boolean isLargeModel() {
        return this.largeModel;
    }

    public void setInvokesStopCellEditing(boolean bl) {
        boolean bl2 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, bl2, bl);
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public void setScrollsOnExpand(boolean bl) {
        boolean bl2 = this.scrollsOnExpand;
        this.scrollsOnExpand = bl;
        this.scrollsOnExpandSet = true;
        this.firePropertyChange(SCROLLS_ON_EXPAND_PROPERTY, bl2, bl);
    }

    public boolean getScrollsOnExpand() {
        return this.scrollsOnExpand;
    }

    public void setToggleClickCount(int n) {
        int n2 = this.toggleClickCount;
        this.toggleClickCount = n;
        this.firePropertyChange(TOGGLE_CLICK_COUNT_PROPERTY, n2, n);
    }

    public int getToggleClickCount() {
        return this.toggleClickCount;
    }

    public void setExpandsSelectedPaths(boolean bl) {
        boolean bl2 = this.expandsSelectedPaths;
        this.expandsSelectedPaths = bl;
        this.firePropertyChange(EXPANDS_SELECTED_PATHS_PROPERTY, bl2, bl);
    }

    public boolean getExpandsSelectedPaths() {
        return this.expandsSelectedPaths;
    }

    public void setDragEnabled(boolean bl) {
        if (bl && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public final void setDropMode(DropMode dropMode) {
        if (dropMode != null) {
            switch (dropMode) {
                case USE_SELECTION: 
                case ON: 
                case INSERT: 
                case ON_OR_INSERT: {
                    this.dropMode = dropMode;
                    return;
                }
            }
        }
        throw new IllegalArgumentException((Object)((Object)dropMode) + ": Unsupported drop mode for tree");
    }

    public final DropMode getDropMode() {
        return this.dropMode;
    }

    @Override
    DropLocation dropLocationForPoint(Point point) {
        DropLocation dropLocation = null;
        int n = this.getClosestRowForLocation(point.x, point.y);
        Rectangle rectangle = this.getRowBounds(n);
        TreeModel treeModel = this.getModel();
        Object object = treeModel == null ? null : treeModel.getRoot();
        TreePath treePath = object == null ? null : new TreePath(object);
        boolean bl = n == -1 || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height;
        switch (this.dropMode) {
            case USE_SELECTION: 
            case ON: {
                if (bl) {
                    dropLocation = new DropLocation(point, null, -1);
                    break;
                }
                dropLocation = new DropLocation(point, this.getPathForRow(n), -1);
                break;
            }
            case INSERT: 
            case ON_OR_INSERT: {
                TreePath treePath2;
                TreePath treePath3;
                if (n == -1) {
                    if (object != null && !treeModel.isLeaf(object) && this.isExpanded(treePath)) {
                        dropLocation = new DropLocation(point, treePath, 0);
                        break;
                    }
                    dropLocation = new DropLocation(point, null, -1);
                    break;
                }
                boolean bl2 = this.dropMode == DropMode.ON_OR_INSERT || !treeModel.isLeaf(this.getPathForRow(n).getLastPathComponent());
                SwingUtilities2.Section section = SwingUtilities2.liesInVertical(rectangle, point, bl2);
                if (section == SwingUtilities2.Section.LEADING) {
                    treePath3 = this.getPathForRow(n);
                    treePath2 = treePath3.getParentPath();
                } else if (section == SwingUtilities2.Section.TRAILING) {
                    int n2 = n + 1;
                    if (n2 >= this.getRowCount()) {
                        if (treeModel.isLeaf(object) || !this.isExpanded(treePath)) {
                            dropLocation = new DropLocation(point, null, -1);
                            break;
                        }
                        TreePath treePath4 = treePath;
                        n2 = treeModel.getChildCount(object);
                        dropLocation = new DropLocation(point, treePath4, n2);
                        break;
                    }
                    treePath3 = this.getPathForRow(n2);
                    treePath2 = treePath3.getParentPath();
                } else {
                    assert (bl2);
                    dropLocation = new DropLocation(point, this.getPathForRow(n), -1);
                    break;
                }
                if (treePath2 != null) {
                    dropLocation = new DropLocation(point, treePath2, treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath3.getLastPathComponent()));
                    break;
                }
                if (bl2 || !treeModel.isLeaf(object)) {
                    dropLocation = new DropLocation(point, treePath, -1);
                    break;
                }
                dropLocation = new DropLocation(point, null, -1);
                break;
            }
            default: {
                assert (false) : "Unexpected drop mode";
                break;
            }
        }
        if (bl || n != this.expandRow) {
            this.cancelDropTimer();
        }
        if (!bl && n != this.expandRow && this.isCollapsed(n)) {
            this.expandRow = n;
            this.startDropTimer();
        }
        return dropLocation;
    }

    @Override
    Object setDropLocation(TransferHandler.DropLocation dropLocation, Object treePathArrayArray, boolean bl) {
        TreePath[] treePathArray;
        TreePath[][] treePathArrayArray2 = null;
        DropLocation dropLocation2 = (DropLocation)dropLocation;
        if (this.dropMode == DropMode.USE_SELECTION) {
            if (dropLocation2 == null) {
                if (!bl && treePathArrayArray != null) {
                    this.setSelectionPaths(((TreePath[][])treePathArrayArray)[0]);
                    this.setAnchorSelectionPath(((TreePath[][])treePathArrayArray)[1][0]);
                    this.setLeadSelectionPath(((TreePath[][])treePathArrayArray)[1][1]);
                }
            } else {
                if (this.dropLocation == null) {
                    treePathArray = this.getSelectionPaths();
                    if (treePathArray == null) {
                        treePathArray = new TreePath[]{};
                    }
                    treePathArrayArray2 = new TreePath[][]{treePathArray, {this.getAnchorSelectionPath(), this.getLeadSelectionPath()}};
                } else {
                    treePathArrayArray2 = treePathArrayArray;
                }
                this.setSelectionPath(dropLocation2.getPath());
            }
        }
        treePathArray = this.dropLocation;
        this.dropLocation = dropLocation2;
        this.firePropertyChange("dropLocation", treePathArray, this.dropLocation);
        return treePathArrayArray2;
    }

    @Override
    void dndDone() {
        this.cancelDropTimer();
        this.dropTimer = null;
    }

    public final DropLocation getDropLocation() {
        return this.dropLocation;
    }

    private void startDropTimer() {
        if (this.dropTimer == null) {
            this.dropTimer = new TreeTimer();
        }
        this.dropTimer.start();
    }

    private void cancelDropTimer() {
        if (this.dropTimer != null && this.dropTimer.isRunning()) {
            this.expandRow = -1;
            this.dropTimer.stop();
        }
    }

    public boolean isPathEditable(TreePath treePath) {
        return this.isEditable();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        if (mouseEvent != null) {
            TreePath treePath;
            Object object;
            Component component;
            Point point = mouseEvent.getPoint();
            int n = this.getRowForLocation(point.x, point.y);
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (n != -1 && treeCellRenderer != null && (component = treeCellRenderer.getTreeCellRendererComponent(this, object = (treePath = this.getPathForRow(n)).getLastPathComponent(), this.isRowSelected(n), this.isExpanded(n), this.getModel().isLeaf(object), n, true)) instanceof JComponent) {
                Rectangle rectangle = this.getPathBounds(treePath);
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                string = ((JComponent)component).getToolTipText(mouseEvent2);
            }
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string;
        if (object != null && (string = object.toString()) != null) {
            return string;
        }
        return "";
    }

    public int getRowCount() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowCount(this);
        }
        return 0;
    }

    public void setSelectionPath(TreePath treePath) {
        this.getSelectionModel().setSelectionPath(treePath);
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().setSelectionPaths(treePathArray);
    }

    public void setLeadSelectionPath(TreePath treePath) {
        TreePath treePath2 = this.leadPath;
        this.leadPath = treePath;
        this.firePropertyChange(LEAD_SELECTION_PATH_PROPERTY, treePath2, treePath);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireActiveDescendantPropertyChange(treePath2, treePath);
        }
    }

    public void setAnchorSelectionPath(TreePath treePath) {
        TreePath treePath2 = this.anchorPath;
        this.anchorPath = treePath;
        this.firePropertyChange(ANCHOR_SELECTION_PATH_PROPERTY, treePath2, treePath);
    }

    public void setSelectionRow(int n) {
        int[] nArray = new int[]{n};
        this.setSelectionRows(nArray);
    }

    public void setSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n = nArray.length;
            TreePath[] treePathArray = new TreePath[n];
            for (int i = 0; i < n; ++i) {
                treePathArray[i] = treeUI.getPathForRow(this, nArray[i]);
            }
            this.setSelectionPaths(treePathArray);
        }
    }

    public void addSelectionPath(TreePath treePath) {
        this.getSelectionModel().addSelectionPath(treePath);
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().addSelectionPaths(treePathArray);
    }

    public void addSelectionRow(int n) {
        int[] nArray = new int[]{n};
        this.addSelectionRows(nArray);
    }

    public void addSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n = nArray.length;
            TreePath[] treePathArray = new TreePath[n];
            for (int i = 0; i < n; ++i) {
                treePathArray[i] = treeUI.getPathForRow(this, nArray[i]);
            }
            this.addSelectionPaths(treePathArray);
        }
    }

    public Object getLastSelectedPathComponent() {
        TreePath treePath = this.getSelectionModel().getSelectionPath();
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }

    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public TreePath getAnchorSelectionPath() {
        return this.anchorPath;
    }

    public TreePath getSelectionPath() {
        return this.getSelectionModel().getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        TreePath[] treePathArray = this.getSelectionModel().getSelectionPaths();
        return treePathArray != null && treePathArray.length > 0 ? treePathArray : null;
    }

    public int[] getSelectionRows() {
        return this.getSelectionModel().getSelectionRows();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public int getMinSelectionRow() {
        return this.getSelectionModel().getMinSelectionRow();
    }

    public int getMaxSelectionRow() {
        return this.getSelectionModel().getMaxSelectionRow();
    }

    public int getLeadSelectionRow() {
        TreePath treePath = this.getLeadSelectionPath();
        if (treePath != null) {
            return this.getRowForPath(treePath);
        }
        return -1;
    }

    public boolean isPathSelected(TreePath treePath) {
        return this.getSelectionModel().isPathSelected(treePath);
    }

    public boolean isRowSelected(int n) {
        return this.getSelectionModel().isRowSelected(n);
    }

    public Enumeration<TreePath> getExpandedDescendants(TreePath treePath) {
        if (!this.isExpanded(treePath)) {
            return null;
        }
        Enumeration<TreePath> enumeration = this.expandedState.keys();
        Vector<TreePath> vector = null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath2 = enumeration.nextElement();
                Boolean bl = this.expandedState.get(treePath2);
                if (treePath2 == treePath || bl == null || !bl.booleanValue() || !treePath.isDescendant(treePath2) || !this.isVisible(treePath2)) continue;
                if (vector == null) {
                    vector = new Vector<TreePath>();
                }
                vector.addElement(treePath2);
            }
        }
        if (vector == null) {
            Set set = Collections.emptySet();
            return Collections.enumeration(set);
        }
        return vector.elements();
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        return treePath != null && this.expandedState.get(treePath) != null;
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        do {
            Boolean bl;
            if ((bl = this.expandedState.get(treePath)) != null && bl.booleanValue()) continue;
            return false;
        } while ((treePath = treePath.getParentPath()) != null);
        return true;
    }

    public boolean isExpanded(int n) {
        TreePath treePath;
        TreeUI treeUI = this.getUI();
        if (treeUI != null && (treePath = treeUI.getPathForRow(this, n)) != null) {
            Boolean bl = this.expandedState.get(treePath);
            return bl != null && bl != false;
        }
        return false;
    }

    public boolean isCollapsed(TreePath treePath) {
        return !this.isExpanded(treePath);
    }

    public boolean isCollapsed(int n) {
        return !this.isExpanded(n);
    }

    public void makeVisible(TreePath treePath) {
        TreePath treePath2;
        if (treePath != null && (treePath2 = treePath.getParentPath()) != null) {
            this.expandPath(treePath2);
        }
    }

    public boolean isVisible(TreePath treePath) {
        if (treePath != null) {
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 != null) {
                return this.isExpanded(treePath2);
            }
            return true;
        }
        return false;
    }

    public Rectangle getPathBounds(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getPathBounds(this, treePath);
        }
        return null;
    }

    public Rectangle getRowBounds(int n) {
        return this.getPathBounds(this.getPathForRow(n));
    }

    public void scrollPathToVisible(TreePath treePath) {
        if (treePath != null) {
            this.makeVisible(treePath);
            Rectangle rectangle = this.getPathBounds(treePath);
            if (rectangle != null) {
                this.scrollRectToVisible(rectangle);
                if (this.accessibleContext != null) {
                    ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
        }
    }

    public void scrollRowToVisible(int n) {
        this.scrollPathToVisible(this.getPathForRow(n));
    }

    public TreePath getPathForRow(int n) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getPathForRow(this, n);
        }
        return null;
    }

    public int getRowForPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowForPath(this, treePath);
        }
        return -1;
    }

    public void expandPath(TreePath treePath) {
        TreeModel treeModel = this.getModel();
        if (treePath != null && treeModel != null && !treeModel.isLeaf(treePath.getLastPathComponent())) {
            this.setExpandedState(treePath, true);
        }
    }

    public void expandRow(int n) {
        this.expandPath(this.getPathForRow(n));
    }

    public void collapsePath(TreePath treePath) {
        this.setExpandedState(treePath, false);
    }

    public void collapseRow(int n) {
        this.collapsePath(this.getPathForRow(n));
    }

    public TreePath getPathForLocation(int n, int n2) {
        Rectangle rectangle;
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        if (treePath != null && (rectangle = this.getPathBounds(treePath)) != null && n >= rectangle.x && n < rectangle.x + rectangle.width && n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
            return treePath;
        }
        return null;
    }

    public int getRowForLocation(int n, int n2) {
        return this.getRowForPath(this.getPathForLocation(n, n2));
    }

    public TreePath getClosestPathForLocation(int n, int n2) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getClosestPathForLocation(this, n, n2);
        }
        return null;
    }

    public int getClosestRowForLocation(int n, int n2) {
        return this.getRowForPath(this.getClosestPathForLocation(n, n2));
    }

    public boolean isEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.cancelEditing(this);
        }
    }

    public void startEditingAtPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.startEditingAtPath(this, treePath);
        }
    }

    public TreePath getEditingPath() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getEditingPath(this);
        }
        return null;
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (treeSelectionModel == null) {
            treeSelectionModel = EmptySelectionModel.sharedInstance();
        }
        TreeSelectionModel treeSelectionModel2 = this.selectionModel;
        if (this.selectionModel != null && this.selectionRedirector != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
        }
        if (this.accessibleContext != null) {
            this.selectionModel.removeTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
            treeSelectionModel.addTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
        }
        this.selectionModel = treeSelectionModel;
        if (this.selectionRedirector != null) {
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, treeSelectionModel2, this.selectionModel);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleSelection", false, true);
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected TreePath[] getPathBetweenRows(int n, int n2) {
        int n3;
        TreeUI treeUI = this.getUI();
        if (!(treeUI == null || (n3 = this.getRowCount()) <= 0 || n < 0 && n2 < 0 || n >= n3 && n2 >= n3)) {
            n = Math.min(n3 - 1, Math.max(n, 0));
            n2 = Math.min(n3 - 1, Math.max(n2, 0));
            int n4 = Math.min(n, n2);
            int n5 = Math.max(n, n2);
            TreePath[] treePathArray = new TreePath[n5 - n4 + 1];
            for (int i = n4; i <= n5; ++i) {
                treePathArray[i - n4] = treeUI.getPathForRow(this, i);
            }
            return treePathArray;
        }
        return new TreePath[0];
    }

    public void setSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        this.getSelectionModel().setSelectionPaths(treePathArray);
    }

    public void addSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        if (treePathArray != null && treePathArray.length > 0) {
            this.getSelectionModel().addSelectionPaths(treePathArray);
        }
    }

    public void removeSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        if (treePathArray != null && treePathArray.length > 0) {
            this.getSelectionModel().removeSelectionPaths(treePathArray);
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        this.getSelectionModel().removeSelectionPath(treePath);
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().removeSelectionPaths(treePathArray);
    }

    public void removeSelectionRow(int n) {
        int[] nArray = new int[]{n};
        this.removeSelectionRows(nArray);
    }

    public void removeSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n = nArray.length;
            TreePath[] treePathArray = new TreePath[n];
            for (int i = 0; i < n; ++i) {
                treePathArray[i] = treeUI.getPathForRow(this, nArray[i]);
            }
            this.removeSelectionPaths(treePathArray);
        }
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        if (this.settingUI) {
            this.uiTreeExpansionListener = treeExpansionListener;
        }
        this.listenerList.add(TreeExpansionListener.class, treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.remove(TreeExpansionListener.class, treeExpansionListener);
        if (this.uiTreeExpansionListener == treeExpansionListener) {
            this.uiTreeExpansionListener = null;
        }
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        return (TreeExpansionListener[])this.listenerList.getListeners(TreeExpansionListener.class);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.add(TreeWillExpandListener.class, treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.remove(TreeWillExpandListener.class, treeWillExpandListener);
    }

    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        return (TreeWillExpandListener[])this.listenerList.getListeners(TreeWillExpandListener.class);
    }

    public void fireTreeExpanded(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        if (this.uiTreeExpansionListener != null) {
            treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            this.uiTreeExpansionListener.treeExpanded(treeExpansionEvent);
        }
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeExpansionListener.class || objectArray[i + 1] == this.uiTreeExpansionListener) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeExpansionListener)objectArray[i + 1]).treeExpanded(treeExpansionEvent);
        }
    }

    public void fireTreeCollapsed(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        if (this.uiTreeExpansionListener != null) {
            treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            this.uiTreeExpansionListener.treeCollapsed(treeExpansionEvent);
        }
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeExpansionListener.class || objectArray[i + 1] == this.uiTreeExpansionListener) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeExpansionListener)objectArray[i + 1]).treeCollapsed(treeExpansionEvent);
        }
    }

    public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeWillExpandListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeWillExpandListener)objectArray[i + 1]).treeWillExpand(treeExpansionEvent);
        }
    }

    public void fireTreeWillCollapse(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeWillExpandListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeWillExpandListener)objectArray[i + 1]).treeWillCollapse(treeExpansionEvent);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(TreeSelectionListener.class, treeSelectionListener);
        if (this.listenerList.getListenerCount(TreeSelectionListener.class) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new TreeSelectionRedirector();
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(TreeSelectionListener.class, treeSelectionListener);
        if (this.listenerList.getListenerCount(TreeSelectionListener.class) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.listenerList.getListeners(TreeSelectionListener.class);
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeSelectionListener.class) continue;
            ((TreeSelectionListener)objectArray[i + 1]).valueChanged(treeSelectionEvent);
        }
    }

    public void treeDidChange() {
        this.revalidate();
        this.repaint();
    }

    public void setVisibleRowCount(int n) {
        int n2 = this.visibleRowCount;
        this.visibleRowCount = n;
        this.firePropertyChange(VISIBLE_ROW_COUNT_PROPERTY, n2, this.visibleRowCount);
        this.invalidate();
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    private void expandRoot() {
        TreeModel treeModel = this.getModel();
        if (treeModel != null && treeModel.getRoot() != null) {
            this.expandPath(new TreePath(treeModel.getRoot()));
        }
    }

    public TreePath getNextMatch(String string, int n, Position.Bias bias) {
        int n2 = this.getRowCount();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException();
        }
        string = string.toUpperCase();
        int n3 = bias == Position.Bias.Forward ? 1 : -1;
        int n4 = n;
        do {
            TreePath treePath;
            String string2;
            if (!(string2 = this.convertValueToText((treePath = this.getPathForRow(n4)).getLastPathComponent(), this.isRowSelected(n4), this.isExpanded(n4), true, n4, false)).toUpperCase().startsWith(string)) continue;
            return treePath;
        } while ((n4 = (n4 + n3 + n2) % n2) != n);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.cellRenderer != null && this.cellRenderer instanceof Serializable) {
            vector.addElement(CELL_RENDERER_PROPERTY);
            vector.addElement(this.cellRenderer);
        }
        if (this.cellEditor != null && this.cellEditor instanceof Serializable) {
            vector.addElement(CELL_EDITOR_PROPERTY);
            vector.addElement(this.cellEditor);
        }
        if (this.treeModel != null && this.treeModel instanceof Serializable) {
            vector.addElement("treeModel");
            vector.addElement(this.treeModel);
        }
        if (this.selectionModel != null && this.selectionModel instanceof Serializable) {
            vector.addElement(SELECTION_MODEL_PROPERTY);
            vector.addElement(this.selectionModel);
        }
        if ((object = this.getArchivableExpandedState()) != null) {
            vector.addElement("expandedState");
            vector.addElement(object);
        }
        objectOutputStream.writeObject(vector);
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.expandedState = new Hashtable();
        this.expandedStack = new Stack();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals(CELL_RENDERER_PROPERTY)) {
            this.cellRenderer = (TreeCellRenderer)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(CELL_EDITOR_PROPERTY)) {
            this.cellEditor = (TreeCellEditor)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("treeModel")) {
            this.treeModel = (TreeModel)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (TreeSelectionModel)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("expandedState")) {
            this.unarchiveExpandedState(vector.elementAt(++n));
            ++n;
        }
        if (this.listenerList.getListenerCount(TreeSelectionListener.class) != 0) {
            this.selectionRedirector = new TreeSelectionRedirector();
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
        if (this.treeModel != null) {
            this.treeModelListener = this.createTreeModelListener();
            if (this.treeModelListener != null) {
                this.treeModel.addTreeModelListener(this.treeModelListener);
            }
        }
    }

    private Object getArchivableExpandedState() {
        Enumeration<TreePath> enumeration;
        TreeModel treeModel = this.getModel();
        if (treeModel != null && (enumeration = this.expandedState.keys()) != null) {
            Vector<Object> vector = new Vector<Object>();
            while (enumeration.hasMoreElements()) {
                int[] nArray;
                TreePath treePath = enumeration.nextElement();
                try {
                    nArray = this.getModelIndexsForPath(treePath);
                }
                catch (Error error) {
                    nArray = null;
                }
                if (nArray == null) continue;
                vector.addElement(nArray);
                vector.addElement(this.expandedState.get(treePath));
            }
            return vector;
        }
        return null;
    }

    private void unarchiveExpandedState(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            for (int i = vector.size() - 1; i >= 0; --i) {
                Boolean bl = (Boolean)vector.elementAt(i--);
                try {
                    TreePath treePath = this.getPathForIndexs((int[])vector.elementAt(i));
                    if (treePath == null) continue;
                    this.expandedState.put(treePath, bl);
                    continue;
                }
                catch (Error error) {
                    // empty catch block
                }
            }
        }
    }

    private int[] getModelIndexsForPath(TreePath treePath) {
        if (treePath != null) {
            TreeModel treeModel = this.getModel();
            int n = treePath.getPathCount();
            int[] nArray = new int[n - 1];
            Object object = treeModel.getRoot();
            for (int i = 1; i < n; ++i) {
                nArray[i - 1] = treeModel.getIndexOfChild(object, treePath.getPathComponent(i));
                object = treePath.getPathComponent(i);
                if (nArray[i - 1] >= 0) continue;
                return null;
            }
            return nArray;
        }
        return null;
    }

    private TreePath getPathForIndexs(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        TreeModel treeModel = this.getModel();
        if (treeModel == null) {
            return null;
        }
        int n = nArray.length;
        Object object = treeModel.getRoot();
        if (object == null) {
            return null;
        }
        TreePath treePath = new TreePath(object);
        for (int i = 0; i < n; ++i) {
            if ((object = treeModel.getChild(object, nArray[i])) == null) {
                return null;
            }
            treePath = treePath.pathByAddingChild(object);
        }
        return treePath;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        int n = this.getPreferredSize().width;
        int n2 = this.getVisibleRowCount();
        int n3 = -1;
        if (this.isFixedRowHeight()) {
            n3 = n2 * this.getRowHeight();
        } else {
            TreeUI treeUI = this.getUI();
            if (treeUI != null && n2 > 0) {
                Rectangle rectangle;
                int n4 = treeUI.getRowCount(this);
                if (n4 >= n2) {
                    Rectangle rectangle2 = this.getRowBounds(n2 - 1);
                    if (rectangle2 != null) {
                        n3 = rectangle2.y + rectangle2.height;
                    }
                } else if (n4 > 0 && (rectangle = this.getRowBounds(0)) != null) {
                    n3 = rectangle.height * n2;
                }
            }
            if (n3 == -1) {
                n3 = 16 * n2;
            }
        }
        return new Dimension(n, n3);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            int n3 = this.getClosestRowForLocation(0, rectangle.y);
            if (n3 != -1) {
                Rectangle rectangle2 = this.getRowBounds(n3);
                if (rectangle2.y != rectangle.y) {
                    if (n2 < 0) {
                        return Math.max(0, rectangle.y - rectangle2.y);
                    }
                    return rectangle2.y + rectangle2.height - rectangle.y;
                }
                if (n2 < 0) {
                    if (n3 != 0) {
                        rectangle2 = this.getRowBounds(n3 - 1);
                        return rectangle2.height;
                    }
                } else {
                    return rectangle2.height;
                }
            }
            return 0;
        }
        return 4;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (container instanceof JViewport) {
            return container.getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (container instanceof JViewport) {
            return container.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExpandedState(TreePath treePath, boolean bl) {
        if (treePath != null) {
            TreePath treePath2 = treePath.getParentPath();
            Stack<Object> stack = this.expandedStack.size() == 0 ? new Stack() : this.expandedStack.pop();
            try {
                while (treePath2 != null) {
                    if (this.isExpanded(treePath2)) {
                        treePath2 = null;
                        continue;
                    }
                    stack.push(treePath2);
                    treePath2 = treePath2.getParentPath();
                }
                for (int i = stack.size() - 1; i >= 0; --i) {
                    treePath2 = (TreePath)stack.pop();
                    if (this.isExpanded(treePath2)) continue;
                    try {
                        this.fireTreeWillExpand(treePath2);
                    }
                    catch (ExpandVetoException expandVetoException) {
                        if (this.expandedStack.size() < TEMP_STACK_SIZE) {
                            stack.removeAllElements();
                            this.expandedStack.push(stack);
                        }
                        return;
                    }
                    this.expandedState.put(treePath2, Boolean.TRUE);
                    this.fireTreeExpanded(treePath2);
                    if (this.accessibleContext == null) continue;
                    ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
            finally {
                if (this.expandedStack.size() < TEMP_STACK_SIZE) {
                    stack.removeAllElements();
                    this.expandedStack.push(stack);
                }
            }
            if (!bl) {
                Boolean bl2 = this.expandedState.get(treePath);
                if (bl2 != null && bl2.booleanValue()) {
                    try {
                        this.fireTreeWillCollapse(treePath);
                    }
                    catch (ExpandVetoException expandVetoException) {
                        return;
                    }
                    this.expandedState.put(treePath, Boolean.FALSE);
                    this.fireTreeCollapsed(treePath);
                    if (this.removeDescendantSelectedPaths(treePath, false) && !this.isPathSelected(treePath)) {
                        this.addSelectionPath(treePath);
                    }
                    if (this.accessibleContext != null) {
                        ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                    }
                }
            } else {
                Boolean bl3 = this.expandedState.get(treePath);
                if (bl3 == null || !bl3.booleanValue()) {
                    try {
                        this.fireTreeWillExpand(treePath);
                    }
                    catch (ExpandVetoException expandVetoException) {
                        return;
                    }
                    this.expandedState.put(treePath, Boolean.TRUE);
                    this.fireTreeExpanded(treePath);
                    if (this.accessibleContext != null) {
                        ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                    }
                }
            }
        }
    }

    protected Enumeration<TreePath> getDescendantToggledPaths(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Vector<TreePath> vector = new Vector<TreePath>();
        Enumeration<TreePath> enumeration = this.expandedState.keys();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2 = enumeration.nextElement();
            if (!treePath.isDescendant(treePath2)) continue;
            vector.addElement(treePath2);
        }
        return vector.elements();
    }

    protected void removeDescendantToggledPaths(Enumeration<TreePath> enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Enumeration<TreePath> enumeration2 = this.getDescendantToggledPaths(enumeration.nextElement());
                if (enumeration2 == null) continue;
                while (enumeration2.hasMoreElements()) {
                    this.expandedState.remove(enumeration2.nextElement());
                }
            }
        }
    }

    protected void clearToggledPaths() {
        this.expandedState.clear();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    protected boolean removeDescendantSelectedPaths(TreePath treePath, boolean bl) {
        TreePath[] treePathArray = this.getDescendantSelectedPaths(treePath, bl);
        if (treePathArray != null) {
            this.getSelectionModel().removeSelectionPaths(treePathArray);
            return true;
        }
        return false;
    }

    private TreePath[] getDescendantSelectedPaths(TreePath treePath, boolean bl) {
        TreePath[] treePathArray;
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        TreePath[] treePathArray2 = treePathArray = treeSelectionModel != null ? treeSelectionModel.getSelectionPaths() : null;
        if (treePathArray != null) {
            boolean bl2 = false;
            for (int i = treePathArray.length - 1; i >= 0; --i) {
                if (treePathArray[i] != null && treePath.isDescendant(treePathArray[i]) && (!treePath.equals(treePathArray[i]) || bl)) {
                    bl2 = true;
                    continue;
                }
                treePathArray[i] = null;
            }
            if (!bl2) {
                treePathArray = null;
            }
            return treePathArray;
        }
        return null;
    }

    void removeDescendantSelectedPaths(TreeModelEvent treeModelEvent) {
        TreePath treePath = SwingUtilities2.getTreePath(treeModelEvent, this.getModel());
        Object[] objectArray = treeModelEvent.getChildren();
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        if (treeSelectionModel != null && treePath != null && objectArray != null && objectArray.length > 0) {
            for (int i = objectArray.length - 1; i >= 0; --i) {
                this.removeDescendantSelectedPaths(treePath.pathByAddingChild(objectArray[i]), true);
            }
        }
    }

    @Override
    void setUIProperty(String string, Object object) {
        if (string == ROW_HEIGHT_PROPERTY) {
            if (!this.rowHeightSet) {
                this.setRowHeight(((Number)object).intValue());
                this.rowHeightSet = false;
            }
        } else if (string == SCROLLS_ON_EXPAND_PROPERTY) {
            if (!this.scrollsOnExpandSet) {
                this.setScrollsOnExpand((Boolean)object);
                this.scrollsOnExpandSet = false;
            }
        } else if (string == SHOWS_ROOT_HANDLES_PROPERTY) {
            if (!this.showsRootHandlesSet) {
                this.setShowsRootHandles((Boolean)object);
                this.showsRootHandlesSet = false;
            }
        } else {
            super.setUIProperty(string, object);
        }
    }

    @Override
    protected String paramString() {
        String string = this.rootVisible ? "true" : "false";
        String string2 = this.showsRootHandles ? "true" : "false";
        String string3 = this.editable ? "true" : "false";
        String string4 = this.largeModel ? "true" : "false";
        String string5 = this.invokesStopCellEditing ? "true" : "false";
        String string6 = this.scrollsOnExpand ? "true" : "false";
        return super.paramString() + ",editable=" + string3 + ",invokesStopCellEditing=" + string5 + ",largeModel=" + string4 + ",rootVisible=" + string + ",rowHeight=" + this.rowHeight + ",scrollsOnExpand=" + string6 + ",showsRootHandles=" + string2 + ",toggleClickCount=" + this.toggleClickCount + ",visibleRowCount=" + this.visibleRowCount;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTree();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTree
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    TreeSelectionListener,
    TreeModelListener,
    TreeExpansionListener {
        TreePath leadSelectionPath;
        Accessible leadSelectionAccessible;

        public AccessibleJTree() {
            super(JTree.this);
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                treeModel.addTreeModelListener(this);
            }
            JTree.this.addTreeExpansionListener(this);
            JTree.this.addTreeSelectionListener(this);
            this.leadSelectionPath = JTree.this.getLeadSelectionPath();
            this.leadSelectionAccessible = this.leadSelectionPath != null ? new AccessibleJTreeNode(JTree.this, this.leadSelectionPath, JTree.this) : null;
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.firePropertyChange("AccessibleSelection", false, true);
        }

        public void fireVisibleDataPropertyChange() {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.fireVisibleDataPropertyChange();
            TreePath treePath = treeExpansionEvent.getPath();
            if (treePath != null) {
                AccessibleJTreeNode accessibleJTreeNode = new AccessibleJTreeNode(JTree.this, treePath, null);
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(accessibleJTreeNode, "AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
                this.firePropertyChange("AccessibleState", null, propertyChangeEvent);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.fireVisibleDataPropertyChange();
            TreePath treePath = treeExpansionEvent.getPath();
            if (treePath != null) {
                AccessibleJTreeNode accessibleJTreeNode = new AccessibleJTreeNode(JTree.this, treePath, null);
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(accessibleJTreeNode, "AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
                this.firePropertyChange("AccessibleState", null, propertyChangeEvent);
            }
        }

        void fireActiveDescendantPropertyChange(TreePath treePath, TreePath treePath2) {
            if (treePath != treePath2) {
                AccessibleJTreeNode accessibleJTreeNode = treePath != null ? new AccessibleJTreeNode(JTree.this, treePath, null) : null;
                AccessibleJTreeNode accessibleJTreeNode2 = treePath2 != null ? new AccessibleJTreeNode(JTree.this, treePath2, null) : null;
                this.firePropertyChange("AccessibleActiveDescendant", accessibleJTreeNode, accessibleJTreeNode2);
            }
        }

        private AccessibleContext getCurrentAccessibleContext() {
            Component component = this.getCurrentComponent();
            if (component instanceof Accessible) {
                return component.getAccessibleContext();
            }
            return null;
        }

        private Component getCurrentComponent() {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel == null) {
                return null;
            }
            Object object = treeModel.getRoot();
            if (object == null) {
                return null;
            }
            TreePath treePath = new TreePath(object);
            if (JTree.this.isVisible(treePath)) {
                TreeCellRenderer treeCellRenderer = JTree.this.getCellRenderer();
                TreeUI treeUI = JTree.this.getUI();
                if (treeUI != null) {
                    int n = treeUI.getRowForPath(JTree.this, treePath);
                    int n2 = JTree.this.getLeadSelectionRow();
                    boolean bl = JTree.this.isFocusOwner() && n2 == n;
                    boolean bl2 = JTree.this.isPathSelected(treePath);
                    boolean bl3 = JTree.this.isExpanded(treePath);
                    return treeCellRenderer.getTreeCellRendererComponent(JTree.this, object, bl2, bl3, treeModel.isLeaf(object), n, bl);
                }
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            TreePath treePath = JTree.this.getClosestPathForLocation(point.x, point.y);
            if (treePath != null) {
                return new AccessibleJTreeNode(JTree.this, treePath, null);
            }
            return null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel == null) {
                return 0;
            }
            if (JTree.this.isRootVisible()) {
                return 1;
            }
            Object object = treeModel.getRoot();
            if (object == null) {
                return 0;
            }
            return treeModel.getChildCount(object);
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel == null) {
                return null;
            }
            Object object = treeModel.getRoot();
            if (object == null) {
                return null;
            }
            if (JTree.this.isRootVisible()) {
                if (n == 0) {
                    Object[] objectArray = new Object[]{object};
                    if (objectArray[0] == null) {
                        return null;
                    }
                    TreePath treePath = new TreePath(objectArray);
                    return new AccessibleJTreeNode(JTree.this, treePath, JTree.this);
                }
                return null;
            }
            int n2 = treeModel.getChildCount(object);
            if (n < 0 || n >= n2) {
                return null;
            }
            Object object2 = treeModel.getChild(object, n);
            if (object2 == null) {
                return null;
            }
            Object[] objectArray = new Object[]{object, object2};
            TreePath treePath = new TreePath(objectArray);
            return new AccessibleJTreeNode(JTree.this, treePath, JTree.this);
        }

        @Override
        public int getAccessibleIndexInParent() {
            return super.getAccessibleIndexInParent();
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            Object[] objectArray = new Object[]{JTree.this.treeModel.getRoot()};
            if (objectArray[0] == null) {
                return 0;
            }
            TreePath treePath = new TreePath(objectArray);
            if (JTree.this.isPathSelected(treePath)) {
                return 1;
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            if (n == 0) {
                Object[] objectArray = new Object[]{JTree.this.treeModel.getRoot()};
                if (objectArray[0] == null) {
                    return null;
                }
                TreePath treePath = new TreePath(objectArray);
                if (JTree.this.isPathSelected(treePath)) {
                    return new AccessibleJTreeNode(JTree.this, treePath, JTree.this);
                }
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            if (n == 0) {
                Object[] objectArray = new Object[]{JTree.this.treeModel.getRoot()};
                if (objectArray[0] == null) {
                    return false;
                }
                TreePath treePath = new TreePath(objectArray);
                return JTree.this.isPathSelected(treePath);
            }
            return false;
        }

        @Override
        public void addAccessibleSelection(int n) {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null && n == 0) {
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                if (objectArray[0] == null) {
                    return;
                }
                TreePath treePath = new TreePath(objectArray);
                JTree.this.addSelectionPath(treePath);
            }
        }

        @Override
        public void removeAccessibleSelection(int n) {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null && n == 0) {
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                if (objectArray[0] == null) {
                    return;
                }
                TreePath treePath = new TreePath(objectArray);
                JTree.this.removeSelectionPath(treePath);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            int n = this.getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                this.removeAccessibleSelection(i);
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                if (objectArray[0] == null) {
                    return;
                }
                TreePath treePath = new TreePath(objectArray);
                JTree.this.addSelectionPath(treePath);
            }
        }

        protected class AccessibleJTreeNode
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent,
        AccessibleSelection,
        AccessibleAction {
            private JTree tree = null;
            private TreeModel treeModel = null;
            private Object obj = null;
            private TreePath path = null;
            private Accessible accessibleParent = null;
            private int index = 0;
            private boolean isLeaf = false;

            public AccessibleJTreeNode(JTree jTree, TreePath treePath, Accessible accessible) {
                this.tree = jTree;
                this.path = treePath;
                this.accessibleParent = accessible;
                this.treeModel = jTree.getModel();
                this.obj = treePath.getLastPathComponent();
                if (this.treeModel != null) {
                    this.isLeaf = this.treeModel.isLeaf(this.obj);
                }
            }

            private TreePath getChildTreePath(int n) {
                if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                    return null;
                }
                Object object = this.treeModel.getChild(this.obj, n);
                Object[] objectArray = this.path.getPath();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray2.length - 1] = object;
                return new TreePath(objectArray2);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component component = this.getCurrentComponent();
                if (component instanceof Accessible) {
                    return component.getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                if (this.tree.isVisible(this.path)) {
                    TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
                    if (treeCellRenderer == null) {
                        return null;
                    }
                    TreeUI treeUI = this.tree.getUI();
                    if (treeUI != null) {
                        int n = treeUI.getRowForPath(JTree.this, this.path);
                        boolean bl = this.tree.isPathSelected(this.path);
                        boolean bl2 = this.tree.isExpanded(this.path);
                        boolean bl3 = false;
                        return treeCellRenderer.getTreeCellRendererComponent(this.tree, this.obj, bl, bl2, this.isLeaf, n, bl3);
                    }
                }
                return null;
            }

            @Override
            public String getAccessibleName() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    String string = accessibleContext.getAccessibleName();
                    if (string != null && string != "") {
                        return accessibleContext.getAccessibleName();
                    }
                    return null;
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return (String)JTree.this.getClientProperty("AccessibleName");
            }

            @Override
            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            @Override
            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                } else if (accessibleStateSet.contains(AccessibleState.VISIBLE)) {
                    accessibleStateSet.remove(AccessibleState.VISIBLE);
                }
                if (this.tree.isPathSelected(this.path)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                if (this.path == JTree.this.getLeadSelectionPath()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                if (!this.isLeaf) {
                    accessibleStateSet.add(AccessibleState.EXPANDABLE);
                }
                if (this.tree.isExpanded(this.path)) {
                    accessibleStateSet.add(AccessibleState.EXPANDED);
                } else {
                    accessibleStateSet.add(AccessibleState.COLLAPSED);
                }
                if (this.tree.isEditable()) {
                    accessibleStateSet.add(AccessibleState.EDITABLE);
                }
                return accessibleStateSet;
            }

            @Override
            public Accessible getAccessibleParent() {
                if (this.accessibleParent == null) {
                    Object[] objectArray = this.path.getPath();
                    if (objectArray.length > 1) {
                        Object object = objectArray[objectArray.length - 2];
                        if (this.treeModel != null) {
                            this.index = this.treeModel.getIndexOfChild(object, this.obj);
                        }
                        Object[] objectArray2 = new Object[objectArray.length - 1];
                        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
                        TreePath treePath = new TreePath(objectArray2);
                        this.accessibleParent = new AccessibleJTreeNode(this.tree, treePath, null);
                        this.setAccessibleParent(this.accessibleParent);
                    } else if (this.treeModel != null) {
                        this.accessibleParent = this.tree;
                        this.index = 0;
                        this.setAccessibleParent(this.accessibleParent);
                    }
                }
                return this.accessibleParent;
            }

            @Override
            public int getAccessibleIndexInParent() {
                Object[] objectArray;
                if (this.accessibleParent == null) {
                    this.getAccessibleParent();
                }
                if ((objectArray = this.path.getPath()).length > 1) {
                    Object object = objectArray[objectArray.length - 2];
                    if (this.treeModel != null) {
                        this.index = this.treeModel.getIndexOfChild(object, this.obj);
                    }
                }
                return this.index;
            }

            @Override
            public int getAccessibleChildrenCount() {
                return this.treeModel.getChildCount(this.obj);
            }

            @Override
            public Accessible getAccessibleChild(int n) {
                if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                    return null;
                }
                Object object = this.treeModel.getChild(this.obj, n);
                Object[] objectArray = this.path.getPath();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray2.length - 1] = object;
                TreePath treePath = new TreePath(objectArray2);
                return new AccessibleJTreeNode(JTree.this, treePath, this);
            }

            @Override
            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return this.tree.getLocale();
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this;
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && this.isLeaf) {
                    return this.getCurrentAccessibleContext().getAccessibleSelection();
                }
                return this;
            }

            @Override
            public AccessibleText getAccessibleText() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return this.getCurrentAccessibleContext().getAccessibleText();
                }
                return null;
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return this.getCurrentAccessibleContext().getAccessibleValue();
                }
                return null;
            }

            @Override
            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            @Override
            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            @Override
            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            @Override
            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            @Override
            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            @Override
            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                Rectangle rectangle2 = this.tree.getVisibleRect();
                return rectangle != null && rectangle2 != null && rectangle2.intersects(rectangle);
            }

            @Override
            public void setVisible(boolean bl) {
            }

            @Override
            public boolean isShowing() {
                return this.tree.isShowing() && this.isVisible();
            }

            @Override
            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            @Override
            public Point getLocationOnScreen() {
                if (this.tree != null) {
                    Point point = this.tree.getLocationOnScreen();
                    Rectangle rectangle = this.tree.getPathBounds(this.path);
                    if (point != null && rectangle != null) {
                        Point point2 = new Point(rectangle.x, rectangle.y);
                        point2.translate(point.x, point.y);
                        return point2;
                    }
                    return null;
                }
                return null;
            }

            protected Point getLocationInJTree() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                if (rectangle != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            @Override
            public Point getLocation() {
                Rectangle rectangle = this.getBounds();
                if (rectangle != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            @Override
            public void setLocation(Point point) {
            }

            @Override
            public Rectangle getBounds() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                Accessible accessible = this.getAccessibleParent();
                if (accessible != null && accessible instanceof AccessibleJTreeNode) {
                    Point point = ((AccessibleJTreeNode)accessible).getLocationInJTree();
                    if (point != null && rectangle != null) {
                        rectangle.translate(-point.x, -point.y);
                    } else {
                        return null;
                    }
                }
                return rectangle;
            }

            @Override
            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            @Override
            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            @Override
            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            @Override
            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            @Override
            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }

            @Override
            public int getAccessibleSelectionCount() {
                int n = 0;
                int n2 = this.getAccessibleChildrenCount();
                for (int i = 0; i < n2; ++i) {
                    TreePath treePath = this.getChildTreePath(i);
                    if (!this.tree.isPathSelected(treePath)) continue;
                    ++n;
                }
                return n;
            }

            @Override
            public Accessible getAccessibleSelection(int n) {
                int n2 = this.getAccessibleChildrenCount();
                if (n < 0 || n >= n2) {
                    return null;
                }
                int n3 = 0;
                for (int i = 0; i < n2 && n >= n3; ++i) {
                    TreePath treePath = this.getChildTreePath(i);
                    if (!this.tree.isPathSelected(treePath)) continue;
                    if (n3 == n) {
                        return new AccessibleJTreeNode(this.tree, treePath, this);
                    }
                    ++n3;
                }
                return null;
            }

            @Override
            public boolean isAccessibleChildSelected(int n) {
                int n2 = this.getAccessibleChildrenCount();
                if (n < 0 || n >= n2) {
                    return false;
                }
                TreePath treePath = this.getChildTreePath(n);
                return this.tree.isPathSelected(treePath);
            }

            @Override
            public void addAccessibleSelection(int n) {
                TreeModel treeModel = JTree.this.getModel();
                if (treeModel != null && n >= 0 && n < this.getAccessibleChildrenCount()) {
                    TreePath treePath = this.getChildTreePath(n);
                    JTree.this.addSelectionPath(treePath);
                }
            }

            @Override
            public void removeAccessibleSelection(int n) {
                TreeModel treeModel = JTree.this.getModel();
                if (treeModel != null && n >= 0 && n < this.getAccessibleChildrenCount()) {
                    TreePath treePath = this.getChildTreePath(n);
                    JTree.this.removeSelectionPath(treePath);
                }
            }

            @Override
            public void clearAccessibleSelection() {
                int n = this.getAccessibleChildrenCount();
                for (int i = 0; i < n; ++i) {
                    this.removeAccessibleSelection(i);
                }
            }

            @Override
            public void selectAllAccessibleSelection() {
                TreeModel treeModel = JTree.this.getModel();
                if (treeModel != null) {
                    int n = this.getAccessibleChildrenCount();
                    for (int i = 0; i < n; ++i) {
                        TreePath treePath = this.getChildTreePath(i);
                        JTree.this.addSelectionPath(treePath);
                    }
                }
            }

            @Override
            public int getAccessibleActionCount() {
                AccessibleAction accessibleAction;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.getAccessibleActionCount() + (this.isLeaf ? 0 : 1);
                }
                return this.isLeaf ? 0 : 1;
            }

            @Override
            public String getAccessibleActionDescription(int n) {
                AccessibleAction accessibleAction;
                if (n < 0 || n >= this.getAccessibleActionCount()) {
                    return null;
                }
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (n == 0) {
                    return AccessibleAction.TOGGLE_EXPAND;
                }
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.getAccessibleActionDescription(n - 1);
                }
                return null;
            }

            @Override
            public boolean doAccessibleAction(int n) {
                AccessibleAction accessibleAction;
                if (n < 0 || n >= this.getAccessibleActionCount()) {
                    return false;
                }
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (n == 0) {
                    if (JTree.this.isExpanded(this.path)) {
                        JTree.this.collapsePath(this.path);
                    } else {
                        JTree.this.expandPath(this.path);
                    }
                    return true;
                }
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.doAccessibleAction(n - 1);
                }
                return false;
            }
        }
    }

    public static class DynamicUtilTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasChildren;
        protected Object childValue;
        protected boolean loadedChildren = false;

        public static void createChildren(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
            block4: {
                block5: {
                    block3: {
                        if (!(object instanceof Vector)) break block3;
                        Vector vector = (Vector)object;
                        int n = vector.size();
                        for (int i = 0; i < n; ++i) {
                            defaultMutableTreeNode.add(new DynamicUtilTreeNode(vector.elementAt(i), vector.elementAt(i)));
                        }
                        break block4;
                    }
                    if (!(object instanceof Hashtable)) break block5;
                    Hashtable hashtable = (Hashtable)object;
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        defaultMutableTreeNode.add(new DynamicUtilTreeNode(k, hashtable.get(k)));
                    }
                    break block4;
                }
                if (!(object instanceof Object[])) break block4;
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    defaultMutableTreeNode.add(new DynamicUtilTreeNode(objectArray[i], objectArray[i]));
                }
            }
        }

        public DynamicUtilTreeNode(Object object, Object object2) {
            super(object);
            this.childValue = object2;
            if (object2 != null) {
                if (object2 instanceof Vector) {
                    this.setAllowsChildren(true);
                } else if (object2 instanceof Hashtable) {
                    this.setAllowsChildren(true);
                } else if (object2 instanceof Object[]) {
                    this.setAllowsChildren(true);
                } else {
                    this.setAllowsChildren(false);
                }
            } else {
                this.setAllowsChildren(false);
            }
        }

        @Override
        public boolean isLeaf() {
            return !this.getAllowsChildren();
        }

        @Override
        public int getChildCount() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.loadedChildren = true;
            DynamicUtilTreeNode.createChildren(this, this.childValue);
        }

        @Override
        public TreeNode getChildAt(int n) {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildAt(n);
        }

        @Override
        public Enumeration children() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.children();
        }
    }

    protected class TreeModelHandler
    implements TreeModelListener {
        protected TreeModelHandler() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent == null) {
                return;
            }
            TreePath treePath = SwingUtilities2.getTreePath(treeModelEvent, JTree.this.getModel());
            if (treePath == null) {
                return;
            }
            if (treePath.getPathCount() == 1) {
                JTree.this.clearToggledPaths();
                Object object = JTree.this.treeModel.getRoot();
                if (object != null && !JTree.this.treeModel.isLeaf(object)) {
                    JTree.this.expandedState.put(treePath, Boolean.TRUE);
                }
            } else if (JTree.this.expandedState.get(treePath) != null) {
                Vector<TreePath> vector = new Vector<TreePath>(1);
                boolean bl = JTree.this.isExpanded(treePath);
                vector.addElement(treePath);
                JTree.this.removeDescendantToggledPaths(vector.elements());
                if (bl) {
                    TreeModel treeModel = JTree.this.getModel();
                    if (treeModel == null || treeModel.isLeaf(treePath.getLastPathComponent())) {
                        JTree.this.collapsePath(treePath);
                    } else {
                        JTree.this.expandedState.put(treePath, Boolean.TRUE);
                    }
                }
            }
            JTree.this.removeDescendantSelectedPaths(treePath, false);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeModel treeModel;
            if (treeModelEvent == null) {
                return;
            }
            TreePath treePath = SwingUtilities2.getTreePath(treeModelEvent, JTree.this.getModel());
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray == null) {
                return;
            }
            Vector<TreePath> vector = new Vector<TreePath>(Math.max(1, objectArray.length));
            for (int i = objectArray.length - 1; i >= 0; --i) {
                TreePath treePath2 = treePath.pathByAddingChild(objectArray[i]);
                if (JTree.this.expandedState.get(treePath2) == null) continue;
                vector.addElement(treePath2);
            }
            if (vector.size() > 0) {
                JTree.this.removeDescendantToggledPaths(vector.elements());
            }
            if ((treeModel = JTree.this.getModel()) == null || treeModel.isLeaf(treePath.getLastPathComponent())) {
                JTree.this.expandedState.remove(treePath);
            }
            JTree.this.removeDescendantSelectedPaths(treeModelEvent);
        }
    }

    protected class TreeSelectionRedirector
    implements Serializable,
    TreeSelectionListener {
        protected TreeSelectionRedirector() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeSelectionEvent treeSelectionEvent2 = (TreeSelectionEvent)treeSelectionEvent.cloneWithSource(JTree.this);
            JTree.this.fireValueChanged(treeSelectionEvent2);
        }
    }

    protected static class EmptySelectionModel
    extends DefaultTreeSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        protected EmptySelectionModel() {
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        @Override
        public void setSelectionPaths(TreePath[] treePathArray) {
        }

        @Override
        public void addSelectionPaths(TreePath[] treePathArray) {
        }

        @Override
        public void removeSelectionPaths(TreePath[] treePathArray) {
        }

        @Override
        public void setSelectionMode(int n) {
        }

        @Override
        public void setRowMapper(RowMapper rowMapper) {
        }

        @Override
        public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        }

        @Override
        public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    private class TreeTimer
    extends Timer {
        public TreeTimer() {
            super(2000, null);
            this.setRepeats(false);
        }

        @Override
        public void fireActionPerformed(ActionEvent actionEvent) {
            JTree.this.expandRow(JTree.this.expandRow);
        }
    }

    public static final class DropLocation
    extends TransferHandler.DropLocation {
        private final TreePath path;
        private final int index;

        private DropLocation(Point point, TreePath treePath, int n) {
            super(point);
            this.path = treePath;
            this.index = n;
        }

        public int getChildIndex() {
            return this.index;
        }

        public TreePath getPath() {
            return this.path;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "[dropPoint=" + this.getDropPoint() + ",path=" + this.path + ",childIndex=" + this.index + "]";
        }
    }
}

