/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource;

import java.util.stream.Stream;
import jdk.management.resource.ResourceAccuracy;
import jdk.management.resource.ResourceMeter;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceType;
import jdk.management.resource.internal.SimpleResourceContext;

public interface ResourceContext
extends AutoCloseable {
    @Override
    public void close();

    public String getName();

    default public ResourceContext bindThreadContext() {
        throw new UnsupportedOperationException("bind not supported by " + this.getName());
    }

    public static ResourceContext unbindThreadContext() {
        return SimpleResourceContext.unbindThreadContext();
    }

    default public Stream<Thread> boundThreads() {
        throw new UnsupportedOperationException("boundThreads not supported by " + this.getName());
    }

    public ResourceRequest getResourceRequest(ResourceType var1);

    default public void addResourceMeter(ResourceMeter resourceMeter) {
        throw new UnsupportedOperationException("addResourceMeter not supported by " + this.getName());
    }

    default public boolean removeResourceMeter(ResourceMeter resourceMeter) {
        throw new UnsupportedOperationException("removeResourceMeter not supported by " + this.getName());
    }

    public ResourceMeter getMeter(ResourceType var1);

    public Stream<ResourceMeter> meters();

    default public void requestAccurateUpdate(ResourceAccuracy resourceAccuracy) {
        throw new UnsupportedOperationException("requestAccurateUpdate not supported by " + this.getName());
    }
}

