/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="java.net.DatagramSocket")
public final class DatagramSocketRMHooks {
    @InstrumentationMethod
    public InetAddress getLocalAddress() {
        return this.getLocalAddress();
    }

    @InstrumentationMethod
    public boolean isBound() {
        return this.isBound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public synchronized void bind(SocketAddress socketAddress) throws SocketException {
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (!this.isBound()) {
            resourceIdImpl = ResourceIdImpl.of(socketAddress);
            resourceRequest = ApproverGroup.DATAGRAM_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new SocketException("Resource limited: too many open datagram sockets");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                SocketException socketException = new SocketException("Resource limited: too many open datagram sockets");
                socketException.initCause(resourceRequestDeniedException);
                throw socketException;
            }
        }
        int n = 0;
        try {
            this.bind(socketAddress);
            n = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n), resourceIdImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    private synchronized void connectInternal(InetAddress inetAddress, int n) throws SocketException {
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (!this.isBound()) {
            resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
            resourceRequest = ApproverGroup.DATAGRAM_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new SocketException("Resource limited: too many open datagram sockets");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                SocketException socketException = new SocketException("Resource limited: too many open datagram sockets");
                socketException.initCause(resourceRequestDeniedException);
                throw socketException;
            }
        }
        int n2 = 0;
        try {
            this.connectInternal(inetAddress, n);
            n2 = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n2), resourceIdImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.DATAGRAM_RECEIVED_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(1L, resourceIdImpl), 0L);
            if (l < 1L) {
                throw new IOException("Resource limited: too many received datagrams");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited: too many received datagrams", resourceRequestDeniedException);
        }
        int n = Math.max(datagramPacket.getLength(), 0);
        if (n > 0) {
            ResourceRequest resourceRequest2 = ApproverGroup.DATAGRAM_READ_GROUP.getApprover(this);
            try {
                l = Math.max(resourceRequest2.request(n, resourceIdImpl), 0L);
                if (l < (long)n) {
                    resourceRequest.request(-1L, resourceIdImpl);
                    throw new IOException("Resource limited: insufficient bytes approved");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                resourceRequest.request(-1L, resourceIdImpl);
                throw new IOException("Resource limited: insufficient bytes approved", resourceRequestDeniedException);
            }
            int n2 = 0;
            int n3 = 0;
            try {
                this.receive(datagramPacket);
                n2 = datagramPacket.getLength();
                n3 = 1;
            }
            finally {
                resourceRequest2.request(-(l - (long)n2), resourceIdImpl);
                resourceRequest.request(-(1 - n3), resourceIdImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void send(DatagramPacket datagramPacket) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.DATAGRAM_SENT_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(1L, resourceIdImpl), 0L);
            if (l < 1L) {
                throw new IOException("Resource limited: too many sent datagrams");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited: too many sent datagrams", resourceRequestDeniedException);
        }
        int n = Math.max(datagramPacket.getLength(), 0);
        if (n > 0) {
            ResourceRequest resourceRequest2 = ApproverGroup.DATAGRAM_WRITE_GROUP.getApprover(this);
            try {
                l = Math.max(resourceRequest2.request(n, resourceIdImpl), 0L);
                if (l < (long)n) {
                    resourceRequest.request(-1L, resourceIdImpl);
                    throw new IOException("Resource limited: insufficient bytes approved");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                resourceRequest.request(-1L, resourceIdImpl);
                throw new IOException("Resource limited: too many sent datagrams", resourceRequestDeniedException);
            }
            int n2 = 0;
            try {
                this.send(datagramPacket);
                n2 = datagramPacket.getLength();
            }
            finally {
                resourceRequest2.request(-(l - (long)n2), resourceIdImpl);
            }
        }
    }

    @InstrumentationMethod
    public boolean isClosed() {
        return this.isClosed();
    }

    @InstrumentationMethod
    public boolean isConnected() {
        return this.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void close() {
        if (this.isClosed()) {
            return;
        }
        boolean bl = this.isBound();
        InetAddress inetAddress = this.getLocalAddress();
        try {
            this.close();
        }
        finally {
            if (bl) {
                ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(inetAddress);
                ResourceRequest resourceRequest = ApproverGroup.DATAGRAM_OPEN_GROUP.getApprover(this);
                resourceRequest.request(-1L, resourceIdImpl);
            }
        }
    }
}

