/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.IOException;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.internal.instrumentation.TypeMapping;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="java.net.SocketOutputStream")
@TypeMapping(from="jdk.management.resource.internal.inst.SocketOutputStreamRMHooks$AbstractPlainSocketImpl", to="java.net.AbstractPlainSocketImpl")
public final class SocketOutputStreamRMHooks {
    private AbstractPlainSocketImpl impl = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    private void socketWrite(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            this.socketWrite(byArray, n, n2);
            return;
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.impl.localport);
        ResourceRequest resourceRequest = ApproverGroup.SOCKET_WRITE_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = resourceRequest.request(n2, resourceIdImpl);
            if (l < (long)n2) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n3 = 0;
        try {
            this.socketWrite(byArray, n, n2);
            n3 = n2;
        }
        finally {
            resourceRequest.request(-(l - (long)n3), resourceIdImpl);
        }
    }

    static class AbstractPlainSocketImpl {
        protected int localport;

        AbstractPlainSocketImpl() {
        }
    }
}

