/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="sun.nio.ch.UnixAsynchronousServerSocketChannelImpl")
public class UnixAsynchronousServerSocketChannelImplRMHooks {
    private static final NativeDispatcher nd = null;
    protected volatile InetSocketAddress localAddress = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    private int accept(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, InetSocketAddress[] inetSocketAddressArray) throws IOException {
        int n = this.accept(fileDescriptor, fileDescriptor2, inetSocketAddressArray);
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(fileDescriptor2);
        if (resourceIdImpl != null) {
            ResourceRequest resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(fileDescriptor2);
            long l = 0L;
            long l2 = 0L;
            try {
                try {
                    l = resourceRequest.request(1L, resourceIdImpl);
                    if (l < 1L) {
                        throw new IOException("Resource limited: too many open file descriptors");
                    }
                }
                catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                    throw new IOException("Resource limited: too many open file descriptors", resourceRequestDeniedException);
                }
                l2 = 1L;
            }
            finally {
                if (l2 == 0L) {
                    try {
                        nd.close(fileDescriptor2);
                    }
                    catch (IOException iOException) {}
                } else {
                    resourceRequest.request(-(l - 1L), resourceIdImpl);
                }
            }
        }
        return n;
    }

    @InstrumentationMethod
    void implClose() throws IOException {
        try {
            this.implClose();
        }
        finally {
            if (this.localAddress != null) {
                ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.localAddress);
                ResourceRequest resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
                resourceRequest.request(-1L, resourceIdImpl);
            }
        }
    }

    abstract class NativeDispatcher {
        NativeDispatcher() {
        }

        abstract void close(FileDescriptor var1) throws IOException;
    }
}

