/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.PlatformManagedObject;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import jdk.internal.cmm.SystemResourcePressureImpl;
import jdk.management.cmm.SystemResourcePressureMXBean;
import sun.management.Flag;

public final class ExtendedPlatformComponent {
    private static SystemResourcePressureMXBean cmmBeanImpl = null;

    private ExtendedPlatformComponent() {
    }

    private static synchronized SystemResourcePressureMXBean getCMMBean() {
        if (cmmBeanImpl == null) {
            cmmBeanImpl = new SystemResourcePressureImpl();
        }
        return cmmBeanImpl;
    }

    public static List<? extends PlatformManagedObject> getMXBeans() {
        if (ExtendedPlatformComponent.shouldRegisterCMMBean()) {
            return Collections.singletonList(ExtendedPlatformComponent.getCMMBean());
        }
        return Collections.emptyList();
    }

    public static <T extends PlatformManagedObject> T getMXBean(Class<T> clazz) {
        if (clazz != null && "jdk.management.cmm.SystemResourcePressureMXBean".equals(clazz.getName())) {
            if (ExtendedPlatformComponent.isUnlockCommercialFeaturesEnabled()) {
                return (T)((PlatformManagedObject)clazz.cast(ExtendedPlatformComponent.getCMMBean()));
            }
            throw new IllegalArgumentException("Cooperative Memory Management is a commercial feature which must be unlocked before being used.  To learn more about commercial features and how to unlock them visit http://www.oracle.com/technetwork/java/javaseproducts/");
        }
        return null;
    }

    private static boolean shouldRegisterCMMBean() {
        if (!ExtendedPlatformComponent.isUnlockCommercialFeaturesEnabled()) {
            return false;
        }
        boolean bl = false;
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            if (classLoader == null) {
                return false;
            }
            clazz = Class.forName("com.oracle.exalogic.ExaManager", false, classLoader = classLoader.getParent());
            Object object = clazz.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
            if (object != null) {
                Object object2 = clazz.getMethod("isExalogicSystem", new Class[0]).invoke(object, new Object[0]);
                bl = (Boolean)object2;
            }
            return bl;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            return false;
        }
    }

    private static boolean isUnlockCommercialFeaturesEnabled() {
        Flag flag = Flag.getFlag("UnlockCommercialFeatures");
        return flag != null && "true".equals(flag.getVMOption().getValue());
    }
}

