/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class PasswdEncryption {
    private static final String delimiter = ":";
    public static final int MAX_ENCRYPTION_LENGHT = 100;

    public static String encrypt(String string) throws IOException, GeneralSecurityException {
        return PasswdEncryption.encrypt(string, PasswdEncryption.getPublicKey());
    }

    public static byte[] encrypt(byte[] byArray) throws IOException, GeneralSecurityException {
        return PasswdEncryption.encrypt(byArray, PasswdEncryption.getPublicKey());
    }

    public static byte[] encrypt(byte[] byArray, PublicKey publicKey) throws IOException, GeneralSecurityException {
        assert (byArray.length <= 100);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        byte[] byArray2 = null;
        byArray2 = cipher.doFinal(byArray);
        return byArray2;
    }

    public static byte[] decrypt(byte[] byArray, PrivateKey privateKey) throws IOException, GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        byte[] byArray2 = null;
        byArray2 = cipher.doFinal(byArray);
        return byArray2;
    }

    public static String encrypt(String string, PublicKey publicKey) throws IOException, GeneralSecurityException {
        byte[] byArray = PasswdEncryption.encrypt(string.getBytes(), publicKey);
        return PasswdEncryption.arrayToString(byArray);
    }

    public static String decrypt(String string, PrivateKey privateKey) throws IOException, GeneralSecurityException {
        byte[] byArray = PasswdEncryption.decrypt(PasswdEncryption.stringToArray(string), privateKey);
        return new String(byArray);
    }

    private static String arrayToString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            string = string.concat(Byte.toString(by) + delimiter);
        }
        return string;
    }

    private static byte[] stringToArray(String string) {
        String[] stringArray = string.split(delimiter);
        byte[] byArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            byArray[i] = Byte.parseByte(stringArray[i]);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PublicKey getPublicKey() throws IOException, GeneralSecurityException {
        InputStream inputStream = PasswdEncryption.class.getResourceAsStream("pubKey");
        byte[] byArray = new byte[inputStream.available()];
        try {
            inputStream.read(byArray);
        }
        finally {
            inputStream.close();
        }
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        return publicKey;
    }
}

