/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.browser;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.util.ErrorUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class LaunchURL
implements IWorkbenchWindowActionDelegate,
IExecutableExtension {
    private String url;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data != null && data instanceof Hashtable) {
            this.url = (String)((Hashtable)data).get("url");
        }
        if (this.url == null || this.url.length() == 0) {
            this.url = config.getAttribute("url");
        }
    }

    public void run(IAction action) {
        if (this.url == null || "".equals(this.url)) {
            return;
        }
        IBrowser browser = BrowserManager.getInstance().createBrowser(true);
        try {
            browser.displayURL(this.url);
        }
        catch (Exception e) {
            HelpUIPlugin.logError("Exception occurred when opening URL: " + this.url + ".", e);
            ErrorUtil.displayErrorDialog(Messages.LaunchURL_exception);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

