/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.command;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Files {
    private static final String CWD = "_cwd";
    private final BundleContext m_bc;

    public Files(BundleContext bc) {
        this.m_bc = bc;
    }

    @Descriptor(value="get current directory")
    public File cd(@Descriptor(value="automatically supplied shell session") CommandSession session) {
        try {
            return this.cd(session, null);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to get current directory");
        }
    }

    @Descriptor(value="change current directory")
    public File cd(@Descriptor(value="automatically supplied shell session") CommandSession session, @Descriptor(value="target directory") String dir) throws IOException {
        File cwd = (File)session.get(CWD);
        if (cwd == null) {
            cwd = new File(".").getCanonicalFile();
            session.put(CWD, (Object)cwd);
        }
        if (dir == null || dir.length() == 0) {
            return cwd;
        }
        if (!(cwd = new File(cwd, dir)).exists()) {
            throw new IOException("Directory does not exist");
        }
        if (!cwd.isDirectory()) {
            throw new IOException("Target is not a directory");
        }
        session.put(CWD, (Object)cwd.getCanonicalFile());
        return cwd;
    }

    @Descriptor(value="get current directory contents")
    public File[] ls(@Descriptor(value="automatically supplied shell session") CommandSession session) throws IOException {
        return this.ls(session, null);
    }

    @Descriptor(value="get specified path contents")
    public File[] ls(@Descriptor(value="automatically supplied shell session") CommandSession session, @Descriptor(value="path with optionally wildcarded file name") String pattern) throws IOException {
        File[] files;
        boolean isWildcarded;
        pattern = pattern == null || pattern.length() == 0 ? "." : pattern;
        pattern = pattern.charAt(0) != File.separatorChar && pattern.charAt(0) != '.' ? "./" + pattern : pattern;
        int idx = pattern.lastIndexOf(File.separatorChar);
        String parent = idx < 0 ? "." : pattern.substring(0, idx + 1);
        String target = idx < 0 ? pattern : pattern.substring(idx + 1);
        File actualParent = (parent.charAt(0) == File.separatorChar ? new File(parent) : new File(this.cd(session), parent)).getCanonicalFile();
        idx = target.indexOf(File.separatorChar, idx);
        boolean bl = isWildcarded = target.indexOf(42, idx) >= 0;
        if (isWildcarded) {
            if (!actualParent.exists()) {
                throw new IOException("File does not exist");
            }
            final List<String> pieces = Files.parseSubstring(target);
            files = actualParent.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return Files.compareSubstring(pieces, pathname.getName());
                }
            });
        } else {
            File actualTarget = new File(actualParent, target).getCanonicalFile();
            if (!actualTarget.exists()) {
                throw new IOException("File does not exist");
            }
            files = actualTarget.isDirectory() ? actualTarget.listFiles() : new File[]{actualTarget};
        }
        return files;
    }

    public static List<String> parseSubstring(String value) {
        ArrayList<String> pieces = new ArrayList<String>();
        StringBuffer ss = new StringBuffer();
        boolean wasStar = false;
        boolean leftstar = false;
        boolean rightstar = false;
        int idx = 0;
        boolean escaped = false;
        while (true) {
            if (idx >= value.length()) {
                if (wasStar) {
                    rightstar = true;
                    break;
                }
                pieces.add(ss.toString());
                break;
            }
            char c = value.charAt(idx++);
            if (!(escaped || c != '(' && c != ')')) {
                throw new IllegalArgumentException("Illegal value: " + value);
            }
            if (!escaped && c == '*') {
                if (wasStar) {
                    throw new IllegalArgumentException("Invalid filter string: " + value);
                }
                if (ss.length() > 0) {
                    pieces.add(ss.toString());
                }
                ss.setLength(0);
                if (pieces.size() == 0) {
                    leftstar = true;
                }
                wasStar = true;
                continue;
            }
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            escaped = false;
            wasStar = false;
            ss.append(c);
        }
        ss.setLength(0);
        if (leftstar || rightstar || pieces.size() > 1) {
            if (rightstar) {
                pieces.add("");
            }
            if (leftstar) {
                pieces.add(0, "");
            }
        }
        return pieces;
    }

    public static boolean compareSubstring(List<String> pieces, String s) {
        boolean result = true;
        int len = pieces.size();
        int index = 0;
        for (int i = 0; i < len; ++i) {
            String piece = pieces.get(i);
            if (i == 0 && !s.startsWith(piece)) {
                result = false;
                break;
            }
            if (i == len - 1) {
                if (s.endsWith(piece)) {
                    result = true;
                    break;
                }
                result = false;
                break;
            }
            if (i > 0 && i < len - 1 && (index = s.indexOf(piece, index)) < 0) {
                result = false;
                break;
            }
            index += piece.length();
        }
        return result;
    }
}

