/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common.filters;

import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.common.filters.FilterSet;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;

public class FilterUtils {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.filters.Bundle");
    private static final String PROFILE_ALL_CLASSES_FILTER_NAME = bundle.getString("FilterUtils_ProfileAllClassesFilterName");
    private static final String QUICK_FILTER_FILTER_NAME = bundle.getString("FilterUtils_QuickFilterFilterName");
    public static final String PROP_FILTER_TYPE = "profiler.filter.type";
    public static final SimpleFilter NONE_FILTER = new SimpleFilter(PROFILE_ALL_CLASSES_FILTER_NAME, 0, "");
    public static final SimpleFilter QUICK_FILTER = new SimpleFilter(QUICK_FILTER_FILTER_NAME, 1, "");

    public static String[] getSeparateFilters(String string) {
        return string.replace(',', ' ').trim().split(" +");
    }

    public static boolean isValidProfilerFilter(String string) {
        int n = string.length();
        if (n < 1) {
            return true;
        }
        if (string.indexOf("..") != -1) {
            return false;
        }
        char[] cArray = new char[n];
        string.getChars(0, string.length(), cArray, 0);
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return false;
        }
        for (int i = 1; i < n - 1; ++i) {
            if (Character.isJavaIdentifierPart(cArray[i]) || cArray[i] == '.') continue;
            return false;
        }
        return Character.isJavaIdentifierPart(cArray[n - 1]) || cArray[n - 1] == '.' || cArray[n - 1] == '*';
    }

    public static Object loadFilter(Map map) {
        return FilterUtils.loadFilter(map, "");
    }

    public static Object loadFilter(Map map, String string) {
        if (map == null) {
            return null;
        }
        Object v = map.get(string + PROP_FILTER_TYPE);
        if (v == null) {
            return null;
        }
        if (v.equals("profiler.simple.filter")) {
            SimpleFilter simpleFilter = new SimpleFilter();
            simpleFilter.load(map, string);
            return simpleFilter;
        }
        if (v.equals("profiler.filter.set")) {
            FilterSet filterSet = new FilterSet();
            filterSet.load(map, string);
            return filterSet;
        }
        return null;
    }

    public static void storeFilter(Map map, Object object) {
        FilterUtils.storeFilter(map, object, "");
    }

    public static void storeFilter(Map map, Object object, String string) {
        if (map == null) {
            throw new RuntimeException("Cannot store a filter to null properties");
        }
        if (object == null) {
            throw new RuntimeException("Cannot store null filter");
        }
        if (object instanceof SimpleFilter) {
            ((SimpleFilter)object).store(map, string);
            return;
        }
        if (object instanceof FilterSet) {
            ((FilterSet)object).store(map, string);
            return;
        }
        throw new RuntimeException("Unsupported filter type: " + object.getClass().getName());
    }
}

