/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.Registration;
import org.osgi.service.http.HttpContext;

public class FilterRegistration
extends Registration
implements Comparable {
    private static long nextSequenceNumber = 1L;
    private final Filter filter;
    private final HttpContext httpContext;
    private final ClassLoader registeredContextClassLoader;
    private final String prefix;
    private final String suffix;
    private final int priority;
    private final long sequenceNumber;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterRegistration(Filter filter, HttpContext context, String alias, int priority) {
        this.filter = filter;
        this.httpContext = context;
        this.registeredContextClassLoader = Thread.currentThread().getContextClassLoader();
        int lastSlash = alias.lastIndexOf(47);
        String lastSegment = alias.substring(alias.lastIndexOf(47) + 1);
        if (lastSegment.startsWith("*.")) {
            this.prefix = alias.substring(0, lastSlash);
            this.suffix = lastSegment.substring(1);
        } else {
            this.prefix = alias.equals("/") ? "" : alias;
            this.suffix = null;
        }
        this.priority = priority;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.http.servlet.internal.FilterRegistration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            this.sequenceNumber = nextSequenceNumber++;
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    public void destroy() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            super.destroy();
            this.filter.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            this.filter.init(filterConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            if (this.httpContext.handleSecurity(request, response)) {
                this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public boolean matches(String dispatchPathInfo) {
        if (!dispatchPathInfo.startsWith(this.prefix)) {
            return false;
        }
        if (this.prefix.length() == dispatchPathInfo.length()) {
            return this.suffix == null;
        }
        if (dispatchPathInfo.charAt(this.prefix.length()) != '/') {
            return false;
        }
        if (this.suffix == null) {
            return true;
        }
        return dispatchPathInfo.endsWith(this.suffix) && dispatchPathInfo.length() > this.prefix.length() + this.suffix.length();
    }

    public int compareTo(Object other) {
        FilterRegistration otherFilterRegistration = (FilterRegistration)other;
        int priorityDifference = this.priority - otherFilterRegistration.priority;
        if (priorityDifference != 0) {
            return -priorityDifference;
        }
        return this.sequenceNumber > otherFilterRegistration.sequenceNumber ? 1 : -1;
    }
}

