/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.output2.BufferResource;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IntList;
import org.netbeans.core.output2.IntListSimple;
import org.netbeans.core.output2.IntMap;
import org.netbeans.core.output2.LineInfo;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutputKind;
import org.netbeans.core.output2.OutputLimits;
import org.netbeans.core.output2.SparseIntList;
import org.netbeans.core.output2.Storage;
import org.netbeans.core.output2.options.OutputOptions;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Pair;
import org.openide.windows.IOColors;
import org.openide.windows.OutputListener;

abstract class AbstractLines
implements Lines,
Runnable,
ActionListener {
    private static final Logger LOG = Logger.getLogger(AbstractLines.class.getName());
    private OutputLimits outputLimits = OutputLimits.getDefault();
    IntList lineStartList;
    IntListSimple lineCharLengthListWithTabs;
    IntMap lineWithListenerToInfo;
    IntMap linesToInfos;
    private int longestLineLen = 0;
    private int knownCharsPerLine = -1;
    private SparseIntList knownLogicalLineCounts = null;
    private IntList tabCharOffsets = new IntList(128);
    private IntListSimple tabLengthSums = new IntListSimple(128);
    private final IntListSimple foldOffsets = new IntListSimple(16);
    private final IntListSimple visibleList = new IntListSimple(128);
    private final IntListSimple visibleToRealLine = new IntListSimple(128);
    private final IntListSimple realToVisibleLine = new IntListSimple(128);
    private int hiddenLines = 0;
    private int currentFoldStart = -1;
    private int lastStorageSize = -1;
    private ChangeListener listener = null;
    private Timer timer = null;
    private final AtomicBoolean newEvent = new AtomicBoolean(false);
    private boolean dirty;
    private IntList importantLines = new IntList(16);
    private boolean lastLineFinished = true;
    private int lastLineLength = -1;
    private int lastCharLengthWithTabs = -1;
    private static Color[] DEF_COLORS = null;
    Color[] curDefColors;
    private static final int MAX_FIND_SIZE = 16384;
    private Pattern pattern;

    AbstractLines() {
        if (Controller.LOG) {
            Controller.log("Creating a new AbstractLines");
        }
        this.init();
    }

    protected abstract Storage getStorage();

    protected abstract boolean isDisposed();

    protected abstract void handleException(Exception var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getText(int n, int n2, char[] cArray) {
        if (cArray == null) {
            cArray = new char[n2 - n];
        }
        if (n2 < n || n < 0) {
            throw new IllegalArgumentException("Illogical text range from " + n + " to " + n2);
        }
        if (n2 - n > cArray.length) {
            throw new IllegalArgumentException("Array size is too small");
        }
        Object object = this.readLock();
        synchronized (object) {
            char[] cArray2;
            block15: {
                if (this.isDisposed()) {
                    for (int i = 0; i < n2 - n; ++i) {
                        cArray[i] = '\u0000';
                    }
                    return cArray;
                }
                int n3 = AbstractLines.toByteIndex(n);
                int n4 = AbstractLines.toByteIndex(n2 - n);
                BufferResource<ByteBuffer> bufferResource = null;
                try {
                    bufferResource = this.getStorage().getReadBuffer(n3, n4);
                    CharBuffer charBuffer = bufferResource.getBuffer().asCharBuffer();
                    int n5 = Math.min(n2 - n, charBuffer.remaining());
                    charBuffer.get(cArray, 0, n5);
                    cArray2 = cArray;
                    if (bufferResource == null) break block15;
                    bufferResource.releaseBuffer();
                }
                catch (Exception exception) {
                    char[] cArray3;
                    block16: {
                        try {
                            this.handleException(exception);
                            cArray3 = new char[]{};
                            if (bufferResource == null) break block16;
                            bufferResource.releaseBuffer();
                        }
                        catch (Throwable throwable) {
                            if (bufferResource != null) {
                                bufferResource.releaseBuffer();
                            }
                            throw throwable;
                        }
                    }
                    return cArray3;
                }
            }
            return cArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferResource<CharBuffer> getCharBuffer(int n, int n2) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("Illogical text range from " + n + " to " + (n + n2));
        }
        Object object = this.readLock();
        synchronized (object) {
            if (this.isDisposed()) {
                return null;
            }
            int n3 = AbstractLines.toByteIndex(n);
            int n4 = AbstractLines.toByteIndex(n2);
            int n5 = this.getStorage().size();
            if (n5 < n3 + n4) {
                throw new ArrayIndexOutOfBoundsException("Bytes from " + n3 + " to " + (n3 + n4) + " requested, " + "but storage is only " + n5 + " bytes long");
            }
            BufferResource<ByteBuffer> bufferResource = null;
            try {
                bufferResource = this.getStorage().getReadBuffer(n3, n4);
                return new CharBufferResource(bufferResource);
            }
            catch (Exception exception) {
                if (bufferResource != null) {
                    bufferResource.releaseBuffer();
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText(int n, int n2) {
        BufferResource<CharBuffer> bufferResource = this.getCharBuffer(n, n2 - n);
        try {
            String string;
            CharBuffer charBuffer = bufferResource == null ? null : bufferResource.getBuffer();
            String string2 = string = charBuffer != null ? charBuffer.toString() : new String(new char[n2 - n]);
            return string2;
        }
        finally {
            if (bufferResource != null) {
                bufferResource.releaseBuffer();
            }
        }
    }

    void onDispose(int n) {
        this.lastStorageSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getByteSize() {
        Object object = this.readLock();
        synchronized (object) {
            if (this.lastStorageSize >= 0) {
                return this.lastStorageSize;
            }
            Storage storage = this.getStorage();
            int n = storage == null ? 0 : storage.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
        Object object = this.readLock();
        synchronized (object) {
            if (this.getLineCount() > 0) {
                this.fire();
            }
        }
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listener == changeListener) {
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.newEvent.set(false);
        this.fire();
        AtomicBoolean atomicBoolean = this.newEvent;
        synchronized (atomicBoolean) {
            if (!this.newEvent.get()) {
                this.timer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delayedFire() {
        this.newEvent.set(true);
        if (this.listener == null) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer(200, this);
        }
        AtomicBoolean atomicBoolean = this.newEvent;
        synchronized (atomicBoolean) {
            if (this.newEvent.get() && !this.timer.isRunning()) {
                this.timer.start();
            }
        }
    }

    public void fire() {
        if (Controller.LOG) {
            Controller.log(this + ": Writer firing " + this.getStorage().size() + " bytes written");
        }
        if (this.listener != null) {
            Mutex.EVENT.readAccess((Runnable)this);
        }
    }

    @Override
    public void run() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public boolean hasListeners() {
        return this.firstListenerLine() != -1;
    }

    @Override
    public OutputListener getListener(int n, int[] nArray) {
        int n2 = this.getLineAt(n);
        int n3 = this.getLineStart(n2);
        n -= n3;
        LineInfo lineInfo = (LineInfo)this.lineWithListenerToInfo.get(n2);
        if (lineInfo == null) {
            return null;
        }
        int n4 = 0;
        for (LineInfo.Segment segment : lineInfo.getLineSegments()) {
            if (n < segment.getEnd()) {
                if (segment.getListener() != null) {
                    if (nArray != null) {
                        nArray[0] = n3 + n4;
                        nArray[1] = n3 + segment.getEnd();
                    }
                    return segment.getListener();
                }
                return null;
            }
            n4 = segment.getEnd();
        }
        return null;
    }

    @Override
    public boolean isListener(int n, int n2) {
        int[] nArray = new int[2];
        OutputListener outputListener = this.getListener(n, nArray);
        return outputListener == null ? false : nArray[0] == n && nArray[1] == n2;
    }

    private void init() {
        this.knownLogicalLineCounts = null;
        this.lineStartList = new IntList(128);
        this.lineStartList.add(0);
        this.lineCharLengthListWithTabs = new IntListSimple(100);
        this.linesToInfos = new IntMap();
        this.lineWithListenerToInfo = new IntMap();
        this.longestLineLen = 0;
        this.listener = null;
        this.dirty = false;
        this.curDefColors = (Color[])AbstractLines.getDefColors().clone();
    }

    @Override
    public boolean checkDirty(boolean bl) {
        if (this.isDisposed()) {
            return false;
        }
        boolean bl2 = this.dirty;
        if (bl) {
            this.dirty = false;
        }
        return bl2;
    }

    @Override
    public int[] getLinesWithListeners() {
        return this.lineWithListenerToInfo.getKeys();
    }

    @Override
    public int getCharCount() {
        return AbstractLines.toCharIndex(this.getByteSize());
    }

    @Override
    public String getLine(int n) throws IOException {
        int n2 = this.getCharLineStart(n);
        int n3 = AbstractLines.toCharIndex(n < this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) : this.getByteSize());
        return this.getText(n2, n3);
    }

    private int getByteLineLength(int n) {
        if (n == this.lineStartList.size() - 1) {
            return Math.max(0, AbstractLines.toByteIndex(this.lastLineLength));
        }
        int n2 = this.getByteLineStart(n);
        int n3 = n < this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) - 2 * "\n".length() : this.getByteSize();
        return n3 - n2;
    }

    @Override
    public boolean isLineStart(int n) {
        int n2 = AbstractLines.toByteIndex(n);
        return this.lineStartList.contains(n2) || n2 == 0 || n2 == this.getByteSize() && this.lastLineFinished;
    }

    @Override
    public int length(int n) {
        return AbstractLines.toCharIndex(this.getByteLineLength(n));
    }

    @Override
    public int lengthWithTabs(int n) {
        if (n == this.lineCharLengthListWithTabs.size()) {
            return Math.max(0, this.lastCharLengthWithTabs);
        }
        return this.lineCharLengthListWithTabs.get(n);
    }

    @Override
    public int getLineStart(int n) {
        return this.getCharLineStart(n);
    }

    private int getByteLineStart(int n) {
        if (n == this.lineStartList.size() && this.lastLineFinished) {
            return this.getByteSize();
        }
        return this.lineStartList.get(n);
    }

    private int getCharLineStart(int n) {
        return AbstractLines.toCharIndex(this.getByteLineStart(n));
    }

    @Override
    public int getLineAt(int n) {
        int n2 = AbstractLines.toByteIndex(n);
        if (n2 >= this.getByteSize()) {
            return this.getLineCount() - 1;
        }
        return this.lineStartList.findNearest(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineCount() {
        Object object = this.readLock();
        synchronized (object) {
            return this.lineStartList.size();
        }
    }

    @Override
    public Collection<OutputListener> getListenersForLine(int n) {
        LineInfo lineInfo = (LineInfo)this.lineWithListenerToInfo.get(n);
        if (lineInfo == null) {
            return Collections.emptyList();
        }
        return lineInfo.getListeners();
    }

    @Override
    public int firstListenerLine() {
        if (this.isDisposed()) {
            return -1;
        }
        return this.lineWithListenerToInfo.isEmpty() ? -1 : this.lineWithListenerToInfo.first();
    }

    @Override
    public OutputListener nearestListener(int n, boolean bl, int[] nArray) {
        int n2 = this.getLineAt(n);
        int n3 = this.lineWithListenerToInfo.nearest(n2, bl);
        if (n3 < 0) {
            return null;
        }
        LineInfo lineInfo = (LineInfo)this.lineWithListenerToInfo.get(n3);
        int n4 = this.getLineStart(n3);
        OutputListener outputListener = null;
        int[] nArray2 = new int[2];
        if (n2 == n3) {
            if (bl) {
                lineInfo.getFirstListener(nArray2);
                if (nArray2[0] + n4 > n) {
                    n3 = this.lineWithListenerToInfo.nearest(n3 - 1, bl);
                    lineInfo = (LineInfo)this.lineWithListenerToInfo.get(n3);
                    n4 = this.getLineStart(n3);
                    outputListener = lineInfo.getLastListener(nArray2);
                }
            } else {
                lineInfo.getLastListener(nArray2);
                if (nArray2[1] + n4 <= n) {
                    n3 = this.lineWithListenerToInfo.nearest(n3 + 1, bl);
                    lineInfo = (LineInfo)this.lineWithListenerToInfo.get(n3);
                    n4 = this.getLineStart(n3);
                    outputListener = lineInfo.getFirstListener(nArray2);
                }
            }
        } else {
            n = n4;
            OutputListener outputListener2 = outputListener = bl ? lineInfo.getLastListener(nArray2) : lineInfo.getFirstListener(nArray2);
        }
        if (outputListener == null) {
            OutputListener outputListener3 = outputListener = bl ? lineInfo.getListenerBefore(n - n4, nArray2) : lineInfo.getListenerAfter(n - n4, nArray2);
        }
        if (outputListener != null) {
            nArray[0] = nArray2[0] + n4;
            nArray[1] = nArray2[1] + n4;
        }
        return outputListener;
    }

    @Override
    public int getLongestLineLength() {
        return this.longestLineLen;
    }

    @Override
    public void toPhysicalLineIndex(int[] nArray, int n) {
        int n2 = nArray[0];
        if (n2 <= 0) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = AbstractLines.lengthToLineCount(this.lengthWithTabs(0), n);
            return;
        }
        if (n >= this.longestLineLen || this.getLineCount() < 1) {
            nArray[0] = this.visibleToRealLine(n2);
            nArray[1] = 0;
            nArray[2] = 1;
            return;
        }
        int n3 = Math.min(this.findPhysicalLine(n2, n), this.getLineCount() - 1);
        int n4 = this.getLogicalLineCountAbove(n3, n);
        int n5 = this.lengthWithTabs(n3);
        int n6 = AbstractLines.lengthToLineCount(n5, n);
        nArray[0] = n3;
        nArray[1] = n2 - n4;
        nArray[2] = n6;
    }

    private int findPhysicalLine(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
            this.calcLogicalLineCount(n2);
        }
        return this.knownLogicalLineCounts.getNextKey(n);
    }

    @Override
    public int getLogicalLineCountAbove(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 >= this.longestLineLen) {
            return this.realToVisibleLine(n);
        }
        if (n2 != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
            this.calcLogicalLineCount(n2);
        }
        return this.knownLogicalLineCounts.get(n - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLogicalLineCountIfWrappedAt(int n) {
        if (n >= this.longestLineLen) {
            return this.getVisibleLineCount();
        }
        int n2 = this.getLineCount();
        if (n == 0 || n2 == 0) {
            return 0;
        }
        Object object = this.readLock();
        synchronized (object) {
            if (n != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
                this.calcLogicalLineCount(n);
            }
            return this.knownLogicalLineCounts.get(n2 - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumPhysicalChars(int n, int n2, int[] nArray) {
        Object object = this.readLock();
        synchronized (object) {
            int n3;
            int n4;
            int n5 = this.tabCharOffsets.findNearest(n);
            int n6 = n5 >= 0 ? (this.tabCharOffsets.get(n5) < n ? this.tabLengthSums.get(n5) : (n5 > 0 ? this.tabLengthSums.get(n5 - 1) : 0)) : 0;
            int n7 = this.tabCharOffsets.findNearest(n + n2);
            if (n7 < 0) {
                return n2;
            }
            int n8 = n4 = n7 >= 0 ? this.tabLengthSums.get(n7) : 0;
            if (n6 == n4) {
                return n2;
            }
            int n9 = n2 + n6 - n4;
            if (n9 < 0) {
                n9 = 0;
            }
            if ((n7 = this.tabCharOffsets.findNearest(n3 = n + n9)) < 0) {
                n7 = -1;
                n4 = 0;
            } else {
                n4 = this.tabLengthSums.get(n7);
            }
            int n10 = this.tabCharOffsets.size();
            ++n7;
            while (n7 < n10) {
                int n11;
                if (n9 + n4 - n6 < n2) {
                    n11 = this.tabCharOffsets.get(n7);
                    if (n11 - n + (n4 = this.tabLengthSums.get(n7)) - n6 > n2) {
                        n4 = n7 > 0 ? this.tabLengthSums.get(n7 - 1) : 0;
                        n9 = n2 + n6 - n4;
                        if (n9 <= n11 - n) break;
                        n9 = n11 - n;
                        break;
                    }
                } else {
                    if (nArray == null) break;
                    nArray[0] = n9 + n4 - n6 - n2;
                    break;
                }
                n9 = n11 - n;
                ++n7;
            }
            if (n9 < 0) {
                n9 = 0;
            }
            return n9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumLogicalChars(int n, int n2) {
        Object object = this.readLock();
        synchronized (object) {
            int n3 = this.tabCharOffsets.findNearest(n);
            int n4 = n3 >= 0 && this.tabCharOffsets.get(n3) < n ? this.tabLengthSums.get(n3) : (n3 > 0 ? this.tabLengthSums.get(n3 - 1) : 0);
            int n5 = this.tabCharOffsets.findNearest(n + n2 - 1);
            if (n5 < 0) {
                return n2;
            }
            int n6 = this.tabLengthSums.get(n5);
            return n2 + n6 - n4;
        }
    }

    private void registerLineWithListener(int n, LineInfo lineInfo, boolean bl) {
        this.lineWithListenerToInfo.put(n, lineInfo);
        if (bl) {
            this.importantLines.add(n);
        }
    }

    @Override
    public int firstImportantListenerLine() {
        return this.importantLines.size() == 0 ? -1 : this.importantLines.get(0);
    }

    @Override
    public boolean isImportantLine(int n) {
        return this.importantLines.contains(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcLogicalLineCount(int n) {
        Object object = this.readLock();
        synchronized (object) {
            int n2 = this.getLineCount();
            this.knownLogicalLineCounts = new SparseIntList(30);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (!this.isVisible(i)) {
                    this.knownLogicalLineCounts.add(i, n3);
                    continue;
                }
                int n4 = this.lengthWithTabs(i);
                if (n4 > n) {
                    this.knownLogicalLineCounts.add(i, n3 += AbstractLines.lengthToLineCount(n4, n));
                    continue;
                }
                ++n3;
            }
            this.knownCharsPerLine = n;
        }
    }

    static int lengthToLineCount(int n, int n2) {
        return n > n2 ? (n2 == 0 ? n : (n + n2 - 1) / n2) : 1;
    }

    void markDirty() {
        this.dirty = true;
    }

    boolean isLastLineFinished() {
        return this.lastLineFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastLine(int n, int n2) {
        Object object = this.readLock();
        synchronized (object) {
            boolean bl;
            this.longestLineLen = Math.max(this.longestLineLen, n2);
            if (this.knownLogicalLineCounts == null) {
                return;
            }
            if (!(this.currentFoldStart < 0 || this.visibleList.get(this.currentFoldStart) != 0 && this.isVisible(this.currentFoldStart))) {
                if (this.knownLogicalLineCounts.lastIndex() != n) {
                    this.knownLogicalLineCounts.add(n, this.knownLogicalLineCounts.get(n - 1));
                }
                return;
            }
            boolean bl2 = bl = this.knownLogicalLineCounts.lastIndex() == n;
            if (bl) {
                assert (!this.lastLineFinished);
                if (n2 <= this.knownCharsPerLine) {
                    this.knownLogicalLineCounts.removeLast();
                } else {
                    int n3 = this.knownLogicalLineCounts.lastAdded() - AbstractLines.lengthToLineCount(this.lastCharLengthWithTabs, this.knownCharsPerLine) + AbstractLines.lengthToLineCount(n2, this.knownCharsPerLine);
                    this.knownLogicalLineCounts.updateLast(n, n3);
                }
            } else {
                if (n2 <= this.knownCharsPerLine) {
                    return;
                }
                int n4 = this.knownLogicalLineCounts.lastIndex() != -1 ? n - (this.knownLogicalLineCounts.lastIndex() + 1) + this.knownLogicalLineCounts.lastAdded() : Math.max(0, n - 1);
                this.knownLogicalLineCounts.add(n, n4 += AbstractLines.lengthToLineCount(n2, this.knownCharsPerLine));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineUpdated(int n, int n2, int n3, boolean bl) {
        Object object = this.readLock();
        synchronized (object) {
            int n4 = AbstractLines.toCharIndex(n2);
            if (bl) {
                --n4;
            }
            int n5 = this.lineStartList.size() - 1;
            this.updateLastLine(n5, n3);
            if (bl) {
                this.lineStartList.add(n + n2);
                this.updateFolds(n5);
                this.lineCharLengthListWithTabs.add(n3);
            }
            this.lastLineFinished = bl;
            this.lastLineLength = bl ? -1 : n4;
            this.lastCharLengthWithTabs = bl ? -1 : n3;
        }
        this.markDirty();
    }

    private void updateFolds(int n) {
        if (this.currentFoldStart >= this.visibleList.size()) {
            LOG.log(Level.FINE, "currentFoldStart = {0}, visibleList.size() = {1}: Forgetting current fold.", new Object[]{this.currentFoldStart, this.visibleList.size()});
            this.currentFoldStart = -1;
        }
        if (this.currentFoldStart == -1) {
            this.foldOffsets.add(0);
        } else {
            this.foldOffsets.add(n - this.currentFoldStart);
        }
        if (!(this.currentFoldStart == -1 || this.visibleList.get(this.currentFoldStart) != 0 && this.isVisible(this.currentFoldStart))) {
            ++this.hiddenLines;
            this.realToVisibleLine.add(-1);
        } else {
            this.visibleToRealLine.add(n);
            this.realToVisibleLine.add(n - this.hiddenLines);
        }
        this.visibleList.add(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentFoldStart(int n) {
        Object object = this.readLock();
        synchronized (object) {
            if (n > -1 && n + 1 < this.foldOffsets.size() && this.foldOffsets.get(n + 1) != 1) {
                LOG.log(Level.FINE, "Ignoring currentFoldStart at {0}, because foldOffset at {1} is {2}", new Object[]{n, n + 1, this.foldOffsets.get(n + 1)});
                this.currentFoldStart = -1;
            } else if (n >= this.foldOffsets.size()) {
                LOG.log(Level.FINE, "Ignoring currentFoldStart at {0}, foldOffsets.size() is only {1}", new Object[]{n, this.foldOffsets.size()});
                this.currentFoldStart = -1;
            } else {
                this.currentFoldStart = n;
            }
        }
    }

    IntListSimple getFoldOffsets() {
        return this.foldOffsets;
    }

    static int toByteIndex(int n) {
        return n << 1;
    }

    static int toCharIndex(int n) {
        assert (n % 2 == 0) : "bad index: " + n;
        return n >> 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAs(String string) throws IOException {
        Storage storage = this.getStorage();
        if (storage == null) {
            throw new IOException("Data has already been disposed");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            String string2 = System.getProperty("file.encoding");
            if (string2 == null) {
                string2 = "UTF-8";
            }
            Charset charset = Charset.forName(string2);
            CharsetEncoder charsetEncoder = charset.newEncoder();
            String string3 = System.getProperty("line.separator");
            FileChannel fileChannel = fileOutputStream.getChannel();
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string3));
            for (int i = 0; i < this.getLineCount(); ++i) {
                int n = this.getCharLineStart(i);
                int n2 = this.length(i);
                BufferResource<CharBuffer> bufferResource = this.getCharBuffer(n, n2);
                try {
                    CharBuffer charBuffer = bufferResource.getBuffer();
                    ByteBuffer byteBuffer2 = charsetEncoder.encode(charBuffer);
                    fileChannel.write(byteBuffer2);
                    if (i == this.getLineCount() - 1) continue;
                    byteBuffer.rewind();
                    fileChannel.write(byteBuffer);
                    continue;
                }
                finally {
                    if (bufferResource != null) {
                        bufferResource.releaseBuffer();
                    }
                }
            }
            fileChannel.close();
        }
        catch (Throwable throwable) {
            fileOutputStream.close();
            FileUtil.refreshFor((File[])new File[]{new File(string)});
            throw throwable;
        }
        fileOutputStream.close();
        FileUtil.refreshFor((File[])new File[]{new File(string)});
    }

    static Color[] getDefColors() {
        if (DEF_COLORS != null) {
            return DEF_COLORS;
        }
        DEF_COLORS = new Color[]{OutputOptions.getDefault().getColorStandard(), OutputOptions.getDefault().getColorError(), OutputOptions.getDefault().getColorLink(), OutputOptions.getDefault().getColorLinkImportant(), OutputOptions.getDefault().getColorInput()};
        return DEF_COLORS;
    }

    @Override
    public void setDefColor(IOColors.OutputType outputType, Color color) {
        this.curDefColors[outputType.ordinal()] = color;
    }

    @Override
    public Color getDefColor(IOColors.OutputType outputType) {
        return this.curDefColors[outputType.ordinal()];
    }

    @Override
    public LineInfo getLineInfo(int n) {
        LineInfo lineInfo = (LineInfo)this.linesToInfos.get(n);
        if (lineInfo != null) {
            int n2 = this.length(n);
            if (n2 > lineInfo.getEnd()) {
                lineInfo.addSegment(n2, OutputKind.IN, null, null, null, false);
            }
            return lineInfo;
        }
        if (n == this.getLineCount() - 1) {
            LineInfo lineInfo2 = new LineInfo(this);
            try {
                lineInfo2.addSegment(this.getLine(n).length(), OutputKind.OUT, null, null, null, false);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, null, iOException);
            }
            lineInfo2.addSegment(this.length(n), OutputKind.IN, null, null, null, false);
            return lineInfo2;
        }
        return new LineInfo(this, this.length(n));
    }

    public LineInfo getExistingLineInfo(int n) {
        return (LineInfo)this.linesToInfos.get(n);
    }

    private boolean regExpChanged(String string, boolean bl) {
        return this.pattern != null && (!this.pattern.toString().equals(string) || this.pattern.flags() == 2 == bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] find(int n, String string, boolean bl, boolean bl2) {
        Storage storage = this.getStorage();
        if (storage == null) {
            return null;
        }
        if (bl && this.regExpChanged(string, bl2)) {
            this.pattern = null;
        }
        if (!bl && !bl2) {
            string = string.toLowerCase();
        }
        while (true) {
            BufferResource<ByteBuffer> bufferResource = null;
            int n2 = this.getCharCount() - n;
            if (n2 > 16384) {
                int n3 = this.getLineAt(n + 16384);
                n2 = this.getLineStart(n3) + this.length(n3) - n;
            } else if (n2 <= 0) break;
            CharBuffer charBuffer = null;
            try {
                try {
                    bufferResource = storage.getReadBuffer(AbstractLines.toByteIndex(n), AbstractLines.toByteIndex(n2));
                    charBuffer = bufferResource.getBuffer().asCharBuffer();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                if (charBuffer == null) break;
                if (bl) {
                    Matcher matcher;
                    if (this.pattern == null) {
                        Pattern pattern = this.pattern = bl2 ? Pattern.compile(string) : Pattern.compile(string, 2);
                    }
                    if ((matcher = this.pattern.matcher(charBuffer)).find()) {
                        int[] nArray = new int[]{n + matcher.start(), n + matcher.end()};
                        return nArray;
                    }
                } else {
                    int n4;
                    int n5 = n4 = bl2 ? charBuffer.toString().indexOf(string) : charBuffer.toString().toLowerCase().indexOf(string);
                    if (n4 != -1) {
                        int[] nArray = new int[]{n + n4, n + n4 + string.length()};
                        return nArray;
                    }
                }
                n += charBuffer.length();
                continue;
            }
            finally {
                if (bufferResource == null) continue;
                bufferResource.releaseBuffer();
                continue;
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] rfind(int n, String string, boolean bl, boolean bl2) {
        Storage storage = this.getStorage();
        if (storage == null) {
            return null;
        }
        if (bl && this.regExpChanged(string, bl2)) {
            this.pattern = null;
        }
        if (!bl && !bl2) {
            string = string.toLowerCase();
        }
        while (true) {
            int n2;
            if ((n = (n2 = n) - 16384) < 0) {
                n = 0;
            } else {
                int n3 = this.getLineAt(n);
                n = this.getLineStart(n3);
            }
            if (n == n2) break;
            BufferResource<ByteBuffer> bufferResource = null;
            try {
                CharBuffer charBuffer = null;
                try {
                    bufferResource = storage.getReadBuffer(AbstractLines.toByteIndex(n), AbstractLines.toByteIndex(n2 - n));
                    charBuffer = bufferResource.getBuffer().asCharBuffer();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                if (charBuffer == null) break;
                if (bl) {
                    if (this.pattern == null) {
                        this.pattern = bl2 ? Pattern.compile(string) : Pattern.compile(string, 2);
                    }
                    Matcher matcher = this.pattern.matcher(charBuffer);
                    int n4 = -1;
                    int n5 = -1;
                    while (matcher.find()) {
                        n4 = matcher.start();
                        n5 = matcher.end();
                    }
                    if (n4 == -1) continue;
                    int[] nArray = new int[]{n + n4, n + n5};
                    return nArray;
                }
                int n6 = bl2 ? charBuffer.toString().lastIndexOf(string) : charBuffer.toString().toLowerCase().lastIndexOf(string);
                if (n6 == -1) continue;
                int[] nArray = new int[]{n + n6, n + n6 + string.length()};
                return nArray;
            }
            finally {
                if (bufferResource == null) continue;
                bufferResource.releaseBuffer();
                continue;
            }
            break;
        }
        return null;
    }

    public String toString() {
        return this.lineStartList.toString();
    }

    private int addSegment(CharSequence charSequence, int n, int n2, int n3, OutputListener outputListener, boolean bl, OutputKind outputKind, Color color, Color color2) {
        int n4 = this.length(n2);
        if (n4 > 0) {
            LineInfo lineInfo = (LineInfo)this.linesToInfos.get(n2);
            if (lineInfo == null) {
                lineInfo = new LineInfo(this);
                this.linesToInfos.put(n2, lineInfo);
            }
            int n5 = lineInfo.getEnd();
            if (n3 > 0 && n3 != n5) {
                lineInfo.addSegment(n3, OutputKind.OUT, null, null, null, false);
                n5 = n3;
            }
            if (outputListener != null) {
                int n6;
                int n7 = Math.min(n5 + charSequence.length() - n, n4);
                int n8 = Math.min(charSequence.length(), n + n4);
                if (charSequence.charAt(n8 - 1) == '\n') {
                    --n8;
                }
                if (charSequence.charAt(n8 - 1) == '\r') {
                    --n8;
                }
                int n9 = 0;
                while (n9 + n < n8 && Character.isWhitespace(charSequence.charAt(n + n9))) {
                    ++n9;
                }
                if (n9 != n8) {
                    for (n6 = 0; n6 < n8 && Character.isWhitespace(charSequence.charAt(n8 - n6 - 1)); ++n6) {
                    }
                }
                if (n9 > 0) {
                    lineInfo.addSegment(n5 + n9, OutputKind.OUT, null, null, null, false);
                }
                lineInfo.addSegment(n7 - n6, outputKind, outputListener, color, color2, bl);
                if (n6 > 0) {
                    lineInfo.addSegment(n7, OutputKind.OUT, null, null, null, false);
                }
                this.registerLineWithListener(n2, lineInfo, bl);
            } else {
                lineInfo.addSegment(n4, outputKind, outputListener, color, color2, bl);
                if (bl) {
                    this.importantLines.add(n2);
                }
            }
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLinesInfo(CharSequence charSequence, int n, int n2, OutputListener outputListener, boolean bl, OutputKind outputKind, Color color, Color color2) {
        int n3 = 0;
        Object object = this.readLock();
        synchronized (object) {
            int n4 = n2 - this.getLineStart(n);
            for (int i = n; i < this.getLineCount(); ++i) {
                n3 += this.addSegment(charSequence, n3, i, n4, outputListener, bl, outputKind, color, color2) + 1;
                n4 = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLineInfo(int n, LineInfo lineInfo, boolean bl) {
        Object object = this.readLock();
        synchronized (object) {
            this.linesToInfos.put(n, lineInfo);
            if (!lineInfo.getListeners().isEmpty()) {
                this.registerLineWithListener(n, lineInfo, bl);
            }
        }
    }

    private int getTabLength(int n) {
        if (n == 0) {
            return this.tabLengthSums.get(0);
        }
        return this.tabLengthSums.get(n) - this.tabLengthSums.get(n - 1) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int checkLimits() {
        Object object = this.readLock();
        synchronized (object) {
            if (this.getLineCount() >= this.outputLimits.getMaxLines() || this.getCharCount() >= this.outputLimits.getMaxChars() || this.linesToInfos.size() >= 524288) {
                return this.removeOldLines();
            }
            return 0;
        }
    }

    private int removeOldLines() {
        int n = Math.min(this.outputLimits.getRemoveLines(), this.lineStartList.size() / 2);
        int n2 = this.lineStartList.get(n);
        this.lineStartList.compact(n, n2);
        this.lineCharLengthListWithTabs.compact(n, 0);
        this.lineWithListenerToInfo.decrementKeys(n);
        this.linesToInfos.decrementKeys(n);
        int n3 = AbstractLines.toCharIndex(n2);
        int n4 = this.tabCharOffsets.findNearest(n3);
        this.tabCharOffsets.compact(Math.max(0, n4), n3);
        if (n4 > 0) {
            this.tabLengthSums.compact(n4, this.tabLengthSums.get(n4 - 1));
        }
        int n5 = this.importantLines.findNearest(n);
        this.importantLines.compact(Math.max(0, n5), n);
        this.knownLogicalLineCounts = null;
        this.foldOffsets.compact(n, 0);
        for (int i = 0; i < this.foldOffsets.size() && this.foldOffsets.get(i) != 0; ++i) {
            this.foldOffsets.set(i, 0);
        }
        this.visibleList.compact(n, 0);
        this.visibleList.set(0, 1);
        this.realToVisibleLine.compact(n, 0);
        this.currentFoldStart = Math.max(-1, this.currentFoldStart - n);
        this.recomputeRealToVisibleLine();
        this.updateVisibleToRealLines(0);
        this.getStorage().shiftStart(n2);
        this.fire();
        return n2;
    }

    private void recomputeRealToVisibleLine() {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < this.realToVisibleLine.size(); ++i) {
            if (n3 == -1 && this.visibleList.get(i) == 0) {
                n3 = i;
                this.realToVisibleLine.set(i, n++);
                continue;
            }
            if (n3 > -1 && this.foldOffsets.get(i) > 0 && this.foldOffsets.get(i) <= i - n3) {
                this.realToVisibleLine.set(i, -1);
                ++n2;
                continue;
            }
            this.realToVisibleLine.set(i, n++);
            n3 = -1;
        }
        this.hiddenLines = n2;
    }

    void setOutputLimits(OutputLimits outputLimits) {
        this.outputLimits = outputLimits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTabAt(int n, int n2) {
        --n2;
        Object object = this.readLock();
        synchronized (object) {
            LOG.log(Level.FINEST, "addTabAt: i = {0}", n);
            this.tabCharOffsets.add(n);
            int n3 = this.tabLengthSums.size();
            if (n3 > 0) {
                n2 += this.tabLengthSums.get(n3 - 1);
            }
            this.tabLengthSums.add(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeLastTab() {
        Object object = this.readLock();
        synchronized (object) {
            LOG.log(Level.FINEST, "removeLastTabAt");
            int n = this.tabLengthSums.size();
            if (n == 0) {
                return 0;
            }
            this.tabCharOffsets.shorten(this.tabCharOffsets.size() - 1);
            int n2 = n > 1 ? this.tabLengthSums.get(n - 1) - this.tabLengthSums.get(n - 2) : this.tabLengthSums.get(0);
            this.tabLengthSums.shorten(n - 1);
            return n2;
        }
    }

    private boolean isFoldStartValid(int n) {
        return n >= 0 && n < this.foldOffsets.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showFold(int n) {
        Object object = this.readLock();
        synchronized (object) {
            if (this.isFoldStartValid(n)) {
                this.setFoldExpanded(n, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hideFold(int n) {
        Object object = this.readLock();
        synchronized (object) {
            if (this.isFoldStartValid(n)) {
                this.setFoldExpanded(n, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFoldExpanded(int n, boolean bl) {
        Object object = this.readLock();
        synchronized (object) {
            if (this.visibleList.get(n) == (bl ? 1 : 0)) {
                return;
            }
            this.visibleList.set(n, bl ? 1 : 0);
            if (!this.isVisible(n)) {
                return;
            }
            int n2 = this.foldLength(n);
            if (n2 > 0) {
                int n3 = this.updateRealToVisibleIndexesInFold(n, n2, bl);
                for (int i = n + n2 + 1; i < this.realToVisibleLine.size(); ++i) {
                    int n4 = this.realToVisibleLine.get(i);
                    if (n4 == -1) continue;
                    this.realToVisibleLine.set(i, n4 + (bl ? n3 : -n3));
                }
                this.hiddenLines += bl ? -n3 : n3;
                this.updateVisibleToRealLines(n);
                this.foldVisibilityUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hideAllFolds() {
        Object object = this.readLock();
        synchronized (object) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.foldOffsets.size(); ++i) {
                boolean bl;
                boolean bl2 = bl = i + 1 < this.foldOffsets.size() && this.foldOffsets.get(i + 1) == 1;
                if (bl) {
                    this.visibleList.set(i, 0);
                }
                if (this.foldOffsets.get(i) > 0) {
                    this.realToVisibleLine.set(i, -1);
                    ++n2;
                    continue;
                }
                this.realToVisibleLine.set(i, n);
                ++n;
            }
            this.hiddenLines = n2;
            this.updateVisibleToRealLines(0);
            this.foldVisibilityUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showAllFolds() {
        Object object = this.readLock();
        synchronized (object) {
            for (int i = 0; i < this.foldOffsets.size(); ++i) {
                boolean bl;
                boolean bl2 = bl = i + 1 < this.foldOffsets.size() && this.foldOffsets.get(i + 1) == 1;
                if (bl) {
                    this.visibleList.set(i, 1);
                }
                this.realToVisibleLine.set(i, i);
            }
            this.hiddenLines = 0;
            this.updateVisibleToRealLines(0);
            this.foldVisibilityUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showFoldTree(int n) {
        Object object = this.readLock();
        synchronized (object) {
            if (this.isFoldStartValid(n)) {
                this.setFoldTreeExpanded(n, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showFoldAndParentFolds(int n) {
        Object object = this.readLock();
        synchronized (object) {
            int n2;
            int n3 = this.getFoldOffsets().get(n);
            if (n3 > 0 && (n2 = n - n3) >= 0) {
                this.showFoldAndParentFolds(n2);
            }
            this.showFold(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showFoldsForLine(int n) {
        Object object = this.readLock();
        synchronized (object) {
            int n2 = this.getFoldStart(n);
            this.showFoldAndParentFolds(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hideFoldTree(int n) {
        Object object = this.readLock();
        synchronized (object) {
            if (this.isFoldStartValid(n)) {
                this.setFoldTreeExpanded(n, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFoldTreeExpanded(int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        Object object = this.readLock();
        synchronized (object) {
            assert (this.isVisible(n));
            this.visibleList.set(n, n2);
            int n3 = this.realToVisibleLine.get(n);
            int n4 = 0;
            int n5 = 0x7FFFFFFE;
            int n6 = n + 1;
            while (n6 < this.foldOffsets.size()) {
                int n7 = n6 - n;
                if (this.foldOffsets.get(n6) == 0 || this.foldOffsets.get(n6) > n7) break;
                if (n6 + 1 < this.foldOffsets.size() && this.foldOffsets.get(n6 + 1) == 1) {
                    this.visibleList.set(n6, n2);
                }
                int n8 = this.realToVisibleLine.get(n6);
                if (bl && n8 < 0 || !bl && n8 >= 0) {
                    n4 += bl ? 1 : -1;
                }
                this.realToVisibleLine.set(n6, bl ? n3 + n7 : -1);
                n5 = n6++;
            }
            for (n6 = n5 + 1; n6 < this.realToVisibleLine.size(); ++n6) {
                this.realToVisibleLine.set(n6, this.realToVisibleLine.get(n6) + n4);
            }
            this.hiddenLines -= n4;
            this.updateVisibleToRealLines(n);
            this.foldVisibilityUpdated();
        }
    }

    private void foldVisibilityUpdated() {
        if (this.knownCharsPerLine > 0) {
            this.calcLogicalLineCount(this.knownCharsPerLine);
        }
        this.markDirty();
        this.delayedFire();
    }

    private int updateRealToVisibleIndexesInFold(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            int n5 = n + i + 1;
            int n6 = this.foldOffsets.get(n5);
            if (i > 0 && n6 == 1 && this.visibleList.get(n5 - 1) == 0 && n4 == -1) {
                n4 = n5 - 1;
                continue;
            }
            if (n6 <= i + 1 && (n4 == -1 || n6 > n5 - n4)) {
                assert (!bl || this.realToVisibleLine.get(n5) == -1);
                assert (bl || this.realToVisibleLine.get(n5) != -1);
                n4 = -1;
                this.realToVisibleLine.set(n5, bl ? this.realToVisibleLine.get(n) + ++n3 : -1);
                continue;
            }
            if (n6 <= n2 + 1 && n4 != -1) {
                assert (n6 <= n5 - n4);
                continue;
            }
            assert (false) : "Only nested fold expected";
        }
        return n3;
    }

    private void updateVisibleToRealLines(int n) {
        for (int i = n; i < this.getLineCount() - 1; ++i) {
            int n2 = this.realToVisibleLine.get(i);
            if (n2 == -1) continue;
            if (n2 >= this.visibleToRealLine.size()) {
                this.visibleToRealLine.add(i);
                continue;
            }
            this.visibleToRealLine.set(n2, i);
        }
        if (this.visibleToRealLine.size() > this.realToVisibleLine.size() - this.hiddenLines) {
            this.visibleToRealLine.shorten(this.realToVisibleLine.size() - this.hiddenLines);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int visibleToRealLine(int n) {
        Object object = this.readLock();
        synchronized (object) {
            if (n >= this.visibleToRealLine.size()) {
                return n + this.hiddenLines;
            }
            if (n < 0) {
                return n;
            }
            return this.visibleToRealLine.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int realToVisibleLine(int n) {
        Object object = this.readLock();
        synchronized (object) {
            if (n >= this.realToVisibleLine.size()) {
                return n - this.hiddenLines;
            }
            return this.realToVisibleLine.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isVisible(int n) {
        Object object = this.readLock();
        synchronized (object) {
            if (n >= this.foldOffsets.size()) {
                return true;
            }
            int n2 = this.foldOffsets.get(n);
            if (n2 == 0) {
                return true;
            }
            for (int i = n - this.foldOffsets.get(n); i >= 0; i -= n2) {
                if (this.visibleList.get(i) == 0) {
                    return false;
                }
                n2 = this.foldOffsets.get(i);
                if (n2 == 0) break;
            }
            return true;
        }
    }

    int foldLength(int n) {
        int n2;
        for (n2 = n + 1; n2 < this.foldOffsets.size() && this.foldOffsets.get(n2) > 0 && this.foldOffsets.get(n2) <= n2 - n; ++n2) {
        }
        return n2 - n - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVisibleLineCount() {
        Object object = this.readLock();
        synchronized (object) {
            return this.getLineCount() - this.hiddenLines;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFoldStart(int n) {
        Object object = this.readLock();
        synchronized (object) {
            if (n + 1 < this.foldOffsets.size() && this.foldOffsets.get(n + 1) == 1) {
                return n;
            }
            if (n < 0 || n >= this.foldOffsets.size()) {
                return Math.max(0, n);
            }
            return n - this.foldOffsets.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getParentFoldStart(int n) {
        Object object = this.readLock();
        synchronized (object) {
            if (n < 0 || n >= this.foldOffsets.size()) {
                return -1;
            }
            int n2 = this.foldOffsets.get(n);
            if (n2 > 0) {
                int n3 = n - n2;
                int n4 = n3 >= 0 ? n3 : -1;
                return n4;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Integer, Integer> removeCharsFromLastLine(int n) {
        Object object = this.readLock();
        synchronized (object) {
            String string;
            if (this.lastLineFinished) {
                return Pair.of((Object)0, (Object)0);
            }
            try {
                string = this.getLine(this.getLineCount() - 1);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, null, iOException);
                return Pair.of((Object)0, (Object)0);
            }
            if (string.isEmpty()) {
                return Pair.of((Object)0, (Object)0);
            }
            int n2 = n < 0 ? string.length() : Math.max(n, string.length());
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (string.charAt(string.length() - 1 - i) != '\t') continue;
                n3 += this.removeLastTab();
            }
            this.lastLineLength -= n2;
            return Pair.of((Object)n2, (Object)n3);
        }
    }

    private class CharBufferResource
    implements BufferResource<CharBuffer> {
        private BufferResource<ByteBuffer> parentResource;
        private CharBuffer cb;

        public CharBufferResource(BufferResource<ByteBuffer> bufferResource) {
            this.parentResource = bufferResource;
            this.cb = bufferResource.getBuffer().asCharBuffer();
        }

        @Override
        public CharBuffer getBuffer() {
            return this.cb;
        }

        @Override
        public void releaseBuffer() {
            this.cb = null;
            this.parentResource.releaseBuffer();
        }
    }
}

