/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.Log;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class RelativeFileSet {
    private Type type = Type.UNKNOWN;
    private String mode;
    private String os;
    private String arch;
    private File basedir;
    Set<String> files = new LinkedHashSet<String>();

    public RelativeFileSet(RelativeFileSet relativeFileSet) {
        this.type = relativeFileSet.type;
        this.mode = relativeFileSet.mode;
        this.os = relativeFileSet.os;
        this.arch = relativeFileSet.arch;
        this.basedir = relativeFileSet.basedir;
        this.files = new LinkedHashSet<String>(relativeFileSet.files);
    }

    public RelativeFileSet(File file, Collection<File> collection) {
        this.basedir = file;
        String string = this.basedir.getAbsolutePath();
        for (File file2 : collection) {
            String string2 = file2.getAbsolutePath();
            if (!string2.startsWith(string)) {
                throw new RuntimeException("File " + file2.getAbsolutePath() + " does not belong to " + string);
            }
            if (string2.equals(string)) continue;
            this.files.add(string2.substring(string.length() + 1));
        }
    }

    public void upshift() {
        String string = this.basedir.getName();
        this.basedir = this.basedir.getParentFile();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string2 : this.files) {
            linkedHashSet.add(string + File.separator + string2);
        }
        this.files = linkedHashSet;
    }

    public RelativeFileSet(File file, Set<File> set) {
        this(file, (Collection<File>)set);
    }

    public boolean contains(String[] stringArray) {
        boolean bl = true;
        for (String string : stringArray) {
            if (this.files.contains(string)) continue;
            Log.debug("  Runtime does not contain [" + string + "]");
            bl = false;
        }
        return bl;
    }

    public boolean contains(String string) {
        if (this.files.contains(string)) {
            return true;
        }
        Log.debug("  Runtime does not contain [" + string + "]");
        return false;
    }

    public File getBaseDirectory() {
        return this.basedir;
    }

    public Set<String> getIncludedFiles() {
        return this.files;
    }

    public void dump() {
        Log.verbose("\n=========\nBasedir: " + this.basedir + "\n");
        for (String string : this.files) {
            Log.verbose("  " + string);
        }
        Log.verbose("\n========");
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String string) {
        this.os = string;
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String string) {
        this.arch = string;
    }

    public String toString() {
        return "RelativeFileSet{basedir:" + this.basedir + ", files:" + this.files + "}";
    }

    public static enum Type {
        UNKNOWN,
        jnlp,
        jar,
        nativelib,
        icon,
        license,
        data;

    }
}

