/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.classic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.core.startup.layers.SessionManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

final class FileStateManager {
    public static final int LAYER_SESSION = 1;
    public static final int LAYER_MODULES = 2;
    public static final int FSTATE_DEFINED = 0;
    public static final int FSTATE_IGNORED = 1;
    public static final int FSTATE_INHERITED = 2;
    public static final int FSTATE_UNDEFINED = 3;
    private static FileStateManager manager = null;
    private WeakHashMap<FileObject, FileInfo> info = new WeakHashMap();
    private static final int LAYERS_COUNT = 3;
    private FileSystem[] layers = new FileSystem[3];
    private HashMap<FileStatusListener, LinkedList<FileObject>> listeners = new HashMap(10);
    private PropertyChangeListener propL = null;

    public static synchronized FileStateManager getDefault() {
        if (manager == null) {
            manager = new FileStateManager();
        }
        return manager;
    }

    private FileStateManager() {
        this.getLayers();
        this.propL = new PropL();
        SessionManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)SessionManager.getDefault()));
    }

    public void define(final FileObject fileObject, int n, boolean bl) throws IOException {
        FileObject fileObject2;
        if (0 == this.getFileState(fileObject, n)) {
            return;
        }
        FileSystem fileSystem = this.getLayer(n);
        if (fileSystem == null) {
            throw new IllegalArgumentException("Invalid layer " + n);
        }
        FileObject fileObject3 = fileSystem.findResource(fileObject.getPath());
        if (fileObject3 != null && !bl) {
            this.deleteImpl(fileObject, fileSystem);
            fileObject3 = null;
        }
        if (fileObject3 == null) {
            String string = fileObject.getParent().getPath();
            fileObject2 = FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)string);
            fileObject2.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    fileObject.copy(fileObject2, fileObject.getName(), fileObject.getExt());
                }
            });
        }
        for (int i = 0; i < n; ++i) {
            fileObject2 = this.getLayer(i);
            if (fileObject2 == null) continue;
            this.deleteImpl(fileObject, (FileSystem)fileObject2);
        }
    }

    public void delete(FileObject fileObject, int n) throws IOException {
        FileSystem fileSystem = this.getLayer(n);
        if (fileSystem == null) {
            throw new IllegalArgumentException("Invalid layer " + n);
        }
        this.deleteImpl(fileObject, fileSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileState(FileObject fileObject, int n) {
        FileSystem fileSystem = null;
        FileInfo fileInfo = null;
        try {
            fileSystem = fileObject.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        if (fileSystem == null || !fileSystem.isDefault()) {
            throw new IllegalArgumentException("FileObject has to be from DefaultFileSystem - " + fileObject);
        }
        WeakHashMap<FileObject, FileInfo> weakHashMap = this.info;
        synchronized (weakHashMap) {
            fileInfo = this.info.get(fileObject);
            if (null == fileInfo) {
                fileInfo = new FileInfo(fileObject);
                this.info.put(fileObject, fileInfo);
            }
        }
        return fileInfo.getState(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFileStatusListener(FileStatusListener fileStatusListener, FileObject fileObject) {
        HashMap<FileStatusListener, LinkedList<FileObject>> hashMap = this.listeners;
        synchronized (hashMap) {
            LinkedList<Object> linkedList = null;
            if (!this.listeners.containsKey(fileStatusListener)) {
                linkedList = new LinkedList();
                this.listeners.put(fileStatusListener, linkedList);
            } else {
                linkedList = this.listeners.get(fileStatusListener);
            }
            if (!linkedList.contains(fileObject)) {
                linkedList.add(fileObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFileStatusListener(FileStatusListener fileStatusListener, FileObject fileObject) {
        HashMap<FileStatusListener, LinkedList<FileObject>> hashMap = this.listeners;
        synchronized (hashMap) {
            if (fileObject == null) {
                this.listeners.remove(fileStatusListener);
            } else {
                LinkedList<FileObject> linkedList = this.listeners.get(fileStatusListener);
                if (linkedList != null) {
                    linkedList.remove(fileObject);
                    if (linkedList.isEmpty()) {
                        this.listeners.remove(fileStatusListener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFileStatusChanged(FileObject fileObject) {
        HashMap hashMap = null;
        HashMap<FileStatusListener, LinkedList<FileObject>> hashMap2 = this.listeners;
        synchronized (hashMap2) {
            hashMap = (HashMap)this.listeners.clone();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            FileStatusListener fileStatusListener = (FileStatusListener)entry.getKey();
            LinkedList linkedList = (LinkedList)entry.getValue();
            if (!linkedList.contains(fileObject)) continue;
            fileStatusListener.fileStatusChanged(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteImpl(FileObject fileObject, FileSystem fileSystem) throws IOException {
        FileObject fileObject2 = fileSystem.findResource(fileObject.getPath());
        if (fileObject2 != null) {
            FileLock fileLock = null;
            try {
                fileLock = fileObject2.lock();
                fileObject2.delete(fileLock);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discard(FileObject fileObject) {
        WeakHashMap<FileObject, FileInfo> weakHashMap = this.info;
        synchronized (weakHashMap) {
            this.info.remove(fileObject);
        }
    }

    private void getLayers() {
        this.layers[1] = SessionManager.getDefault().getLayer("session");
        this.layers[2] = SessionManager.getDefault().getLayer("install");
    }

    private FileSystem getLayer(int n) {
        return this.layers[n];
    }

    private class FileInfo
    extends FileChangeAdapter {
        private WeakReference<FileObject> file = null;
        private int[] state = new int[3];
        private final Object LOCK = new Object();
        private FileObject[] notifiers = new FileObject[3];
        private FileChangeListener[] weakL = new FileChangeListener[3];

        public FileInfo(FileObject fileObject) {
            int n;
            this.file = new WeakReference<FileObject>(fileObject);
            for (n = 0; n < 3; ++n) {
                this.state[n] = this.getStateImpl(fileObject, n);
            }
            for (n = 0; n < 3; ++n) {
                this.attachNotifier(fileObject, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            this.detachAllNotifiers();
            Object object = this.LOCK;
            synchronized (object) {
                for (int i = 0; i < 3; ++i) {
                    this.state[i] = 3;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getState(int n) {
            Object object = this.LOCK;
            synchronized (object) {
                return this.state[n];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rescan(FileObject fileObject) {
            boolean bl = false;
            Object object = this.LOCK;
            synchronized (object) {
                for (int i = 0; i < 3; ++i) {
                    int n = this.getStateImpl(fileObject, i);
                    if (this.state[i] == n) continue;
                    this.state[i] = n;
                    bl = true;
                }
            }
            if (bl) {
                FileStateManager.this.fireFileStatusChanged(fileObject);
            }
        }

        private int getStateImpl(FileObject fileObject, int n) {
            int n2;
            boolean bl = false;
            boolean bl2 = false;
            for (n2 = 0; n2 < n; ++n2) {
                if (!this.isOnLayer(fileObject, n2)) continue;
                bl = true;
                break;
            }
            for (n2 = n + 1; n2 < 3; ++n2) {
                if (!this.isOnLayer(fileObject, n2)) continue;
                bl2 = true;
                break;
            }
            if (this.isOnLayer(fileObject, n)) {
                return bl ? 1 : 0;
            }
            return bl2 && !bl ? 2 : 3;
        }

        private boolean isOnLayer(FileObject fileObject, int n) {
            FileSystem fileSystem = FileStateManager.this.getLayer(n);
            return fileSystem == null ? false : null != fileSystem.findResource(fileObject.getPath());
        }

        private synchronized boolean attachNotifier(FileObject fileObject, int n) {
            FileSystem fileSystem = FileStateManager.this.getLayer(n);
            String string = fileObject.getPath();
            FileObject fileObject2 = null;
            boolean bl = true;
            if (fileSystem == null) {
                return false;
            }
            while (string.length() > 0 && null == (fileObject2 = fileSystem.findResource(string))) {
                int n2 = string.lastIndexOf(47);
                bl = false;
                if (-1 == n2) break;
                string = string.substring(0, n2);
            }
            if (fileObject2 == null) {
                fileObject2 = fileSystem.getRoot();
            }
            if (fileObject2 != this.notifiers[n]) {
                if (this.notifiers[n] != null) {
                    this.notifiers[n].removeFileChangeListener(this.weakL[n]);
                }
                this.weakL[n] = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject2);
                fileObject2.addFileChangeListener(this.weakL[n]);
                this.notifiers[n] = fileObject2;
            }
            return bl;
        }

        private synchronized void detachAllNotifiers() {
            for (int i = 0; i < 3; ++i) {
                if (this.notifiers[i] == null) continue;
                this.notifiers[i].removeFileChangeListener(this.weakL[i]);
                this.notifiers[i] = null;
                this.weakL[i] = null;
            }
        }

        private int layerOfFile(FileObject fileObject) {
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                for (int i = 0; i < 3; ++i) {
                    if (!fileSystem.equals(FileStateManager.this.getLayer(i))) continue;
                    return i;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                throw (IllegalStateException)new IllegalStateException("Invalid file - " + fileObject).initCause(fileStateInvalidException);
            }
            return -1;
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileObject fileObject = (FileObject)this.file.get();
            if (fileObject != null && fileObject.isValid()) {
                FileStateManager.this.discard(fileObject);
                FileStateManager.this.fireFileStatusChanged(fileObject);
            } else {
                this.detachAllNotifiers();
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = (FileObject)this.file.get();
            if (fileObject != null && fileObject.isValid()) {
                String string;
                String string2 = fileEvent.getFile().getPath();
                if (string2.equals(string = fileObject.getPath())) {
                    int n = this.layerOfFile(fileEvent.getFile());
                    if (-1 != n) {
                        this.attachNotifier(fileObject, n);
                    }
                    this.rescan(fileObject);
                }
            } else {
                this.detachAllNotifiers();
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            FileObject fileObject = (FileObject)this.file.get();
            if (fileObject != null && fileObject.isValid()) {
                int n;
                String string = fileEvent.getFile().getPath();
                String string2 = fileObject.getPath();
                if (string2.startsWith(string) && -1 != (n = this.layerOfFile(fileEvent.getFile())) && this.attachNotifier(fileObject, n)) {
                    this.rescan(fileObject);
                }
            } else {
                this.detachAllNotifiers();
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = (FileObject)this.file.get();
            if (fileObject != null && fileObject.isValid()) {
                String string;
                String string2 = fileEvent.getFile().getPath();
                if (string2.equals(string = fileObject.getPath())) {
                    int n = this.layerOfFile(fileEvent.getFile());
                    if (-1 != n) {
                        this.attachNotifier(fileObject, n);
                    }
                    this.rescan(fileObject);
                }
            } else {
                this.detachAllNotifiers();
            }
        }
    }

    public static interface FileStatusListener {
        public void fileStatusChanged(FileObject var1);
    }

    private class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("session_open".equals(propertyChangeEvent.getPropertyName())) {
                FileObject[] fileObjectArray = null;
                WeakHashMap weakHashMap = FileStateManager.this.info;
                synchronized (weakHashMap) {
                    fileObjectArray = FileStateManager.this.info.keySet().toArray(new FileObject[FileStateManager.this.info.size()]);
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        FileInfo fileInfo = (FileInfo)((Object)FileStateManager.this.info.get(fileObjectArray[i]));
                        if (fileInfo == null) continue;
                        fileInfo.invalidate();
                    }
                    FileStateManager.this.info.clear();
                    FileStateManager.this.getLayers();
                }
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    FileStateManager.this.fireFileStatusChanged(fileObjectArray[i]);
                }
            }
        }
    }
}

