/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.column;

import com.jrockit.mc.common.environment.OS;
import com.jrockit.mc.rjmx.ui.column.ColumnComposite;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeColumnComposite
extends ColumnComposite {
    private final TreeViewer viewer;

    public TreeColumnComposite(Composite parent, IDialogSettings settings) {
        super(parent, settings, (AbstractColumnLayout)new TreeColumnLayout());
        int style = 68354;
        if (!OS.couldBeUsingGTK()) {
            style |= 0x10000000;
        }
        this.viewer = new TreeViewer((Composite)this, style);
        this.viewer.getTree().setLinesVisible(true);
        this.initColumnViewer();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    protected TreeColumn createColumnWidget(final String columnId, int columnIndex, int columnStyle) {
        final TreeColumn c = new TreeColumn(this.viewer.getTree(), columnStyle, columnIndex);
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TreeColumnComposite.this.columnRemoved(columnId, c.getWidth());
            }
        });
        return c;
    }

    @Override
    protected void setSortColumn(Item column, int direction) {
        Tree tree = this.viewer.getTree();
        tree.setSortColumn((TreeColumn)column);
        tree.setSortDirection(direction);
    }

    @Override
    protected void setColumnDescription(Item column, String description) {
        ((TreeColumn)column).setToolTipText(description);
    }

    @Override
    protected void setHeaderVisible(boolean visible) {
        this.viewer.getTree().setHeaderVisible(visible);
    }
}

