/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.tab.TabDescriptorRepository;
import com.jrockit.mc.components.ui.tab.TabGroupDescriptor;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import java.util.ArrayList;
import java.util.List;

public class UI {
    private final Setting m_setting = new Setting("userInterface");

    static {
        PersistenceToolkit.registerFetcher(UI.class, (ISettingFetcher)new ISettingFetcher<UI>(){

            public Setting getSetting(UI ui) {
                return ui.m_setting;
            }
        });
    }

    public TabDescriptorRepository getTabRepository() {
        return (TabDescriptorRepository)this.m_setting.getChildObject("tabRepository", TabDescriptorRepository.class);
    }

    public List<ComponentDescriptor> getAllComponentDescriptors() {
        ArrayList<ComponentDescriptor> used = new ArrayList<ComponentDescriptor>();
        for (TabGroupDescriptor tgd : this.getTabRepository().getGroups()) {
            used.addAll(this.getUsed(tgd));
        }
        return used;
    }

    private List<ComponentDescriptor> getUsed(TabGroupDescriptor parent) {
        ArrayList<ComponentDescriptor> used = new ArrayList<ComponentDescriptor>();
        for (TabGroupDescriptor tgd : parent.getGroups()) {
            used.addAll(this.getUsed(tgd));
        }
        for (TabItemDescriptor tabItem : parent.getTabs()) {
            used.addAll(this.getUsed(this.listIfy(tabItem)));
        }
        return used;
    }

    private List<LayoutItem> listIfy(TabItemDescriptor tabItem) {
        ArrayList<LayoutItem> items = new ArrayList<LayoutItem>();
        items.add(tabItem.getLayoutItem());
        return items;
    }

    private List<ComponentDescriptor> getUsed(List<LayoutItem> item) {
        ArrayList<ComponentDescriptor> used = new ArrayList<ComponentDescriptor>();
        for (LayoutItem layoutItem : item) {
            ComponentDescriptor cd = layoutItem.getComponentDescriptor();
            if (cd != null) {
                used.add(cd);
            }
            used.addAll(this.getUsed(layoutItem.getChildren()));
        }
        return used;
    }
}

