/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.actions;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.design.actions.FileAction;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.ui.UIPlugin;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;

public abstract class ImportAction<T>
extends FileAction {
    private final T m_importIntoObject;
    private static final String m_fileName = "*.xml";

    public ImportAction(Shell shell, String title, T importInto) {
        super(shell, 4096, title);
        this.m_importIntoObject = importInto;
        this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("import.gif"));
    }

    protected abstract void commitObject(T var1);

    public static <U> IAction createListAction(Shell shell, final List<U> importList, String title, U object) {
        return new ImportAction<U>(shell, title, object){

            @Override
            protected void commitObject(U baseDescriptor) {
                importList.add(baseDescriptor);
            }
        };
    }

    @Override
    protected final String createSuggestedFileName() {
        return m_fileName;
    }

    @Override
    protected void fileOperation(Shell shell, String fileName) {
        File importFile = new File(fileName);
        if (!importFile.exists()) {
            this.showError(Messages.DESIGN_MENU_IMPORT_ERROR_TITLE, MessageFormat.format(Messages.DESIGN_MENU_IMPORT_CANNOT_FIND_FILE_ERROR_TEXT, importFile));
        } else {
            this.importObject(importFile);
        }
    }

    protected void importObject(File file) {
        try {
            PersistenceToolkit.importIntoObjectFromFile(this.m_importIntoObject, (File)file);
            this.commitObject(this.m_importIntoObject);
            this.firePropertyChange("refresh", null, this.m_importIntoObject);
        }
        catch (IOException e) {
            this.showError(Messages.DESIGN_MENU_IMPORT_ERROR_TITLE, String.valueOf(Messages.DESIGN_MENU_IMPOPT_ERROR_OPENNING_FILE_TEXT) + "\n " + e.getMessage());
        }
    }
}

