/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.designelement;

import com.jrockit.mc.common.persistence.History;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.design.LayoutData;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.LayoutItemType;
import com.jrockit.mc.components.ui.design.LayoutNotifaction;
import com.jrockit.mc.components.ui.design.LayoutToolkit;
import com.jrockit.mc.components.ui.design.Operation;
import com.jrockit.mc.components.ui.design.OperationType;
import com.jrockit.mc.components.ui.design.designelement.ComponentElement;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.design.designelement.MouseElementListener;
import com.jrockit.mc.components.ui.design.designelement.RootElement;
import com.jrockit.mc.components.ui.design.designelement.SelectionContext;
import com.jrockit.mc.components.ui.design.designelement.TabElement;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.ui.layout.SimpleLayoutData;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public final class GUIDesigner {
    private final History<Operation> m_history;
    private final LayoutItem m_layoutItem;
    private IDesignElement m_root;
    private RootElement m_rootParent;
    private IServiceLocator m_locator;
    private SelectionContext m_selectionContext;

    public GUIDesigner(LayoutItem li) {
        this.m_layoutItem = (LayoutItem)PersistenceToolkit.createWorkingCopy((Object)li);
        this.m_history = new History((Object)this.m_layoutItem);
        this.m_history.saveState((Object)new Operation(OperationType.INITIAL, Messages.GUI_DESIGNER_OPEN_OPERATION_DESCRIPTION));
        this.hookStateChange();
    }

    public void loadLayout(LayoutItem li) {
        if (!PersistenceToolkit.isEqual((Object)this.m_layoutItem, (Object)li)) {
            PersistenceToolkit.inject((Object)this.m_layoutItem, (Object)li);
            this.m_history.saveState((Object)new Operation(OperationType.INITIAL, Messages.GUI_DESIGNER_OPEN_OPERATION_DESCRIPTION));
        }
    }

    public void commit() {
        PersistenceToolkit.commit((Object)this.m_layoutItem);
    }

    public History<Operation> getHistory() {
        return this.m_history;
    }

    public void rebuild(Composite container, IServiceLocator serviceLocator, ISelectionProvider provider) {
        this.m_selectionContext = new SelectionContext(container, provider);
        serviceLocator.registerService(this.m_selectionContext);
        this.m_locator = serviceLocator;
        this.m_rootParent = new RootElement(container, this.m_layoutItem);
        this.updateUI(false);
    }

    private void hookStateChange() {
        this.m_history.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                GUIDesigner.this.updateUI(true);
            }
        });
    }

    private void updateUI(boolean dispose) {
        this.m_rootParent.getControl().setRedraw(false);
        if (dispose) {
            this.m_root.getControl().dispose();
        }
        this.m_selectionContext.clear();
        this.m_root = this.createElement(this.m_rootParent, this.m_rootParent.getLayoutItem());
        this.m_rootParent.refresh();
        this.m_root.getControl().forceFocus();
        this.m_root.setSelected();
        this.setSelectedLayoutItem(this.m_root);
        this.m_rootParent.getControl().setRedraw(true);
    }

    private void setSelectedLayoutItem(IDesignElement parent) {
        if (parent.getLayoutItem().isSelected()) {
            parent.getControl().forceFocus();
            parent.setSelected();
            parent.getLayoutItem().cleartSelection();
            return;
        }
        for (IDesignElement element : parent.getChildren()) {
            this.setSelectedLayoutItem(element);
        }
    }

    private IDesignElement createElement(IDesignElement parent, LayoutItem item) {
        IDesignElement designElement = this.createFromType(item.getType());
        designElement.create(parent, item, this.m_locator);
        new MouseElementListener(designElement);
        for (LayoutItem lItem : item.getChildren()) {
            designElement.addElement(this.createElement(designElement, lItem));
        }
        designElement.getControl().setLayoutData(LayoutToolkit.createSimpleLayoutData(item, false));
        this.hookLayoutItemObserver(parent, designElement);
        return designElement;
    }

    private IDesignElement createFromType(LayoutItemType type) {
        if (type == LayoutItemType.FOLDERS) {
            return new TabElement();
        }
        return new ComponentElement();
    }

    private void hookLayoutItemObserver(IDesignElement parent, final IDesignElement element) {
        final Observer observer = this.createObserver(element);
        element.getLayoutItem().addObserver(observer);
        parent.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                element.getLayoutItem().deleteObserver(observer);
            }
        });
    }

    private Observer createObserver(final IDesignElement element) {
        Observer observer = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                Composite control = element.getControl();
                if (!element.getControl().isDisposed()) {
                    LayoutNotifaction ln;
                    Operation op;
                    SimpleLayoutData sl = (SimpleLayoutData)control.getLayoutData();
                    LayoutData ld = element.getLayoutItem().getLayoutData();
                    if (sl != null) {
                        LayoutToolkit.updateSimpleLayoutData(sl, ld, false);
                    }
                    if ((op = (ln = (LayoutNotifaction)arg).getOperation()).getType().isStructural()) {
                        LayoutItem it = ln.getSelection();
                        if (it != null) {
                            it.setSelected();
                        }
                        GUIDesigner.this.m_history.saveState((Object)op);
                        GUIDesigner.this.m_history.notifyObservers();
                    } else {
                        GUIDesigner.this.m_root.refresh();
                    }
                }
            }
        };
        return observer;
    }

    public IDesignElement getRootElement() {
        return this.m_root;
    }

    public IDesignElement getSelectedObject() {
        if (this.m_selectionContext != null) {
            return (IDesignElement)this.m_selectionContext.getSelectedObject();
        }
        return null;
    }
}

