/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.Input;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ComboInput
extends Input {
    private static final int VISIBLE_ITEM_COUNT = 10;
    private Map<String, String> m_items = new LinkedHashMap<String, String>();
    private CCombo m_combo;

    public ComboInput(String key, String name) {
        super(key, name);
    }

    public ComboInput(String key, String name, Map<String, String> items) {
        super(key, name);
        this.m_items = items;
    }

    public final ComboInput setItems(Map<String, String> items) {
        this.m_items = items;
        this.refreshItems();
        return this;
    }

    public final Map<String, String> getItems() {
        return this.m_items;
    }

    @Override
    public void create(Composite parent, int horizontalSpan) {
        GridData gd1 = new GridData(4, 4, false, false);
        gd1.verticalAlignment = 0x1000000;
        gd1.horizontalSpan = 1;
        Label label = new Label(parent, 0);
        label.setText(this.getName());
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        gd2.horizontalSpan = --horizontalSpan;
        this.m_combo = this.createCombo(parent);
        this.m_combo.setVisibleItemCount(10);
        this.m_combo.setLayoutData((Object)gd2);
        this.m_combo.setEnabled(false);
        this.refreshItems();
    }

    public Control getControl() {
        return this.m_combo;
    }

    public final boolean select(String key) {
        int index = 0;
        for (Map.Entry<String, String> entry : this.m_items.entrySet()) {
            if (key.equals(entry.getKey())) {
                this.m_combo.select(index);
                this.markStale();
                return true;
            }
            ++index;
        }
        return false;
    }

    private CCombo createCombo(Composite parent) {
        CCombo combo = new CCombo(parent, 2048);
        combo.setEditable(false);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComboInput.this.setPropertyValue(ComboInput.this.getKeyFromIndex(ComboInput.this.m_combo.getSelectionIndex()));
                ComboInput.this.fireChange(IInput.STATUS_SETTING_CHANGE);
            }
        });
        return combo;
    }

    private void refreshItems() {
        if (this.m_combo != null && !this.m_combo.isDisposed()) {
            this.m_combo.removeAll();
            for (Map.Entry<String, String> entry : this.m_items.entrySet()) {
                this.m_combo.add(entry.getValue());
            }
            this.m_combo.select(0);
        }
    }

    private int getIndexFromKey(String key) {
        int index = 0;
        for (Map.Entry<String, String> entry : this.m_items.entrySet()) {
            if (key.equals(entry.getKey())) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    private String getKeyFromIndex(int selectionIndex) {
        int index = 0;
        for (Map.Entry<String, String> entry : this.m_items.entrySet()) {
            if (selectionIndex == index) {
                return entry.getKey();
            }
            ++index;
        }
        throw new IllegalStateException("Could not find item " + selectionIndex + " in combobox");
    }

    @Override
    public void refresh() {
        this.m_combo.setEnabled(this.isEnabled());
        if (this.isEnabled()) {
            this.refreshItems();
            int index = this.getIndexFromKey(this.getPropertyValue());
            this.m_combo.select(index);
        } else {
            this.m_combo.setText("");
        }
    }

    public final String getSelectedKey() {
        return this.getPropertyValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_combo.setEnabled(enabled);
    }
}

