/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.persistence.History;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.tab.ImageConverter;
import com.jrockit.mc.components.ui.util.ImageDescriptor;
import com.jrockit.mc.ui.misc.MCColor;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class IconEditor
extends WizardPage
implements IPerformFinishable {
    private static final MCColor LIGHT_GREY = new MCColor(250, 250, 250);
    private static final MCColor DARK_GREY = new MCColor(192, 192, 192);
    private final ImageDescriptor m_imageDescriptor;
    private final MCColor m_currentDrawingColor = new MCColor();
    private final History<ImageDescriptor> m_history;
    private boolean m_buttonDown;
    private Tool m_activeTool = Tool.DRAW;
    private Canvas m_drawingArea;
    private Text m_colorLabel;
    private Color m_color;
    private Image m_image;
    private Image m_backgroundImage;
    private Scale m_alpha;

    public IconEditor(ImageDescriptor sourceImageDescriptor) {
        super("iconEditor");
        this.setTitle(Messages.ICON_EDITOR_TITLE);
        this.m_imageDescriptor = sourceImageDescriptor;
        this.m_history = new History((Object)this.m_imageDescriptor);
    }

    public void createControl(Composite parent) {
        this.m_image = ImageConverter.createImage((Device)parent.getDisplay(), this.m_imageDescriptor);
        this.setDescription(Messages.ICON_EDITOR_DESCRIPTION_TEXT);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        GridData gd0 = new GridData(4, 4, true, false);
        ToolBar toolbar = new ToolBar(container, 0x800000);
        toolbar.setLayoutData((Object)gd0);
        this.createDrawButton(toolbar);
        this.createFillButton(toolbar);
        this.createPickerButton(toolbar);
        this.createSeparator(toolbar);
        this.createUndoButton(toolbar);
        this.createRedoButton(toolbar);
        GridData gd2 = new GridData(4, 4, false, false);
        this.m_colorLabel = this.createColorLabel(container);
        this.m_colorLabel.setLayoutData((Object)gd2);
        GridData gd7 = new GridData(4, 4, false, false);
        Button colorButton = this.createColorPickerButton(container);
        colorButton.setLayoutData((Object)gd7);
        GridData gd3 = new GridData(4, 4, false, false);
        Button browseButton = this.createBrowseButton(container);
        browseButton.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, true, true);
        gd4.horizontalSpan = 4;
        this.m_drawingArea = this.createDrawingArea(container);
        this.m_drawingArea.setLayoutData((Object)gd4);
        GridData gd1 = new GridData(4, 4, true, false);
        gd1.horizontalSpan = 4;
        this.m_alpha = this.createTransparentCheckBox(container);
        this.m_alpha.setLayoutData((Object)gd1);
        this.updatColorLabel();
        this.updateImage((Device)container.getDisplay());
        this.updateBackgroundImage(container.getDisplay());
        this.setControl((Control)container);
        this.m_history.saveState();
        this.m_history.notifyObservers();
    }

    private void createSeparator(ToolBar toolbar) {
        new ToolItem(toolbar, 2);
    }

    private ToolItem createRedoButton(final ToolBar parent) {
        final ToolItem button = new ToolItem(parent, 0);
        button.setToolTipText(Messages.ICON_EDITOR_REDO_BUTTON_TOOLTIP);
        button.setImage(ComponentsPlugin.getDefault().getImage("redo.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IconEditor.this.m_history.redo();
                IconEditor.this.m_history.notifyObservers();
                IconEditor.this.updateImage((Device)parent.getDisplay());
            }
        });
        this.m_history.addObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                button.setEnabled(IconEditor.this.m_history.isRedoAvailable());
            }
        });
        return button;
    }

    private ToolItem createUndoButton(final ToolBar parent) {
        final ToolItem button = new ToolItem(parent, 0);
        button.setToolTipText(Messages.ICON_EDITOR_UNDO_BUTTON_TOOLTIP);
        button.setImage(ComponentsPlugin.getDefault().getImage("undo.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IconEditor.this.m_history.undo();
                IconEditor.this.m_history.notifyObservers();
                IconEditor.this.updateImage((Device)parent.getDisplay());
            }
        });
        this.m_history.addObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                button.setEnabled(IconEditor.this.m_history.isUndoAvailable());
            }
        });
        return button;
    }

    private ToolItem createPickerButton(ToolBar parent) {
        return this.createToolButton(parent, Messages.ICON_EDITOR_PICK_COLOR_BUTTON_TOOLTIP, ComponentsPlugin.getDefault().getImage("colorpicker.gif"), Tool.COLOR_PICKER);
    }

    private ToolItem createFillButton(ToolBar parent) {
        return this.createToolButton(parent, Messages.ICON_EDITOR_FILL_COLOR_BUTTON_TOOLTIP, ComponentsPlugin.getDefault().getImage("fill.gif"), Tool.FILL);
    }

    private ToolItem createDrawButton(ToolBar parent) {
        return this.createToolButton(parent, Messages.ICON_EDITOR_DRAW_BUTTON_TOOLTIP, ComponentsPlugin.getDefault().getImage("draw.gif"), Tool.DRAW);
    }

    private ToolItem createToolButton(ToolBar parent, String text, Image image, final Tool tool) {
        final ToolItem button = new ToolItem(parent, 16);
        button.setToolTipText(text);
        button.setSelection(this.m_activeTool == tool);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    IconEditor.this.m_activeTool = tool;
                }
            }
        });
        return button;
    }

    private void updateImage(Device device) {
        if (this.m_image != null) {
            this.m_image.dispose();
        }
        this.m_image = ImageConverter.createImage(device, this.m_imageDescriptor);
        this.m_drawingArea.redraw();
    }

    void updateBackgroundImage(Display display) {
        if (this.m_backgroundImage != null) {
            this.m_backgroundImage.dispose();
        }
        int width = 2 * this.m_imageDescriptor.getWidth();
        int height = 2 * this.m_imageDescriptor.getHeight();
        Image i = new Image((Device)display, width, height);
        ImageData id = i.getImageData();
        int lightPixelColor = id.palette.getPixel(LIGHT_GREY.getRGBColor());
        int darkPixelColor = id.palette.getPixel(DARK_GREY.getRGBColor());
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                id.setPixel(x, y, (x + y) % 2 == 0 ? lightPixelColor : darkPixelColor);
                ++x;
            }
            ++y;
        }
        this.m_backgroundImage = new Image((Device)display, id);
    }

    private Canvas createDrawingArea(Composite container) {
        Canvas canvas = new Canvas(container, 0x20000800);
        this.hookPaintListener(canvas);
        this.hookMouseListeners(canvas);
        return canvas;
    }

    private void hookPaintListener(Canvas canvas) {
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                IconEditor.this.paintImage(e.display, e.gc);
            }
        });
    }

    private void hookMouseListeners(final Canvas canvas) {
        canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1 && (e.stateMask & SWT.MOD4) == 0) {
                    IconEditor.this.m_buttonDown = true;
                    IconEditor.this.beginTool(canvas.getDisplay(), e.x, e.y);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && IconEditor.this.m_buttonDown) {
                    IconEditor.this.m_buttonDown = false;
                    IconEditor.this.endTool(canvas.getDisplay(), e.x, e.y);
                }
            }
        });
        canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (IconEditor.this.m_buttonDown && IconEditor.this.m_activeTool == Tool.DRAW) {
                    IconEditor.this.putPixel(canvas.getDisplay(), e.x, e.y);
                }
            }
        });
    }

    private void endTool(Display display, int x, int y) {
        if (this.m_activeTool == Tool.DRAW) {
            this.m_history.saveState();
            this.m_history.notifyObservers();
        }
        if (this.m_activeTool == Tool.FILL) {
            this.fillPixel(display, x, y);
            this.m_history.saveState();
            this.m_history.notifyObservers();
        }
    }

    private void fillPixel(Display display, int x, int y) {
        Point p = new Point(this.convertXDeviceToWorld(x), this.convertYDeviceToWorld(y));
        if (p.x >= 0 && p.y >= 0 && p.x < this.m_imageDescriptor.getWidth() && p.y < this.m_imageDescriptor.getHeight()) {
            ImageData id = this.m_image.getImageData();
            int startPixel = id.getPixel(p.x, p.y);
            int startAlpha = id.getAlpha(p.x, p.y);
            int pixel = id.palette.getPixel(this.m_currentDrawingColor.getRGBColor());
            int alpha = this.m_currentDrawingColor.getAlpha();
            if (startPixel != pixel || alpha != startAlpha) {
                LinkedList<Point> q = new LinkedList<Point>();
                q.add(p);
                int width = this.m_imageDescriptor.getWidth() - 1;
                int height = this.m_imageDescriptor.getHeight() - 1;
                while (!q.isEmpty()) {
                    Point point = (Point)q.poll();
                    int currentPixel = id.getPixel(point.x, point.y);
                    int currentAlpa = id.getAlpha(point.x, point.y);
                    if (point == null || currentPixel != startPixel || currentAlpa != startAlpha) continue;
                    id.setPixel(point.x, point.y, pixel);
                    id.setAlpha(point.x, point.y, alpha);
                    if (point.x > 0) {
                        q.add(new Point(point.x - 1, point.y));
                    }
                    if (point.x < width) {
                        q.add(new Point(point.x + 1, point.y));
                    }
                    if (point.y > 0) {
                        q.add(new Point(point.x, point.y - 1));
                    }
                    if (point.y >= height) continue;
                    q.add(new Point(point.x, point.y + 1));
                }
                this.updateImageDescriptor(id);
                this.updateImage((Device)display);
            }
        }
    }

    private void updateImageDescriptor(ImageData imageData) {
        ImageConverter.fillImageDescriptor(this.m_imageDescriptor, imageData);
    }

    private void beginTool(Display display, int x, int y) {
        if (this.m_activeTool == Tool.DRAW) {
            this.putPixel(display, x, y);
        }
        if (this.m_activeTool == Tool.COLOR_PICKER) {
            this.pickColor(x, y);
        }
    }

    private void pickColor(int x, int y) {
        MCColor color = this.getPixel(this.convertXDeviceToWorld(x), this.convertYDeviceToWorld(y));
        if (color != null) {
            this.m_currentDrawingColor.setRGB(color.getRGBColor());
            this.m_alpha.setSelection(color.getAlpha());
            this.updatColorLabel();
        }
    }

    private MCColor getPixel(int x, int y) {
        if (x >= 0 && y >= 0 && x < this.m_imageDescriptor.getWidth() && y < this.m_imageDescriptor.getHeight()) {
            PaletteData palette = this.m_image.getImageData().palette;
            ImageData imageData = this.m_image.getImageData();
            MCColor m = new MCColor(palette.getRGB(imageData.getPixel(x, y)));
            m.setAlpha(imageData.getAlpha(x, y));
            return m;
        }
        return null;
    }

    void putPixel(Display display, int x, int y) {
        this.setPixel(this.convertXDeviceToWorld(x), this.convertYDeviceToWorld(y), this.m_currentDrawingColor);
        this.updateImage((Device)display);
    }

    private void setPixel(int x, int y, MCColor color) {
        if (x >= 0 && y >= 0 && x < this.m_imageDescriptor.getWidth() && y < this.m_imageDescriptor.getHeight()) {
            PaletteData palette = this.m_image.getImageData().palette;
            ImageData imageData = this.m_image.getImageData();
            imageData.setPixel(x, y, palette.getPixel(color.getRGBColor()));
            imageData.setAlpha(x, y, color.getAlpha());
            this.updateImageDescriptor(imageData);
        }
    }

    private Button createBrowseButton(final Composite parent) {
        Button browseButton = new Button(parent, 0);
        browseButton.setText(Messages.ICON_EDITOR_BROWSE_BUTTON_TEXT);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IconEditor.this.showFileDialog(parent.getShell());
            }
        });
        return browseButton;
    }

    private void showFileDialog(Shell shell) {
        FileDialog fd = new FileDialog(shell, 4096);
        String fileName = fd.open();
        if (fileName != null) {
            this.setIcon(shell.getDisplay(), fileName);
        }
    }

    private void setIcon(Display display, String fileName) {
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(fileName);
                Image newImage = new Image((Device)display, (InputStream)fis);
                this.m_image.dispose();
                this.m_image = newImage;
                this.updateImageDescriptor(this.m_image.getImageData());
                this.updateBackgroundImage(display);
                this.updateImage((Device)display);
                this.m_history.saveState();
                this.m_history.notifyObservers();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(Messages.ICON_INPUT_COULD_NOT_LOAD_IMAGE_ERROR_TEXT, e);
            }
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(fis);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)fis);
    }

    private Button createColorPickerButton(Composite container) {
        final Button b = new Button(container, 0);
        b.setText(Messages.ICON_EDITOR_EDIT_COLOR_BUTTON_TEXT);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(b.getShell());
                RGB color = cd.open();
                if (color != null) {
                    IconEditor.this.m_currentDrawingColor.setRGB(color);
                    IconEditor.this.updatColorLabel();
                }
            }
        });
        return b;
    }

    private Text createColorLabel(Composite container) {
        Text l = new Text(container, 2056);
        return l;
    }

    private void updatColorLabel() {
        if (this.m_color != null) {
            this.m_color.dispose();
        }
        this.m_color = this.m_currentDrawingColor.createSWTColor((Device)this.m_colorLabel.getDisplay());
        this.m_colorLabel.setBackground(this.m_color);
    }

    private int convertXDeviceToWorld(int x) {
        double normalizedX = (double)x / (double)this.m_drawingArea.getClientArea().width;
        return (int)((double)this.m_imageDescriptor.getWidth() * normalizedX);
    }

    private int convertYDeviceToWorld(int y) {
        double normalizedY = (double)y / (double)this.m_drawingArea.getClientArea().height;
        return (int)((double)this.m_imageDescriptor.getHeight() * normalizedY);
    }

    private Scale createTransparentCheckBox(Composite container) {
        final Scale scale = new Scale(container, 256);
        scale.setMinimum(0);
        scale.setMaximum(255);
        scale.setSelection(255);
        scale.setToolTipText(Messages.ICON_EDITOR_TRANSPARENCY_SCALE_TOOLTIP);
        scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IconEditor.this.m_currentDrawingColor.setAlpha(scale.getSelection());
            }
        });
        return scale;
    }

    private void paintImage(Display display, GC gc) {
        int drawingWidth = this.m_drawingArea.getClientArea().width;
        int drawingHeight = this.m_drawingArea.getClientArea().height;
        this.drawBackgroundImage(gc, drawingWidth, drawingHeight);
        this.drawImage(gc, drawingWidth, drawingHeight);
    }

    private void drawImage(GC gc, int drawingWidth, int drawingHeight) {
        gc.drawImage(this.m_image, 0, 0, this.m_imageDescriptor.getWidth(), this.m_imageDescriptor.getHeight(), 0, 0, drawingWidth, drawingHeight);
    }

    private void drawBackgroundImage(GC gc, int drawingWidth, int drawingHeight) {
        gc.drawImage(this.m_backgroundImage, 0, 0, 2 * this.m_imageDescriptor.getWidth(), 2 * this.m_imageDescriptor.getHeight(), 0, 0, drawingWidth, drawingHeight);
    }

    public void dispose() {
        if (this.m_color != null) {
            this.m_color.dispose();
        }
        if (this.m_image != null) {
            this.m_image.dispose();
        }
        if (this.m_backgroundImage != null) {
            this.m_backgroundImage.dispose();
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return this.m_imageDescriptor;
    }

    public boolean performFinish() {
        this.dispose();
        return true;
    }

    static enum Tool {
        COLOR_PICKER,
        FILL,
        DRAW;

    }
}

