/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.SSLContext;
import org.jruby.ext.openssl.SSLSession;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class SSLSocket
extends RubyObject {
    private static final long serialVersionUID = -2084816623554406237L;
    private static ObjectAllocator SSLSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new SSLSocket(runtime, klass);
        }
    };
    private SSLContext sslContext;
    private SSLEngine engine;
    private RubyIO io;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private ByteBuffer netData;
    private ByteBuffer dummy;
    private boolean initialHandshake = false;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private SSLEngineResult.Status status;
    int verifyResult = 0;
    private transient SSLSession session;
    private transient SocketChannelImpl socketChannel;

    public static void createSSLSocket(Ruby runtime, RubyModule SSL2) {
        ThreadContext context2 = runtime.getCurrentContext();
        RubyClass SSLSocket2 = SSL2.defineClassUnder("SSLSocket", runtime.getObject(), SSLSOCKET_ALLOCATOR);
        SSLSocket2.addReadWriteAttribute(context2, "sync_close");
        SSLSocket2.addReadWriteAttribute(context2, "hostname");
        SSLSocket2.defineAnnotatedMethods(SSLSocket.class);
    }

    public SSLSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private static RaiseException newSSLError(Ruby runtime, Exception exception) {
        return SSL.newSSLError(runtime, exception);
    }

    private static RaiseException newSSLError(Ruby runtime, String message) {
        return SSL.newSSLError(runtime, message);
    }

    private static RaiseException newSSLErrorFromHandshake(Ruby runtime, SSLHandshakeException exception) {
        Exception cause = exception;
        while (cause.getCause() != null && cause instanceof SSLHandshakeException) {
            cause = (Exception)cause.getCause();
        }
        return SSL.newSSLError(runtime, cause);
    }

    @Deprecated
    public IRubyObject _initialize(ThreadContext context2, IRubyObject[] args, Block unused) {
        return this.initialize(context2, args);
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.runtime;
        this.sslContext = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)2) == 1 ? new SSLContext(runtime).initializeImpl() : (SSLContext)args[1];
        if (!(args[0] instanceof RubyIO)) {
            throw runtime.newTypeError("IO expected but got " + args[0].getMetaClass().getName());
        }
        this.io = (RubyIO)args[0];
        this.setInstanceVariable("@io", (IRubyObject)this.io);
        this.setInstanceVariable("@context", (IRubyObject)this.sslContext);
        this.set_sync(context2, (IRubyObject)runtime.getTrue());
        this.callMethod(context2, "sync_close=", (IRubyObject)runtime.getFalse());
        this.sslContext.setup(context2);
        return Utils.invokeSuper(context2, (IRubyObject)this, args, Block.NULL_BLOCK);
    }

    private SSLEngine ossl_ssl_setup(ThreadContext context2) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        SSLEngine engine = this.engine;
        if (engine != null) {
            return engine;
        }
        String peerHost = this.callMethod(context2, "hostname").toString();
        int peerPort = this.socketChannelImpl().getRemotePort();
        engine = this.sslContext.createSSLEngine(peerHost, peerPort);
        javax.net.ssl.SSLSession session2 = engine.getSession();
        this.peerNetData = ByteBuffer.allocate(session2.getPacketBufferSize());
        this.peerAppData = ByteBuffer.allocate(session2.getApplicationBufferSize());
        this.netData = ByteBuffer.allocate(session2.getPacketBufferSize());
        this.peerNetData.limit(0);
        this.peerAppData.limit(0);
        this.netData.limit(0);
        this.dummy = ByteBuffer.allocate(0);
        this.engine = engine;
        return this.engine;
    }

    @JRubyMethod(name={"io"}, alias={"to_io"})
    public final RubyIO io() {
        return this.io;
    }

    @JRubyMethod(name={"context"})
    public final SSLContext context() {
        return this.sslContext;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync(ThreadContext context2) {
        return this.io.callMethod(context2, "sync");
    }

    @JRubyMethod(name={"sync="})
    public IRubyObject set_sync(ThreadContext context2, IRubyObject sync2) {
        return this.io.callMethod(context2, "sync=", sync2);
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context2) {
        return this.connectImpl(context2, true);
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context2) {
        return this.connectImpl(context2, false);
    }

    private SSLSocket connectImpl(ThreadContext context2, boolean blocking) {
        Ruby runtime = context2.runtime;
        if (!this.sslContext.isProtocolForClient()) {
            throw SSLSocket.newSSLError(runtime, "called a function you should not call");
        }
        try {
            if (!this.initialHandshake) {
                SSLEngine engine = this.ossl_ssl_setup(context2);
                engine.setUseClientMode(true);
                engine.beginHandshake();
                this.handshakeStatus = engine.getHandshakeStatus();
                this.initialHandshake = true;
            }
            this.doHandshake(blocking);
        }
        catch (SSLHandshakeException e) {
            this.forceClose();
            throw SSLSocket.newSSLErrorFromHandshake(runtime, e);
        }
        catch (NoSuchAlgorithmException e) {
            OpenSSL.debugStackTrace(runtime, e);
            this.forceClose();
            throw SSLSocket.newSSLError(runtime, e);
        }
        catch (KeyManagementException e) {
            OpenSSL.debugStackTrace(runtime, e);
            this.forceClose();
            throw SSLSocket.newSSLError(runtime, e);
        }
        catch (IOException e) {
            this.forceClose();
            throw SSLSocket.newSSLError(runtime, e);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject accept(ThreadContext context2) {
        return this.acceptImpl(context2, true);
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context2) {
        return this.acceptImpl(context2, false);
    }

    @Deprecated
    public SSLSocket acceptCommon(ThreadContext context2, boolean blocking) {
        return this.acceptImpl(context2, blocking);
    }

    private SSLSocket acceptImpl(ThreadContext context2, boolean blocking) {
        Ruby runtime = context2.runtime;
        if (!this.sslContext.isProtocolForServer()) {
            throw SSLSocket.newSSLError(runtime, "called a function you should not call");
        }
        try {
            if (!this.initialHandshake) {
                SSLEngine engine = this.ossl_ssl_setup(context2);
                engine.setUseClientMode(false);
                IRubyObject verify_mode = this.sslContext.callMethod(context2, "verify_mode");
                if (!verify_mode.isNil()) {
                    int verify2 = RubyNumeric.fix2int((IRubyObject)verify_mode);
                    if (verify2 == 0) {
                        engine.setNeedClientAuth(false);
                        engine.setWantClientAuth(false);
                    }
                    if ((verify2 & 1) != 0) {
                        engine.setWantClientAuth(true);
                    }
                    if ((verify2 & 2) != 0) {
                        engine.setNeedClientAuth(true);
                    }
                }
                engine.beginHandshake();
                this.handshakeStatus = engine.getHandshakeStatus();
                this.initialHandshake = true;
            }
            this.doHandshake(blocking);
        }
        catch (SSLHandshakeException e) {
            String msg = e.getMessage();
            if (e.getCause() == null && msg != null && msg.contains("(protocol is disabled or cipher suites are inappropriate)")) {
                OpenSSL.debug(runtime, this.sslContext.getProtocol() + " protocol has been deactivated and is not available by default\n see the java.security.Security property jdk.tls.disabledAlgorithms in <JRE_HOME>/lib/security/java.security file");
            } else {
                OpenSSL.debugStackTrace(runtime, e);
            }
            throw SSLSocket.newSSLErrorFromHandshake(runtime, e);
        }
        catch (NoSuchAlgorithmException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw SSLSocket.newSSLError(runtime, e);
        }
        catch (KeyManagementException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw SSLSocket.newSSLError(runtime, e);
        }
        catch (IOException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw SSLSocket.newSSLError(runtime, e);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (RuntimeException e) {
            OpenSSL.debugStackTrace(runtime, e);
            if ("Could not generate DH keypair".equals(e.getMessage())) {
                throw SSL.handleCouldNotGenerateDHKeyPairError(runtime, e);
            }
            throw SSLSocket.newSSLError(runtime, e);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject verify_result(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        if (this.engine == null) {
            runtime.getWarnings().warn("SSL session is not started yet.");
            return runtime.getNil();
        }
        return runtime.newFixnum(this.verifyResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitSelect(final int operations, final boolean blocking) throws IOException {
        SocketChannelImpl channel = this.socketChannelImpl();
        if (!channel.isSelectable()) {
            return true;
        }
        final Ruby runtime = this.getRuntime();
        RubyThread thread = runtime.getCurrentContext().getThread();
        channel.configureBlocking(false);
        final Selector selector = runtime.getSelectorPool().get();
        final SelectionKey key = channel.register(selector, operations);
        try {
            Set<SelectionKey> keySet;
            this.io.addBlockingThread(thread);
            final int[] result = new int[1];
            thread.executeBlockingTask(new RubyThread.BlockingTask(){

                public void run() throws InterruptedException {
                    try {
                        if (!blocking) {
                            result[0] = selector.selectNow();
                            if (result[0] == 0) {
                                if ((operations & 1) != 0 && (operations & 4) != 0) {
                                    if (key.isReadable()) {
                                        SSLSocket.writeWouldBlock(runtime);
                                    } else if (key.isWritable()) {
                                        SSLSocket.readWouldBlock(runtime);
                                    } else {
                                        SSLSocket.readWouldBlock(runtime);
                                    }
                                } else if ((operations & 1) != 0) {
                                    SSLSocket.readWouldBlock(runtime);
                                } else if ((operations & 4) != 0) {
                                    SSLSocket.writeWouldBlock(runtime);
                                }
                            }
                        } else {
                            result[0] = selector.select();
                        }
                    }
                    catch (IOException ioe) {
                        throw runtime.newRuntimeError("Error with selector: " + ioe.getMessage());
                    }
                }

                public void wakeup() {
                    selector.wakeup();
                }
            });
            if (result[0] >= 1 && (keySet = selector.selectedKeys()).iterator().next() == key) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (key != null) {
                    key.cancel();
                }
                if (selector != null) {
                    selector.selectNow();
                }
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
            try {
                if (selector != null) {
                    runtime.getSelectorPool().put(selector);
                }
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
            this.io.removeBlockingThread(thread);
            thread.afterBlockingCall();
        }
    }

    private static void readWouldBlock(Ruby runtime) {
        throw SSL.newSSLErrorWaitReadable(runtime, "read would block");
    }

    private static void writeWouldBlock(Ruby runtime) {
        throw SSL.newSSLErrorWaitWritable(runtime, "write would block");
    }

    private void doHandshake(boolean blocking) throws IOException {
        block6: while (true) {
            boolean ready = this.waitSelect(5, blocking);
            if (!blocking && !ready) {
                throw this.getRuntime().newErrnoEAGAINError("Resource temporarily unavailable");
            }
            switch (this.handshakeStatus) {
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    if (this.initialHandshake) {
                        this.finishInitialHandshake();
                    }
                    return;
                }
                case NEED_TASK: {
                    this.doTasks();
                    continue block6;
                }
                case NEED_UNWRAP: {
                    if (this.readAndUnwrap(blocking) == -1 && this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
                        throw new SSLHandshakeException("Socket closed");
                    }
                    if (!this.initialHandshake || this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue block6;
                    this.waitSelect(1, blocking);
                    continue block6;
                }
                case NEED_WRAP: {
                    if (this.netData.hasRemaining()) {
                        while (this.flushData(blocking)) {
                        }
                    }
                    this.netData.clear();
                    SSLEngineResult result = this.engine.wrap(this.dummy, this.netData);
                    this.handshakeStatus = result.getHandshakeStatus();
                    this.netData.flip();
                    this.flushData(blocking);
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException("Unknown handshaking status: " + (Object)((Object)this.handshakeStatus));
    }

    private void doTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            task.run();
        }
        this.handshakeStatus = this.engine.getHandshakeStatus();
        this.verifyResult = this.sslContext.getLastVerifyResult();
    }

    private boolean flushData(boolean blocking) throws IOException {
        try {
            this.writeToChannel(this.netData, blocking);
        }
        catch (IOException ioe) {
            this.netData.position(this.netData.limit());
            throw ioe;
        }
        return this.netData.hasRemaining();
    }

    private int writeToChannel(ByteBuffer buffer, boolean blocking) throws IOException {
        int totalWritten = 0;
        while (buffer.hasRemaining()) {
            totalWritten += this.socketChannelImpl().write(buffer);
            if (blocking) continue;
            break;
        }
        return totalWritten;
    }

    private void finishInitialHandshake() {
        this.initialHandshake = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src, boolean blocking) throws SSLException, IOException {
        if (this.initialHandshake) {
            throw new IOException("Writing not possible during handshake");
        }
        SocketChannelImpl channel = this.socketChannelImpl();
        boolean blockingMode = channel.isBlocking();
        if (!blocking) {
            channel.configureBlocking(false);
        }
        try {
            if (this.netData.hasRemaining()) {
                this.flushData(blocking);
            }
            this.netData.clear();
            SSLEngineResult result = this.engine.wrap(src, this.netData);
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                throw this.getRuntime().newIOError("closed SSL engine");
            }
            this.netData.flip();
            this.flushData(blocking);
            int n = result.bytesConsumed();
            return n;
        }
        finally {
            if (!blocking) {
                channel.configureBlocking(blockingMode);
            }
        }
    }

    public int read(ByteBuffer dst, boolean blocking) throws IOException {
        int appBytesProduced;
        if (this.initialHandshake) {
            return 0;
        }
        if (this.engine.isInboundDone()) {
            return -1;
        }
        if (!(this.peerAppData.hasRemaining() || (appBytesProduced = this.readAndUnwrap(blocking)) != -1 && appBytesProduced != 0)) {
            return appBytesProduced;
        }
        int limit = Math.min(this.peerAppData.remaining(), dst.remaining());
        this.peerAppData.get(dst.array(), dst.arrayOffset(), limit);
        dst.position(dst.arrayOffset() + limit);
        return limit;
    }

    private int readAndUnwrap(boolean blocking) throws IOException {
        SSLEngineResult result;
        int bytesRead = this.socketChannelImpl().read(this.peerNetData);
        if (!(bytesRead != -1 || this.peerNetData.hasRemaining() && this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
            this.closeInbound();
            return -1;
        }
        this.peerAppData.clear();
        this.peerNetData.flip();
        while ((result = this.engine.unwrap(this.peerNetData, this.peerAppData)).getStatus() == SSLEngineResult.Status.OK && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && result.bytesProduced() == 0) {
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.finishInitialHandshake();
        }
        if (this.peerAppData.position() == 0 && result.getStatus() == SSLEngineResult.Status.OK && this.peerNetData.hasRemaining()) {
            result = this.engine.unwrap(this.peerNetData, this.peerAppData);
        }
        this.status = result.getStatus();
        this.handshakeStatus = result.getHandshakeStatus();
        if (bytesRead == -1 && !this.peerNetData.hasRemaining()) {
            this.closeInbound();
        }
        if (this.status == SSLEngineResult.Status.CLOSED) {
            this.doShutdown();
            return -1;
        }
        this.peerNetData.compact();
        this.peerAppData.flip();
        if (!(this.initialHandshake || this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK && this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP && this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED)) {
            this.doHandshake(blocking);
        }
        return this.peerAppData.remaining();
    }

    private void closeInbound() {
        try {
            this.engine.closeInbound();
        }
        catch (SSLException e) {
            OpenSSL.debug(this.getRuntime(), "SSLSocket.closeInbound", e);
        }
    }

    private void doShutdown() throws IOException {
        if (this.engine.isOutboundDone()) {
            return;
        }
        this.netData.clear();
        try {
            this.engine.wrap(this.dummy, this.netData);
        }
        catch (SSLException e) {
            OpenSSL.debug(this.getRuntime(), "SSLSocket.doShutdown", e);
            return;
        }
        catch (RuntimeException e) {
            OpenSSL.debugStackTrace(this.getRuntime(), e);
            return;
        }
        this.netData.flip();
        this.flushData(true);
    }

    private RubyString sysreadImpl(ThreadContext context2, IRubyObject[] args, boolean blocking) {
        Ruby runtime = context2.runtime;
        int len = RubyNumeric.fix2int((IRubyObject)args[0]);
        RubyString buff = args.length == 2 && !args[1].isNil() ? args[1].asString() : runtime.newString();
        if (len == 0) {
            buff.clear();
            return buff;
        }
        if (len < 0) {
            throw runtime.newArgumentError("negative string size (or size too big)");
        }
        try {
            if (this.engine == null || !this.peerAppData.hasRemaining() && this.peerNetData.position() <= 0) {
                this.waitSelect(1, blocking);
            }
            ByteBuffer dst = ByteBuffer.allocate(len);
            int rr = -1;
            while (rr <= 0) {
                rr = this.engine == null ? this.socketChannelImpl().read(dst) : this.read(dst, blocking);
                if (rr == -1) {
                    throw runtime.newEOFError();
                }
                if (rr != 0 || this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                this.waitSelect(1, blocking);
            }
            byte[] bss = new byte[rr];
            dst.position(dst.position() - rr);
            dst.get(bss);
            buff.setValue(new ByteList(bss, false));
            return buff;
        }
        catch (IOException ioe) {
            throw runtime.newIOError(ioe.getMessage());
        }
    }

    @JRubyMethod(rest=true, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context2, IRubyObject[] args) {
        return this.sysreadImpl(context2, args, true);
    }

    @JRubyMethod(rest=true, required=1, optional=2)
    public IRubyObject sysread_nonblock(ThreadContext context2, IRubyObject[] args) {
        return this.sysreadImpl(context2, args, false);
    }

    private IRubyObject do_syswrite(ThreadContext context2, IRubyObject arg, boolean blocking) {
        Ruby runtime = context2.runtime;
        try {
            this.checkClosed();
            this.waitSelect(4, blocking);
            ByteList bls = arg.asString().getByteList();
            ByteBuffer b1 = ByteBuffer.wrap(bls.getUnsafeBytes(), bls.getBegin(), bls.getRealSize());
            int written = this.engine == null ? this.writeToChannel(b1, blocking) : this.write(b1, blocking);
            this.io.callMethod(context2, "flush");
            return runtime.newFixnum(written);
        }
        catch (IOException ioe) {
            throw runtime.newIOError(ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject syswrite(ThreadContext context2, IRubyObject arg) {
        return this.do_syswrite(context2, arg, true);
    }

    @JRubyMethod
    public IRubyObject syswrite_nonblock(ThreadContext context2, IRubyObject arg) {
        return this.do_syswrite(context2, arg, false);
    }

    @JRubyMethod
    public IRubyObject syswrite_nonblock(ThreadContext context2, IRubyObject arg, IRubyObject options) {
        return this.do_syswrite(context2, arg, false);
    }

    private void checkClosed() {
        if (!this.socketChannelImpl().isOpen()) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    private void forceClose() {
        this.close(true);
    }

    private void close(boolean force) {
        if (this.engine == null) {
            throw this.getRuntime().newEOFError();
        }
        this.engine.closeOutbound();
        if (!force && this.netData.hasRemaining()) {
            return;
        }
        try {
            this.doShutdown();
        }
        catch (IOException e) {
            OpenSSL.debug(this.getRuntime(), "SSLSocket.close doShutdown failed", e);
        }
    }

    @JRubyMethod
    public IRubyObject sysclose(ThreadContext context2) {
        this.close(this.sslContext.isProtocolForClient());
        if (this.callMethod(context2, "sync_close").isTrue()) {
            this.io.callMethod(context2, "close");
        }
        return context2.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject cert() {
        Ruby runtime = this.getRuntime();
        if (this.engine == null) {
            return runtime.getNil();
        }
        try {
            Certificate[] cert2 = this.engine.getSession().getLocalCertificates();
            if (cert2 != null && cert2.length > 0) {
                return X509Cert.wrap(runtime, cert2[0]);
            }
        }
        catch (java.security.cert.CertificateEncodingException e) {
            throw X509Cert.newCertificateError(runtime, e);
        }
        return runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject peer_cert() {
        Ruby runtime;
        block5: {
            runtime = this.getRuntime();
            if (this.engine == null) {
                return runtime.getNil();
            }
            try {
                Certificate[] cert2 = this.engine.getSession().getPeerCertificates();
                if (cert2.length > 0) {
                    return X509Cert.wrap(runtime, cert2[0]);
                }
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw X509Cert.newCertificateError(runtime, e);
            }
            catch (SSLPeerUnverifiedException e) {
                if (!runtime.isVerbose() && !OpenSSL.isDebug(runtime)) break block5;
                runtime.getWarnings().warning(String.format("%s: %s", e.getClass().getName(), e.getMessage()));
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject peer_cert_chain() {
        Ruby runtime = this.getRuntime();
        if (this.engine == null) {
            return runtime.getNil();
        }
        try {
            X509Certificate[] certs = this.engine.getSession().getPeerCertificateChain();
            RubyArray arr = runtime.newArray(certs.length);
            for (int i2 = 0; i2 < certs.length; ++i2) {
                arr.append(X509Cert.wrap(runtime, certs[i2]));
            }
            return arr;
        }
        catch (CertificateEncodingException e) {
            throw X509Cert.newCertificateError(this.getRuntime(), e);
        }
        catch (SSLPeerUnverifiedException e) {
            if (runtime.isVerbose() || OpenSSL.isDebug(runtime)) {
                runtime.getWarnings().warning(String.format("%s: %s", e.getClass().getName(), e.getMessage()));
            }
            return runtime.getNil();
        }
    }

    @JRubyMethod
    public IRubyObject cipher() {
        if (this.engine == null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newString(this.engine.getSession().getCipherSuite());
    }

    @JRubyMethod
    public IRubyObject state() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: SSLSocket#state");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject pending() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: SSLSocket#pending");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"session_reused?"})
    public IRubyObject session_reused_p() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: SSLSocket#session_reused? is not supported");
        return this.getRuntime().getNil();
    }

    javax.net.ssl.SSLSession getSession() {
        return this.engine == null ? null : this.engine.getSession();
    }

    @JRubyMethod(name={"session"})
    public IRubyObject session(ThreadContext context2) {
        if (this.getSession() == null) {
            return context2.nil;
        }
        if (this.session == null) {
            this.session = new SSLSession(context2.runtime).initializeImpl(context2, this);
            return this.session;
        }
        return this.session;
    }

    @JRubyMethod(name={"session="})
    public IRubyObject set_session(IRubyObject session2) {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: SSLSocket#session= is not supported");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject ssl_version() {
        if (this.engine == null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newString(this.engine.getSession().getProtocol());
    }

    private SocketChannelImpl socketChannelImpl() {
        if (this.socketChannel != null) {
            return this.socketChannel;
        }
        Channel channel = this.io.getChannel();
        if (channel instanceof SocketChannel) {
            this.socketChannel = new JavaSocketChannel((SocketChannel)channel);
            return this.socketChannel;
        }
        throw new IllegalStateException("unknow channel impl: " + channel + " of type " + channel.getClass().getName());
    }

    private static boolean jnrChannel(Channel channel) {
        return channel.getClass().getName().startsWith("jnr.");
    }

    private static final class JavaSocketChannel
    implements SocketChannelImpl {
        private final SocketChannel channel;

        JavaSocketChannel(SocketChannel channel) {
            this.channel = channel;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.channel.read(dst);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.channel.write(src);
        }

        @Override
        public int getRemotePort() {
            return this.channel.socket().getPort();
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean isBlocking() {
            return this.channel.isBlocking();
        }

        @Override
        public void configureBlocking(boolean block) throws IOException {
            this.channel.configureBlocking(block);
        }

        @Override
        public SelectionKey register(Selector selector, int ops) throws ClosedChannelException {
            return this.channel.register(selector, ops);
        }

        public boolean selectionOpsReadable(int readyOps) {
            return (readyOps & 1) != 0;
        }

        public boolean selectionOpsWritable(int readyOps) {
            return (readyOps & 4) != 0;
        }
    }

    private static interface SocketChannelImpl {
        public boolean isOpen();

        public int read(ByteBuffer var1) throws IOException;

        public int write(ByteBuffer var1) throws IOException;

        public int getRemotePort();

        public boolean isSelectable();

        public boolean isBlocking();

        public void configureBlocking(boolean var1) throws IOException;

        public SelectionKey register(Selector var1, int var2) throws IOException;
    }
}

