/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.tab;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.tab.Messages;
import com.jrockit.mc.console.ui.notification.tab.RuleGroup;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;

public class TriggerToolkit {
    private static String PREF_KEY_DEFAULT_TRIGGER_RULES_INITIALIZED = "com.jrockit.console.ui.notification.table.default.triggers.initialized";
    private static String PREF_KEY_EXPANDED_TRIGGERS = "com.jrockit.console.ui.notification.table.expanded.rule.groups";
    private static String DUMMY_GROUP_NAME = "Dummy, because IDialogSettings doesn't returns null for an empty array";

    public static boolean hasDefaultTriggersBeenLoaded() {
        return NotificationPlugin.getDefault().getPreferenceStore().getBoolean(PREF_KEY_DEFAULT_TRIGGER_RULES_INITIALIZED);
    }

    public static void setDefaultTriggersLoaded() {
        NotificationPlugin.getDefault().getPreferenceStore().setValue(PREF_KEY_DEFAULT_TRIGGER_RULES_INITIALIZED, true);
    }

    public void logRegisteredStatus(IConnectionHandle connectionHandle) {
        System.out.println("Registered on this connection");
        System.out.println("==========================");
        for (TriggerRule rule : TriggerToolkit.getNotificationRepository().getRegisteredRules(connectionHandle.getServerDescriptor().getGUID())) {
            System.out.println(String.valueOf(rule.getName()) + ' ' + rule.hashCode());
        }
        System.out.println("All Available rules");
        System.out.println("==========================");
        for (TriggerRule rule : TriggerToolkit.getNotificationRepository().getAvailableRules()) {
            System.out.println(String.valueOf(rule.getName()) + ' ' + rule.hashCode());
        }
    }

    public static IStatus resetTriggers() {
        InputStream stream = null;
        try {
            try {
                TriggerRule[] rules;
                stream = NotificationPlugin.getDefault().openDefaultTriggerFile();
                Document doc = XmlToolkit.loadDocumentFromStream((InputStream)new BufferedInputStream(stream));
                Collection c = TriggerToolkit.getNotificationRepository().getAvailableRules();
                TriggerRule[] triggerRuleArray = rules = c.toArray(new TriggerRule[c.size()]);
                int n = rules.length;
                int n2 = 0;
                while (n2 < n) {
                    TriggerRule rule = triggerRuleArray[n2];
                    TriggerToolkit.getNotificationRepository().removeNotificationRule(rule);
                    ++n2;
                }
                TriggerToolkit.getNotificationRepository().importFromXML(doc);
            }
            catch (Exception exc) {
                IStatus iStatus = StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerToolkit_ERROR_COULD_NOT_READ_DEFAULTE_TEMPLATE_FILE, (Object)"default_rules.xml"), (Throwable)exc, (boolean)false);
                TriggerToolkit.close(stream);
                return iStatus;
            }
        }
        finally {
            TriggerToolkit.close(stream);
        }
        return StatusFactory.createOk((String)Messages.TriggerToolkit_MESSAGE_DEFAULT_TRIGGERS_LOADED);
    }

    public static void storeExpansionState(TreeViewer viewer) {
        ArrayList<String> expandThese = new ArrayList<String>();
        expandThese.add(DUMMY_GROUP_NAME);
        Object[] objectArray = viewer.getExpandedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuleGroup group;
            Object element = objectArray[n2];
            if (element instanceof RuleGroup && (group = (RuleGroup)element).getName() != null) {
                expandThese.add(group.getName());
            }
            ++n2;
        }
        NotificationPlugin.getDefault().getDialogSettings().put(PREF_KEY_EXPANDED_TRIGGERS, expandThese.toArray(new String[expandThese.size()]));
    }

    public static void retrieveExpansionState(TreeViewer viewer) {
        String[] expanded = NotificationPlugin.getDefault().getDialogSettings().getArray(PREF_KEY_EXPANDED_TRIGGERS);
        if (expanded == null) {
            TriggerToolkit.expandRuleGroupWithNames(viewer, TriggerToolkit.getRuleGroupNames(3));
        } else {
            TriggerToolkit.expandRuleGroupWithNames(viewer, expanded);
        }
    }

    private static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void expandRuleGroupWithNames(TreeViewer viewer, String[] names) {
        ArrayList<RuleGroup> list = new ArrayList<RuleGroup>();
        int n = 0;
        while (n < names.length) {
            if (names[n] != null && !names[n].equals(DUMMY_GROUP_NAME)) {
                list.add(new RuleGroup(names[n]));
            }
            ++n;
        }
        viewer.setExpandedElements(list.toArray());
    }

    private static String[] getRuleGroupNames(int maxCount) {
        ArrayList<String> list = new ArrayList<String>();
        TriggerRule[] rules = TriggerToolkit.getNotificationRepository().getAvailableRules().toArray(new TriggerRule[TriggerToolkit.getNotificationRepository().getAvailableRules().size()]);
        int n = 0;
        while (n < rules.length) {
            if (rules[n].getRulePath() != null && !list.contains(rules[n].getRulePath())) {
                list.add(rules[n].getRulePath());
            }
            ++n;
        }
        return list.toArray(new String[list.size()]);
    }

    public static NotificationRegistry getNotificationRepository() {
        return (NotificationRegistry)RJMXPlugin.getDefault().getService(NotificationRegistry.class);
    }
}

