/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.uicomponents;

import com.jrockit.mc.console.ui.notification.uicomponents.Messages;
import com.jrockit.mc.console.ui.notification.uicomponents.TextInputItem;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.rjmx.triggers.fields.internal.Field;
import com.jrockit.mc.ui.misc.ControlDecorationToolkit;
import com.jrockit.mc.ui.uibuilder.IUIBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class FileInputItem
extends TextInputItem {
    public FileInputItem(Field field, IUIBuilder builder) {
        super(field, builder);
    }

    @Override
    protected void createUI() {
        this.getUIBuilder().createLabel(String.valueOf(this.getField().getName()) + ":", "");
        this.m_text = this.getUIBuilder().createText(this.getField().getValue(), this.getField().getDescription(), 0);
        Button browseButton = this.getUIBuilder().createButton(Messages.FileInputItem_BUTTON_BROWSE_TEXT, Messages.FileInputItem_BUTTON_BROWSE_TOOLTIP);
        browseButton.addSelectionListener((SelectionListener)new BrowseSelectionListener());
        this.getUIBuilder().layout();
        final ControlDecoration infoDecorator = ControlDecorationToolkit.createDecorator((Control)this.m_text, (int)131200, (String)"DEC_INFORMATION");
        infoDecorator.setShowOnlyOnFocus(false);
        this.m_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus validateFile = IDESupportToolkit.validateFileResourcePath((String)FileInputItem.this.m_text.getText());
                if (validateFile.isOK()) {
                    infoDecorator.hide();
                } else {
                    infoDecorator.setDescriptionText(validateFile.getMessage());
                    infoDecorator.show();
                }
            }
        });
        this.m_text.setText(this.getField().getValue());
    }

    private final class BrowseSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            MCFile file = this.onBrowse();
            if (file != null) {
                FileInputItem.this.getField().setValue(file.getPath());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private MCFile onBrowse() {
            return CorePlugin.getDefault().getIDESupport().browseForSaveAsFile(NLS.bind((String)Messages.FileInputItem_SELECT_FIELD_TEXT, (Object)FileInputItem.this.getField().getName()), FileInputItem.this.getField().getValue(), null, "");
        }
    }
}

