/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.util.List;
import org.netbeans.api.visual.action.ConnectDecorator;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ConnectAction
extends WidgetAction.LockedAdapter {
    private static final int MIN_DIFFERENCE = 5;
    private ConnectDecorator decorator;
    private Widget interractionLayer;
    private ConnectProvider provider;
    private ConnectionWidget connectionWidget = null;
    private Widget sourceWidget = null;
    private Widget targetWidget = null;
    private Point startingPoint = null;

    public ConnectAction(ConnectDecorator connectDecorator, Widget widget, ConnectProvider connectProvider) {
        this.decorator = connectDecorator;
        this.interractionLayer = widget;
        this.provider = connectProvider;
    }

    @Override
    protected boolean isLocked() {
        return this.sourceWidget != null;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        return this.mousePressedCore(widget, widgetMouseEvent);
    }

    protected WidgetAction.State mousePressedCore(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1 && this.provider.isSourceWidget(widget)) {
            this.sourceWidget = widget;
            this.targetWidget = null;
            this.startingPoint = new Point(widgetMouseEvent.getPoint());
            this.connectionWidget = this.decorator.createConnectionWidget(this.interractionLayer.getScene());
            assert (this.connectionWidget != null);
            this.connectionWidget.setSourceAnchor(this.decorator.createSourceAnchor(widget));
            this.interractionLayer.addChild(this.connectionWidget);
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        Point point = widgetMouseEvent.getPoint();
        boolean bl = this.move(widget, point);
        if (bl) {
            if (this.targetWidget != null && (Math.abs(this.startingPoint.x - point.x) >= 5 || Math.abs(this.startingPoint.y - point.y) >= 5)) {
                this.provider.createConnection(this.sourceWidget, this.targetWidget);
            }
            this.cancel();
        }
        return bl ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    private void cancel() {
        this.sourceWidget = null;
        this.targetWidget = null;
        this.startingPoint = null;
        this.connectionWidget.setSourceAnchor(null);
        this.connectionWidget.setTargetAnchor(null);
        this.interractionLayer.removeChild(this.connectionWidget);
        this.connectionWidget = null;
    }

    @Override
    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.move(widget, widgetMouseEvent.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point point) {
        if (this.sourceWidget != widget) {
            return false;
        }
        Point point2 = widget.convertLocalToScene(point);
        this.targetWidget = this.resolveTargetWidgetCore(this.interractionLayer.getScene(), point2);
        Anchor anchor = null;
        if (this.targetWidget != null) {
            anchor = this.decorator.createTargetAnchor(this.targetWidget);
        }
        if (anchor == null) {
            anchor = this.decorator.createFloatAnchor(point2);
        }
        this.connectionWidget.setTargetAnchor(anchor);
        return true;
    }

    private Widget resolveTargetWidgetCore(Scene scene, Point point) {
        if (this.provider != null && this.provider.hasCustomTargetWidgetResolver(scene)) {
            return this.provider.resolveTargetWidget(scene, point);
        }
        Point point2 = scene.getLocation();
        point = new Point(point.x + point2.x, point.y + point2.y);
        Widget[] widgetArray = new Widget[]{null};
        this.resolveTargetWidgetCoreDive(widgetArray, scene, point);
        return widgetArray[0];
    }

    private boolean resolveTargetWidgetCoreDive(Widget[] widgetArray, Widget widget, Point point) {
        if (this.interractionLayer.equals(widget)) {
            return false;
        }
        Point point2 = widget.getLocation();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        if (!widget.getBounds().contains(point3)) {
            return false;
        }
        List<Widget> list = widget.getChildren();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!this.resolveTargetWidgetCoreDive(widgetArray, list.get(i), point3)) continue;
            return true;
        }
        if (!widget.isHitAt(point3)) {
            return false;
        }
        ConnectorState connectorState = this.provider.isTargetWidget(this.sourceWidget, widget);
        if (connectorState == ConnectorState.REJECT) {
            return false;
        }
        if (connectorState == ConnectorState.ACCEPT) {
            widgetArray[0] = widget;
        }
        return true;
    }

    @Override
    public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
        if (this.isLocked() && widgetKeyEvent.getKeyCode() == 27) {
            this.cancel();
            return WidgetAction.State.CONSUMED;
        }
        return super.keyPressed(widget, widgetKeyEvent);
    }
}

