/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.StartRecordingWizard;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.JVMSupportToolkit;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.ui.wizards.AbstractWizardUserAction;
import java.io.Closeable;
import org.eclipse.jface.wizard.IWizard;

public class StartRecordingAction
extends AbstractWizardUserAction {
    private final FlightRecorderProvider recorder;

    public StartRecordingAction(FlightRecorderProvider recorder) {
        super(Messages.ACTION_START_RECORDING_LABEL, Messages.ACTION_START_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("FLR_on.gif"));
        this.recorder = recorder;
    }

    public IWizard doCreateWizard() throws Exception {
        IConnectionHandle handle;
        block5: {
            StartRecordingWizard startRecordingWizard;
            handle = null;
            try {
                handle = this.recorder.getServerHandle().connect(Messages.ACTION_START_RECORDING_LABEL);
                IFlightRecorderService flrService = (IFlightRecorderService)handle.getServiceOrNull(IFlightRecorderService.class);
                if (flrService == null) {
                    throw new FlightRecorderException(JVMSupportToolkit.getNoFlightRecorderErrorMessage((IConnectionHandle)handle, (boolean)false));
                }
                if (!flrService.isEnabled() && !ControlPanel.askUserForEnable(flrService, Messages.COMMERCIAL_FEATURES_QUESTION)) break block5;
                MCFile recFile = ControlPanel.getDefaultRecordingFile(this.recorder.getServerHandle());
                RecordingWizardModel model = new RecordingWizardModel(flrService, recFile);
                this.recorder.resetWarning();
                startRecordingWizard = new StartRecordingWizard(model, this.recorder);
            }
            catch (Exception e) {
                try {
                    this.recorder.setWarning(e.getLocalizedMessage());
                    throw e;
                }
                catch (Throwable throwable) {
                    IOToolkit.closeSilently(handle);
                    throw throwable;
                }
            }
            IOToolkit.closeSilently((Closeable)handle);
            return startRecordingWizard;
        }
        IOToolkit.closeSilently((Closeable)handle);
        return null;
    }
}

