/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.BinaryPrefix;
import com.jrockit.mc.common.unit.BinaryScaleFactor;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.ScaleFactor;
import java.util.HashMap;
import java.util.Map;

public class BinaryUnitSelector
implements IUnit.UnitSelector<LinearQuantity, LinearUnit> {
    protected final LinearKindOfQuantity kindOfQuantity;
    protected final Map<ScaleFactor, LinearUnit> unitCache = new HashMap<ScaleFactor, LinearUnit>();

    public BinaryUnitSelector(LinearKindOfQuantity kindOfQuantity) {
        this.kindOfQuantity = kindOfQuantity;
        this.unitCache.put(BinaryScaleFactor.get(0), kindOfQuantity.atomUnit);
    }

    public BinaryUnitSelector(LinearKindOfQuantity kindOfQuantity, Iterable<BinaryPrefix> prefixes) {
        this(kindOfQuantity);
        for (BinaryPrefix prefix : prefixes) {
            this.unitCache.put(prefix.scaleFactor(), kindOfQuantity.getUnit(prefix));
        }
    }

    @Override
    public LinearUnit getPreferredUnit(LinearQuantity quantity, double minNumericalValue, double maxNumericalValue) {
        LinearUnit atomUnit = this.kindOfQuantity.atomUnit;
        double absVal = Math.abs(quantity.doubleValueIn(atomUnit));
        if (absVal > minNumericalValue && absVal < maxNumericalValue) {
            return atomUnit;
        }
        BinaryScaleFactor factor = BinaryScaleFactor.getFloor1024Factor(absVal);
        LinearUnit unit = this.unitCache.get(factor);
        if (unit == null) {
            String unitName = factor.asExponentialStringBuilder(true).append(atomUnit.getAppendableSuffix(false)).toString();
            unit = new LinearUnit(this.kindOfQuantity, null, factor, unitName, unitName, new String[0]);
            this.unitCache.put(factor, unit);
        }
        return unit;
    }
}

