/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.util.Messages;
import com.jrockit.mc.common.util.Toolkit;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;

public final class TimeRangeToolkit
extends Toolkit {
    private static final int MILLIS_FORMAT_INDEX = 2;
    private static final int NANOS_FORMAT_INDEX = 0;
    private static final String PROTOTYPE_DEFAULT;
    private static final String MILLIS_ULP;
    private static final long NANOS = 1L;
    private static final long MICROS = 1000L;
    private static final long MILLIS = 1000000L;
    private static final long SECONDS = 1000000000L;
    private static final long MINUTES = 60000000000L;
    private static final long HOURS = 3600000000000L;
    private static final long DAYS = 86400000000000L;
    private static final long WEEKS = 604800000000000L;
    private static final long[] VALUE_ARRAY;
    private static final String[][] UNIT_PARSE_ARRAY;
    private static final String[][] UNIT_FORMAT_ARRAY;
    private static final String INVALID_FORMAT_UNIT = "thisUnitIsInvalidForThisFormat";

    static {
        VALUE_ARRAY = new long[]{1L, 1000L, 1000000L, 1000000000L, 60000000000L, 3600000000000L, 86400000000000L, 604800000000000L};
        String[][] unitKeys = new String[][]{{"TimeRangeToolkit_NANOS_SHORT", "ns", "ns", "TimeRangeToolkit_NANOS", "nanos", "TimeRangeToolkit_NANOS_LONG", "nanoseconds"}, {"TimeRangeToolkit_MICROS_SHORT", "\u03bcs", "us", "TimeRangeToolkit_MICROS", "micros", "TimeRangeToolkit_MICROS_LONG", "microseconds"}, {"TimeRangeToolkit_MILLIS_SHORT", "ms", "ms", "TimeRangeToolkit_MILLIS", "millis", "TimeRangeToolkit_MILLIS_LONG", "milliseconds"}, {"TimeRangeToolkit_SECONDS_SHORT", "s", "s", "TimeRangeToolkit_SECONDS", "sec", "TimeRangeToolkit_SECONDS_LONG", "seconds"}, {"TimeRangeToolkit_MINUTES_SHORT", "min", "m", "TimeRangeToolkit_MINUTES", "minutes"}, {"TimeRangeToolkit_HOURS_SHORT", "h", "h", "TimeRangeToolkit_HOURS", "hours"}, {"TimeRangeToolkit_DAYS", "d", "d", "TimeRangeToolkit_DAYS_SHORT", "days"}, {"TimeRangeToolkit_WEEKS", "w", INVALID_FORMAT_UNIT, "TimeRangeToolkit_WEEKS_SHORT", "weeks"}};
        UNIT_FORMAT_ARRAY = new String[unitKeys.length][];
        UNIT_PARSE_ARRAY = new String[unitKeys.length][];
        int i = 0;
        while (i < UNIT_PARSE_ARRAY.length) {
            String[] keys = unitKeys[i];
            String[] units = new String[keys.length];
            int j = 0;
            while (j < units.length) {
                units[j] = Messages.getString(keys[j], keys[j]);
                ++j;
            }
            TimeRangeToolkit.UNIT_PARSE_ARRAY[i] = units;
            TimeRangeToolkit.UNIT_FORMAT_ARRAY[i] = Arrays.copyOf(units, 3);
            ++i;
        }
        TimeRangeToolkit.UNIT_PARSE_ARRAY[4][2] = "min";
        TimeRangeToolkit.UNIT_PARSE_ARRAY[7][2] = "w";
        PROTOTYPE_DEFAULT = TimeRangeToolkit.toPrototype(30);
        MILLIS_ULP = "1 ms";
    }

    private static String toPrototype(Number value) {
        return value + " s";
    }

    public static String standardizeFormat(String timerange, Format fmt, boolean allowMultipleParts) throws QuantityConversionException {
        if (timerange.length() == 0) {
            return timerange;
        }
        String[] parts = TimeRangeToolkit.splitTimerange(timerange);
        StringBuilder standardizedTimeRange = new StringBuilder();
        if (!allowMultipleParts && parts.length > 1) {
            return TimeRangeToolkit.convertNanosToNormalizedString(TimeRangeToolkit.parseNanos(timerange), fmt);
        }
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String standardizedPart = TimeRangeToolkit.standardizePart(part, fmt);
            if (INVALID_FORMAT_UNIT.equals(standardizedPart)) {
                return TimeRangeToolkit.convertNanosToNormalizedString(TimeRangeToolkit.parseNanos(timerange), fmt);
            }
            standardizedTimeRange.append(standardizedPart).append(" ");
            ++n2;
        }
        return standardizedTimeRange.toString().trim();
    }

    public static long parseMillis(String timerange) throws QuantityConversionException {
        long nanos = TimeRangeToolkit.parseNanos(timerange);
        if (nanos < 1000000L && nanos != 0L) {
            throw QuantityConversionException.belowPrecision(timerange, MILLIS_ULP);
        }
        if (nanos < 86400000000000L) {
            return Math.round((double)nanos / 1000000.0);
        }
        return nanos / 1000000L;
    }

    public static long parseNanos(String timerange) throws QuantityConversionException {
        if (timerange.length() == 0) {
            throw QuantityConversionException.unparsable(timerange, PROTOTYPE_DEFAULT);
        }
        String[] parts = TimeRangeToolkit.splitTimerange(timerange);
        long nanos = 0L;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            nanos += TimeRangeToolkit.parseNanoPart(part);
            ++n2;
        }
        return nanos;
    }

    /*
     * Unable to fully structure code
     */
    private static String[] splitTimerange(String timerange) {
        parts = new ArrayList<String>();
        length = timerange.length();
        decimal_separator = new DecimalFormatSymbols().getDecimalSeparator();
        pos = startPos = 0;
        ** GOTO lbl20
        {
            ++pos;
            do {
                if (pos < length && Character.isWhitespace(timerange.charAt(pos))) continue block0;
                while (pos < length && (Character.isDigit(timerange.charAt(pos)) || timerange.charAt(pos) == decimal_separator)) {
                    ++pos;
                }
                while (pos < length && (Character.isWhitespace(timerange.charAt(pos)) || Character.isLetter(timerange.charAt(pos)))) {
                    ++pos;
                }
                if (startPos == pos) {
                    pos = startPos + 1;
                }
                parts.add(timerange.substring(startPos, pos));
                startPos = pos;
lbl20:
                // 2 sources

            } while (startPos < length);
        }
        return parts.toArray(new String[parts.size()]);
    }

    private static long parseNanoPart(String timerange) throws QuantityConversionException {
        Toolkit.Holder holder = null;
        try {
            holder = new Toolkit.Holder(timerange);
        }
        catch (NumberFormatException e) {
            throw QuantityConversionException.unparsable(timerange, PROTOTYPE_DEFAULT);
        }
        catch (ParseException e) {
            throw QuantityConversionException.unparsable(timerange, PROTOTYPE_DEFAULT);
        }
        if (holder.unit == null || "".equals(holder.unit)) {
            throw QuantityConversionException.noUnit(timerange, TimeRangeToolkit.toPrototype(holder.value));
        }
        int i = 0;
        while (i < VALUE_ARRAY.length) {
            if (TimeRangeToolkit.isCompatibleUnit(holder, UNIT_PARSE_ARRAY[i])) {
                return TimeRangeToolkit.multiply(holder.value, VALUE_ARRAY[i]);
            }
            ++i;
        }
        throw QuantityConversionException.unknownUnit(holder.unit, TimeRangeToolkit.toPrototype(holder.value));
    }

    private static String standardizePart(String timerange, Format fmt) throws QuantityConversionException {
        Toolkit.Holder holder = null;
        try {
            holder = new Toolkit.Holder(timerange);
        }
        catch (NumberFormatException e) {
            throw QuantityConversionException.unparsable(timerange, PROTOTYPE_DEFAULT);
        }
        catch (ParseException e) {
            throw QuantityConversionException.unparsable(timerange, PROTOTYPE_DEFAULT);
        }
        if (holder.unit == null || "".equals(holder.unit)) {
            throw QuantityConversionException.noUnit(timerange, TimeRangeToolkit.toPrototype(holder.value));
        }
        int i = 0;
        while (i < VALUE_ARRAY.length) {
            if (TimeRangeToolkit.isCompatibleUnit(holder, UNIT_PARSE_ARRAY[i])) {
                if (INVALID_FORMAT_UNIT.equals(UNIT_FORMAT_ARRAY[i][fmt.uIdx])) {
                    return INVALID_FORMAT_UNIT;
                }
                return holder.value + " " + UNIT_FORMAT_ARRAY[i][fmt.uIdx];
            }
            ++i;
        }
        throw QuantityConversionException.unknownUnit(holder.unit, TimeRangeToolkit.toPrototype(holder.value));
    }

    public static String convertMillisToNormalizedString(long millis, Format fmt) {
        if (millis == 0L) {
            return "0 " + UNIT_FORMAT_ARRAY[2][fmt.uIdx];
        }
        return TimeRangeToolkit.convertNanosToNormalizedString(millis * 1000000L, fmt);
    }

    public static String convertNanosToNormalizedString(long nanos, Format fmt) {
        if (nanos == 0L) {
            return "0 " + UNIT_FORMAT_ARRAY[0][fmt.uIdx];
        }
        if (nanos < 0L) {
            return String.valueOf('-') + TimeRangeToolkit.convertNanosToNormalizedString(-nanos, fmt);
        }
        int i = fmt.maxValueIdx;
        while (i >= 0) {
            if (TimeRangeToolkit.divisibleBy(nanos, VALUE_ARRAY[i]) && !INVALID_FORMAT_UNIT.equals(UNIT_FORMAT_ARRAY[i][fmt.uIdx])) {
                long value = nanos / VALUE_ARRAY[i];
                String unit = value == 1L ? TimeRangeToolkit.singularilize(UNIT_FORMAT_ARRAY[i][fmt.uIdx]) : UNIT_FORMAT_ARRAY[i][fmt.uIdx];
                return String.valueOf(String.valueOf(value)) + ' ' + unit;
            }
            --i;
        }
        return String.valueOf(String.valueOf(nanos)) + ' ' + UNIT_FORMAT_ARRAY[0][fmt.uIdx];
    }

    public static String convertMillisToString(long millis) {
        if (millis == 0L) {
            return "0 " + UNIT_FORMAT_ARRAY[2][Format.LOCALIZED.uIdx];
        }
        return TimeRangeToolkit.convertToLocalizedString(millis * 1000000L, 1000000L);
    }

    public static String convertMillisToSecondsString(long millis) {
        if (millis == 0L) {
            return "0 " + UNIT_FORMAT_ARRAY[2][Format.LOCALIZED.uIdx];
        }
        return TimeRangeToolkit.convertToLocalizedString(millis * 1000000L, 1000000000L);
    }

    public static String convertNanosToString(long nanos) {
        if (nanos == 0L) {
            return String.valueOf(String.valueOf(nanos)) + ' ' + UNIT_FORMAT_ARRAY[0][Format.LOCALIZED.uIdx];
        }
        if (nanos > 1000000000L) {
            return TimeRangeToolkit.convertToLocalizedString(nanos, 1000000L);
        }
        if (nanos > 1000000L) {
            return TimeRangeToolkit.convertToLocalizedString(nanos, 1000L);
        }
        return TimeRangeToolkit.convertToLocalizedString(nanos, 1L);
    }

    public static String convertNanosToApproximateString(long nanos, int maxNumberOfComponents) {
        if (nanos == 0L) {
            return String.valueOf(String.valueOf(nanos)) + ' ' + UNIT_FORMAT_ARRAY[0][Format.LOCALIZED.uIdx];
        }
        maxNumberOfComponents = Math.max(1, maxNumberOfComponents);
        long cutoff = 0L;
        int i = VALUE_ARRAY.length - 1;
        while (i >= 0) {
            if (nanos >= VALUE_ARRAY[i]) {
                cutoff = VALUE_ARRAY[Math.max(i - maxNumberOfComponents + 1, 0)];
                break;
            }
            --i;
        }
        return TimeRangeToolkit.convertToLocalizedString(nanos, cutoff);
    }

    private static String convertToLocalizedString(long nanos, long cutoff) {
        if (nanos == Long.MIN_VALUE) {
            return Messages.getString("TimeRangeToolkit_N_A", "N/A");
        }
        if (nanos < 0L) {
            return String.valueOf('-') + TimeRangeToolkit.convertToLocalizedString(-nanos, cutoff);
        }
        long nanosLeft = nanos;
        StringBuilder s = new StringBuilder();
        int i = VALUE_ARRAY.length - 1;
        while (i >= 0 && VALUE_ARRAY[i] >= cutoff) {
            if (nanosLeft >= VALUE_ARRAY[i] && !INVALID_FORMAT_UNIT.equals(UNIT_FORMAT_ARRAY[i][Format.LOCALIZED.uIdx])) {
                long value = nanosLeft / VALUE_ARRAY[i];
                nanosLeft -= value * VALUE_ARRAY[i];
                String unit = value == 1L ? TimeRangeToolkit.singularilize(UNIT_FORMAT_ARRAY[i][Format.LOCALIZED.uIdx]) : UNIT_FORMAT_ARRAY[i][Format.LOCALIZED.uIdx];
                s.append(String.valueOf(value)).append(' ').append(unit).append(' ');
            }
            --i;
        }
        return s.toString().trim();
    }

    private static String singularilize(String unit) {
        if (unit.endsWith("s") && unit.length() >= 3) {
            return unit.substring(0, unit.length() - 1);
        }
        return unit;
    }

    private static boolean divisibleBy(long millis, long factor) {
        return millis % factor == 0L;
    }

    static /* synthetic */ long[] access$0() {
        return VALUE_ARRAY;
    }

    public static enum Format {
        LOCALIZED(0, TimeRangeToolkit.access$0().length - 1),
        SI(1, TimeRangeToolkit.access$0().length - 2),
        JFR_OPTIONS(2, TimeRangeToolkit.access$0().length - 2);

        private final int uIdx;
        private final int maxValueIdx;

        private Format(int unitFormatIndex, int highestValueIndex) {
            this.uIdx = unitFormatIndex;
            this.maxValueIdx = highestValueIndex;
        }
    }
}

