/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.xml.internal;

import com.jrockit.mc.common.xml.ClassFactory;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.common.xml.internal.AbstractCodec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class UnmodifiableMapCodec
extends AbstractCodec {
    private static final Class<?> UNMODIFIABLE_CLASS = Collections.unmodifiableMap(Collections.EMPTY_MAP).getClass();
    private static final String ELEMENT_MAP_ENTRY = "mapEntry";
    private static final String ELEMENT_MAPENTRY_VALUE = "value";
    private static final String ELEMENT_MAPENTRY_KEY = "key";

    @Override
    public Map<?, ?> decode(Element element, ClassFactory factory) throws Exception {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int size = Integer.parseInt(element.getAttribute("size"));
        int i = 0;
        while (i < size) {
            String name = ELEMENT_MAP_ENTRY + Integer.toString(i);
            Element entryNode = XmlToolkit.getChildElementOrNull(element, name);
            this.decodeEntry(map, entryNode, factory);
            ++i;
        }
        return Collections.unmodifiableMap(map);
    }

    public void decodeEntry(Map<Object, Object> map, Element node, ClassFactory factory) {
        map.put(XmlToolkit.getNameTypeValue(node, ELEMENT_MAPENTRY_KEY, factory), XmlToolkit.getNameTypeValue(node, ELEMENT_MAPENTRY_VALUE, factory));
    }

    @Override
    public void encode(Object o, Element parentNode) {
        Map map = (Map)o;
        parentNode.setAttribute("size", Integer.toString(map.size()));
        int index = 0;
        for (Map.Entry entry : map.entrySet()) {
            String name = ELEMENT_MAP_ENTRY + Integer.toString(index++);
            Element entryNode = XmlToolkit.createElement(parentNode, name);
            this.encodeEntry(entry, entryNode);
        }
    }

    private void encodeEntry(Map.Entry<?, ?> entry, Element node) {
        XmlToolkit.setNameTypeValue(node, ELEMENT_MAPENTRY_KEY, entry.getKey());
        XmlToolkit.setNameTypeValue(node, ELEMENT_MAPENTRY_VALUE, entry.getValue());
    }

    @Override
    public Class<?> getType() {
        return UNMODIFIABLE_CLASS;
    }
}

