/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyberneko.html.HTMLElements;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Nokogiri::HTML::ElementDescription"})
public class HtmlElementDescription
extends RubyObject {
    protected static Map<Short, List<String>> subElements;
    protected HTMLElements.Element element;

    public HtmlElementDescription(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    protected static List<String> findSubElements(HTMLElements.Element element) {
        List<String> list = subElements.get(element.code);
        if (list == null) {
            list = new ArrayList<String>();
            for (short s = 0; s < 117; s = (short)(s + 1)) {
                HTMLElements.Element element2 = HTMLElements.getElement((short)s);
                if (!element2.isParent(element)) continue;
                list.add(element2.name);
            }
            subElements.put(element.code, list);
        }
        return list;
    }

    @JRubyMethod(name={"[]"}, meta=true)
    public static IRubyObject get(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        HTMLElements.Element element = HTMLElements.getElement((String)iRubyObject2.toString());
        if (element == HTMLElements.NO_SUCH_ELEMENT) {
            return threadContext.getRuntime().getNil();
        }
        HtmlElementDescription htmlElementDescription = new HtmlElementDescription(threadContext.getRuntime(), (RubyClass)iRubyObject);
        htmlElementDescription.element = element;
        return htmlElementDescription;
    }

    @JRubyMethod
    public IRubyObject name(ThreadContext threadContext) {
        return threadContext.getRuntime().newString(this.element.name.toLowerCase());
    }

    @JRubyMethod(name={"inline?"})
    public IRubyObject inline_eh(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.element.isInline());
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_eh(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.element.isEmpty());
    }

    @JRubyMethod
    public IRubyObject sub_elements(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        List<String> list = HtmlElementDescription.findSubElements(this.element);
        IRubyObject[] iRubyObjectArray = new IRubyObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            iRubyObjectArray[i] = ruby.newString(list.get(i));
        }
        return ruby.newArray(iRubyObjectArray);
    }

    static {
        HashMap hashMap = new HashMap();
        subElements = Collections.synchronizedMap(hashMap);
    }
}

