/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals.c14n;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import nokogiri.internals.c14n.CanonicalizationException;
import nokogiri.internals.c14n.ElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InclusiveNamespaces
extends ElementProxy {
    public static final String _TAG_EC_INCLUSIVENAMESPACES = "InclusiveNamespaces";
    public static final String _ATT_EC_PREFIXLIST = "PrefixList";
    public static final String ExclusiveCanonicalizationNamespace = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public InclusiveNamespaces(Document document, String string) {
        this(document, InclusiveNamespaces.prefixStr2Set(string));
    }

    public InclusiveNamespaces(Document document, Set<String> set) {
        super(document);
        TreeSet<String> treeSet = null;
        treeSet = set instanceof SortedSet ? (TreeSet<String>)set : new TreeSet<String>(set);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : treeSet) {
            if (string.equals("xmlns")) {
                stringBuilder.append("#default ");
                continue;
            }
            stringBuilder.append(string + " ");
        }
        this.constructionElement.setAttributeNS(null, _ATT_EC_PREFIXLIST, stringBuilder.toString().trim());
    }

    public InclusiveNamespaces(Element element, String string) throws CanonicalizationException {
        super(element, string);
    }

    public String getInclusiveNamespaces() {
        return this.constructionElement.getAttributeNS(null, _ATT_EC_PREFIXLIST);
    }

    public static SortedSet<String> prefixStr2Set(String string) {
        String[] stringArray;
        TreeSet<String> treeSet = new TreeSet<String>();
        if (string == null || string.length() == 0) {
            return treeSet;
        }
        for (String string2 : stringArray = string.split("\\s")) {
            if (string2.equals("#default")) {
                treeSet.add("xmlns");
                continue;
            }
            treeSet.add(string2);
        }
        return treeSet;
    }

    @Override
    public String getBaseNamespace() {
        return ExclusiveCanonicalizationNamespace;
    }

    @Override
    public String getBaseLocalName() {
        return _TAG_EC_INCLUSIVENAMESPACES;
    }
}

