/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application;

import com.jrockit.mc.rcp.application.ApplicationActionBarAdvisor;
import com.jrockit.mc.rcp.application.ApplicationPlugin;
import com.jrockit.mc.rcp.application.MissionControlEditorDropAdapter;
import com.jrockit.mc.rcp.logging.LoggingToolkit;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.traymanager.TrayManager;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.part.EditorInputTransfer;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final int DEFAULT_WIDTH = 1400;
    private static final int DEFAULT_HEIGHT = 850;
    private static final String SANE_SCREEN_POS_SYSPROP = "jmc.test.saneinitialscreenposition";

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        try {
            UIPlugin.getDefault().setTrayManager(new TrayManager(configurer.getWorkbenchConfigurer().getWorkbench()));
        }
        catch (UnsupportedOperationException e) {
            ApplicationPlugin.getLogger().log(Level.WARNING, "Could not set TrayManager.", e);
        }
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public boolean preWindowShellClose() {
        TrayManager manager = UIPlugin.getDefault().getTrayManager();
        if (manager != null) {
            if (manager.getMinimizeToTrayOnClose() && manager.minimizeToTray()) {
                return false;
            }
            manager.dispose();
        }
        return true;
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(false);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowPerspectiveBar(false);
        configurer.addEditorAreaTransfer((Transfer)LocalSelectionTransfer.getTransfer());
        configurer.addEditorAreaTransfer((Transfer)EditorInputTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
        configurer.configureEditorAreaDropListener((DropTargetListener)new MissionControlEditorDropAdapter(configurer.getWindow()));
        configurer.setInitialSize(new Point(1400, 850));
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        try {
            if ("true".equalsIgnoreCase(System.getProperty(SANE_SCREEN_POS_SYSPROP))) {
                IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
                Display display = configurer.getWindow().getWorkbench().getDisplay();
                Monitor[] monitors = display.getMonitors();
                Shell jmcShell = configurer.getWindow().getShell();
                Rectangle jmcBounds = jmcShell.getBounds();
                boolean withinSingleMonitorBounds = false;
                Monitor[] monitorArray = monitors;
                int n = monitors.length;
                int n2 = 0;
                while (n2 < n) {
                    Monitor monitor = monitorArray[n2];
                    if (monitor.getClientArea().intersection(jmcBounds).equals((Object)jmcBounds)) {
                        withinSingleMonitorBounds = true;
                        break;
                    }
                    ++n2;
                }
                if (!withinSingleMonitorBounds) {
                    Rectangle primaryDisplayClientArea = display.getPrimaryMonitor().getClientArea();
                    if (primaryDisplayClientArea.width <= 1400 || primaryDisplayClientArea.height <= 850) {
                        jmcShell.setBounds(0, 0, primaryDisplayClientArea.width, primaryDisplayClientArea.height);
                    } else {
                        int x = (primaryDisplayClientArea.width - 1400) / 2;
                        int y = (primaryDisplayClientArea.height - 850) / 2;
                        jmcShell.setBounds(x, y, 1400, 850);
                    }
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void postWindowOpen() {
        this.removeUnwantedPreferencesPages();
    }

    private void removeUnwantedPreferencesPages() {
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode root = this.getRoot(pm);
        this.removePrefsPage(root, "org.eclipse.equinox.security.ui.category");
    }

    private IPreferenceNode getRoot(PreferenceManager pm) {
        try {
            Method m = PreferenceManager.class.getDeclaredMethod("getRoot", null);
            m.setAccessible(true);
            return (IPreferenceNode)m.invoke((Object)pm, new Object[0]);
        }
        catch (Exception e) {
            LoggingToolkit.getLogger().log(Level.WARNING, "Could not get the root node for the preferences, and will not be able to prune unwanted prefs pages.", e);
            return null;
        }
    }

    private void removePrefsPage(IPreferenceNode root, String id) {
        IPreferenceNode[] iPreferenceNodeArray = root.getSubNodes();
        int n = iPreferenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode node = iPreferenceNodeArray[n2];
            this.logPrefsNode(node);
            if (node.getId().equals(id)) {
                root.remove(node);
                LoggingToolkit.getLogger().log(Level.INFO, String.format("Removed preference page %s (ID:%s)", node.getLabelText(), node.getId()));
            } else {
                this.removePrefsPage(node, id);
            }
            ++n2;
        }
    }

    private void logPrefsNode(IPreferenceNode node) {
        LoggingToolkit.getLogger().log(Level.FINE, String.format("Prefs node: %s %s", node.getLabelText(), node.getId()));
    }
}

