/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application.actions;

import com.jrockit.mc.rcp.application.ApplicationPlugin;
import com.jrockit.mc.rcp.application.actions.Messages;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.WorkbenchToolkit;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String KLEENE_STAR_DOT = "*.";
    private static final String FILE_OPEN_FILTER_PATH = "file.open.filter.path";
    private static final String DEMO_DIRECTORY = "flightrecordings";
    private static final String JDK_RELATIVE_DEMO_DIRECTORY = "sample/missioncontrol/flightrecordings";
    private IWorkbenchWindow m_window;
    private String m_filterPath;

    public OpenFileAction() {
        super(Messages.OpenFileAction_OPEN_FILE_TITLE_TEXT);
        this.setEnabled(true);
    }

    public void dispose() {
        this.m_window = null;
        this.m_filterPath = null;
    }

    public void init(IWorkbenchWindow window) {
        this.m_window = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public String getDefaultFilterPath() {
        String result = OpenFileAction.getLastFilterPath();
        if (result == null && (result = OpenFileAction.getSamplePath()) == null && (result = OpenFileAction.getUserHomePath()) == null) {
            result = "./";
        }
        return result;
    }

    private static String getLastFilterPath() {
        return OpenFileAction.getIfExists(ApplicationPlugin.getDefault().getDialogSettings().get(FILE_OPEN_FILTER_PATH));
    }

    private static String getUserHomePath() {
        return OpenFileAction.getIfExists(System.getProperty("user.home"));
    }

    public static String getSamplePath() {
        String javaHome = OpenFileAction.getIfExists(System.getProperty("java.home"));
        String result = null;
        if (javaHome != null && (result = OpenFileAction.getJoinedIfExists(javaHome, JDK_RELATIVE_DEMO_DIRECTORY)) == null) {
            result = OpenFileAction.getJoinedIfExists(new File(javaHome).getParent(), JDK_RELATIVE_DEMO_DIRECTORY);
        }
        if (result == null) {
            result = OpenFileAction.getJoinedIfExists(".", DEMO_DIRECTORY);
        }
        if (result == null) {
            result = OpenFileAction.getJoinedIfExists(OpenFileAction.getEclipseLaunchedSamplesFolder(), DEMO_DIRECTORY);
        }
        return result;
    }

    private static String getEclipseLaunchedSamplesFolder() {
        String app = Platform.getBundle((String)"com.jrockit.mc.rcp.application").getLocation();
        app = app.substring("reference:file:/".length());
        File base = new File(app).getParentFile();
        return OpenFileAction.getJoinedIfExists(base.getAbsolutePath(), "com.jrockit.mc.rcp.product/rootfiles/");
    }

    private static String getIfExists(String path) {
        if (OpenFileAction.exists(path)) {
            return path;
        }
        return null;
    }

    private static boolean exists(String path) {
        if (path != null) {
            return new File(path).exists();
        }
        return false;
    }

    private static String getJoinedIfExists(String base, String child) {
        if (base != null && child != null) {
            return OpenFileAction.getIfExists(new File(base, child).getPath());
        }
        return null;
    }

    public void setDefaultFilterPath(String path) {
        IDialogSettings settings = ApplicationPlugin.getDefault().getDialogSettings();
        settings.put(FILE_OPEN_FILTER_PATH, path);
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.m_window.getShell(), 4098);
        dialog.setFilterPath(this.m_filterPath);
        this.setFilterNamesAndExtensions(dialog);
        dialog.setText(Messages.OpenFileAction_OPEN_FILE_TITLE);
        if (dialog.open() == null) {
            return;
        }
        String[] names = dialog.getFileNames();
        if (names != null) {
            this.setDefaultFilterPath(dialog.getFilterPath());
            this.m_filterPath = dialog.getFilterPath();
            int numberOfFilesNotFound = 0;
            StringBuffer notFound = new StringBuffer();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File file = new File(String.valueOf(this.m_filterPath) + File.separator + name);
                if (file.exists()) {
                    WorkbenchToolkit.openEditor((IWorkbenchWindow)this.m_window, (IPathEditorInput)new MCPathEditorInput(file));
                } else {
                    if (++numberOfFilesNotFound > 1) {
                        notFound.append('\n');
                    }
                    notFound.append(file.getName());
                }
                ++n2;
            }
            if (numberOfFilesNotFound > 0) {
                String msgFmt = numberOfFilesNotFound == 1 ? Messages.OpenFileAction_CANT_FIND_SINGLE_FILE_TEXT : Messages.OpenFileAction_CANT_FIND_MULTIPLE_FILES_TEXT;
                String msg = NLS.bind((String)msgFmt, (Object[])new Object[]{notFound.toString()});
                MessageDialog.openError((Shell)this.m_window.getShell(), (String)Messages.OpenFileAction_ERROR_WHEN_OPENING_FILE_TEXT_TITLE, (String)msg);
            }
        }
    }

    public IWorkbenchWindow getWindow() {
        return this.m_window;
    }

    private void setFilterNamesAndExtensions(FileDialog dialog) {
        IFileEditorMapping[] fileExtensions = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        String[] filterExtensions = new String[fileExtensions.length + 1];
        int i = 0;
        while (i < fileExtensions.length) {
            filterExtensions[i] = KLEENE_STAR_DOT + fileExtensions[i].getExtension();
            ++i;
        }
        filterExtensions[fileExtensions.length] = "*";
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterIndex(fileExtensions.length);
    }

    public void run(IAction action) {
        this.run();
    }
}

