/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.org.jsoup.select;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.maven.wagon.providers.http.org.jsoup.helper.Validate;
import org.apache.maven.wagon.providers.http.org.jsoup.nodes.Element;
import org.apache.maven.wagon.providers.http.org.jsoup.select.Collector;
import org.apache.maven.wagon.providers.http.org.jsoup.select.Elements;
import org.apache.maven.wagon.providers.http.org.jsoup.select.Evaluator;
import org.apache.maven.wagon.providers.http.org.jsoup.select.QueryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector {
    private final Evaluator evaluator;
    private final Element root;

    private Selector(String query, Element root) {
        Validate.notNull(query);
        query = query.trim();
        Validate.notEmpty(query);
        Validate.notNull(root);
        this.evaluator = QueryParser.parse(query);
        this.root = root;
    }

    public static Elements select(String query, Element root) {
        return new Selector(query, root).select();
    }

    public static Elements select(String query, Iterable<Element> roots) {
        Validate.notEmpty(query);
        Validate.notNull(roots);
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        for (Element root : roots) {
            elements.addAll(Selector.select(query, root));
        }
        return new Elements(elements);
    }

    private Elements select() {
        return Collector.collect(this.evaluator, this.root);
    }

    static Elements filterOut(Collection<Element> elements, Collection<Element> outs) {
        Elements output = new Elements();
        for (Element el : elements) {
            boolean found = false;
            for (Element out : outs) {
                if (!el.equals(out)) continue;
                found = true;
                break;
            }
            if (found) continue;
            output.add(el);
        }
        return output;
    }

    public static class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(String msg, Object ... params) {
            super(String.format(msg, params));
        }
    }
}

