/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.gtk.OS;

public final class Converter {
    public static final byte[] NullByteArray = new byte[1];
    public static final byte[] EmptyByteArray = new byte[0];
    public static final char[] EmptyCharArray = new char[0];

    public static String defaultCodePage() {
        return "UTF8";
    }

    public static char[] mbcsToWcs(String codePage, byte[] buffer) {
        long[] items_written = new long[1];
        long ptr = OS.g_utf8_to_utf16(buffer, (long)buffer.length, null, items_written, null);
        if (ptr == 0L) {
            return EmptyCharArray;
        }
        int length = (int)items_written[0];
        char[] chars = new char[length];
        OS.memmove(chars, ptr, (long)(length * 2));
        OS.g_free(ptr);
        return chars;
    }

    public static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        int length = string.length();
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        return Converter.wcsToMbcs(codePage, buffer, terminate);
    }

    public static byte[] wcsToMbcs(String codePage, char[] buffer, boolean terminate) {
        long[] items_read = new long[1];
        long[] items_written = new long[1];
        long ptr = OS.g_utf16_to_utf8(buffer, buffer.length, items_read, items_written, null);
        if (ptr == 0L) {
            return terminate ? NullByteArray : EmptyByteArray;
        }
        int written = (int)items_written[0];
        byte[] bytes = new byte[written + (terminate ? 1 : 0)];
        OS.memmove(bytes, ptr, (long)written);
        OS.g_free(ptr);
        return bytes;
    }
}

