/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class GroupDrawData
extends DrawData {
    public int headerWidth;
    public int headerHeight;
    public Rectangle headerArea;
    static final int GROUP_X = 2;
    static final int GROUP_PAD = 1;
    static final int GROUP_HEADER_X = 9;
    static final int GROUP_HEADER_PAD = 2;

    public GroupDrawData() {
        this.state = new int[1];
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        long frameHandle = theme.frameHandle;
        long gtkStyle = OS.gtk_widget_get_style(frameHandle);
        long drawable = gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        int xthickness = OS.gtk_style_get_xthickness(gtkStyle);
        int ythickness = OS.gtk_style_get_ythickness(gtkStyle);
        int x = bounds.x;
        int y = bounds.y + this.headerHeight / 2;
        int width = bounds.width;
        int height = bounds.height - this.headerHeight / 2;
        byte[] detail = Converter.wcsToMbcs(null, "frame", true);
        int gap_x = xthickness + 2;
        int gap_width = this.headerWidth + 2;
        int gap_side = 2;
        int state_type = this.getStateType(0);
        this.gtk_render_shadow_gap(gtkStyle, drawable, state_type, 3, null, frameHandle, detail, x, y, width, height, gap_side, gap_x, gap_width);
        if (this.headerArea != null) {
            this.headerArea.x = bounds.x + gap_x + 1;
            this.headerArea.y = bounds.y;
            this.headerArea.width = this.headerWidth;
            this.headerArea.height = this.headerHeight;
        }
        if (this.clientArea != null) {
            this.clientArea.x = bounds.x + xthickness;
            this.clientArea.y = bounds.y + ythickness + this.headerHeight;
            this.clientArea.width = bounds.width - 2 * xthickness;
            this.clientArea.height = bounds.height - 2 * ythickness - this.headerHeight;
        }
    }

    int getStateType(int part) {
        int state = this.state[part];
        int state_type = 0;
        if ((state & 0x20) != 0) {
            state_type = 4;
        }
        return state_type;
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return bounds.contains(position) ? 0 : -1;
    }

    void gtk_render_shadow_gap(long style, long window, int state_type, int shadow_type, GdkRectangle area, long widget, byte[] detail, int x, int y, int width, int height, int gap_side, int gap_x, int gap_width) {
        if (OS.GTK3) {
            long cairo = OS.gdk_cairo_create(window);
            long context = OS.gtk_widget_get_style_context(style);
            OS.gtk_style_context_save(context);
            OS.gtk_style_context_set_state(context, state_type);
            OS.gtk_render_frame_gap(context, cairo, context, y, gap_width, height, gap_side, gap_x, gap_x + gap_width);
            Cairo.cairo_destroy(cairo);
        } else {
            OS.gtk_paint_shadow_gap(style, window, state_type, shadow_type, area, widget, detail, x, y, width, height, gap_side, gap_x, gap_width);
        }
    }
}

