/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    long adjustmentHandle;
    int detail;
    boolean dragSent;

    ScrollBar() {
    }

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    void deregister() {
        super.deregister();
        if (this.adjustmentHandle != 0L) {
            this.display.removeWidget(this.adjustmentHandle);
        }
    }

    void destroyHandle() {
        super.destroyWidget();
    }

    void destroyWidget() {
        this.parent.destroyScrollBar(this);
        this.releaseHandle();
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (this.handle != 0L) {
            return this.gtk_widget_get_sensitive(this.handle);
        }
        return true;
    }

    public int getIncrement() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_step_increment(this.adjustmentHandle);
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_upper(this.adjustmentHandle);
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_lower(this.adjustmentHandle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_page_increment(this.adjustmentHandle);
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_value(this.adjustmentHandle);
    }

    public Point getSize() {
        this.checkWidget();
        if (this.handle == 0L) {
            return new Point(0, 0);
        }
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.handle, requisition);
        return new Point(requisition.width, requisition.height);
    }

    public int getThumb() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_page_size(this.adjustmentHandle);
    }

    public Rectangle getThumbBounds() {
        int height;
        int width;
        int y;
        int x;
        this.checkWidget();
        int[] slider_start = new int[1];
        int[] slider_end = new int[1];
        this.gtk_range_get_slider_range(this.handle, slider_start, slider_end);
        GtkAllocation allocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.handle, allocation);
        if ((this.style & 0x200) != 0) {
            x = allocation.x;
            y = slider_start[0];
            width = allocation.width;
            height = slider_end[0] - slider_start[0];
        } else {
            x = slider_start[0];
            y = allocation.y;
            width = slider_end[0] - slider_start[0];
            height = allocation.height;
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        long window = this.gtk_widget_get_window(this.parent.scrolledHandle);
        if (window != 0L) {
            OS.gdk_window_get_origin(window, origin_x, origin_y);
        }
        rect.x += origin_x[0];
        rect.y += origin_y[0];
        window = this.gtk_widget_get_window(this.parent.handle);
        if (window != 0L) {
            OS.gdk_window_get_origin(window, origin_x, origin_y);
        }
        rect.x -= origin_x[0];
        rect.y -= origin_y[0];
        return rect;
    }

    public Rectangle getThumbTrackBounds() {
        int[] slider_end;
        int[] slider_start;
        int height;
        int width;
        int stepperSize;
        this.checkWidget();
        int x = 0;
        int y = 0;
        int[] has_stepper = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.has_backward_stepper, has_stepper, 0L);
        boolean hasB = has_stepper[0] != 0;
        OS.gtk_widget_style_get(this.handle, OS.has_secondary_backward_stepper, has_stepper, 0L);
        boolean hasB2 = has_stepper[0] != 0;
        OS.gtk_widget_style_get(this.handle, OS.has_forward_stepper, has_stepper, 0L);
        boolean hasF = has_stepper[0] != 0;
        OS.gtk_widget_style_get(this.handle, OS.has_secondary_forward_stepper, has_stepper, 0L);
        boolean hasF2 = has_stepper[0] != 0;
        GtkAllocation allocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.handle, allocation);
        if ((this.style & 0x200) != 0) {
            stepperSize = allocation.width;
            x = allocation.x;
            if (hasB) {
                y += stepperSize;
            }
            if (hasF2) {
                y += stepperSize;
            }
            width = allocation.width;
            height = allocation.height - y;
            if (hasB2) {
                height -= stepperSize;
            }
            if (hasF) {
                height -= stepperSize;
            }
            if (height < 0) {
                slider_start = new int[1];
                slider_end = new int[1];
                this.gtk_range_get_slider_range(this.handle, slider_start, slider_end);
                y = slider_start[0];
                height = 0;
            }
        } else {
            stepperSize = allocation.height;
            if (hasB) {
                x += stepperSize;
            }
            if (hasF2) {
                x += stepperSize;
            }
            y = allocation.y;
            width = allocation.width - x;
            if (hasB2) {
                width -= stepperSize;
            }
            if (hasF) {
                width -= stepperSize;
            }
            height = allocation.height;
            if (width < 0) {
                slider_start = new int[1];
                slider_end = new int[1];
                this.gtk_range_get_slider_range(this.handle, slider_start, slider_end);
                x = slider_start[0];
                width = 0;
            }
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        long window = this.gtk_widget_get_window(this.parent.scrolledHandle);
        if (window != 0L) {
            OS.gdk_window_get_origin(window, origin_x, origin_y);
        }
        rect.x += origin_x[0];
        rect.y += origin_y[0];
        window = this.gtk_widget_get_window(this.parent.handle);
        if (window != 0L) {
            OS.gdk_window_get_origin(window, origin_x, origin_y);
        }
        rect.x -= origin_x[0];
        rect.y -= origin_y[0];
        return rect;
    }

    public boolean getVisible() {
        this.checkWidget();
        long scrolledHandle = this.parent.scrolledHandle;
        int[] hsp = new int[1];
        int[] vsp = new int[1];
        OS.gtk_scrolled_window_get_policy(scrolledHandle, hsp, vsp);
        if ((this.style & 0x100) != 0) {
            return hsp[0] != 2 && this.gtk_widget_get_visible(this.handle);
        }
        return vsp[0] != 2 && this.gtk_widget_get_visible(this.handle);
    }

    long gtk_button_press_event(long widget, long eventPtr) {
        long result = super.gtk_button_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        this.detail = 0;
        this.dragSent = false;
        return result;
    }

    long gtk_change_value(long widget, long scroll, long value1, long value2) {
        this.detail = (int)scroll;
        return 0L;
    }

    void gtk_range_get_slider_range(long widget, int[] slider_start, int[] slider_end) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 20, 0)) {
            OS.gtk_range_get_slider_range(widget, slider_start, slider_end);
        } else {
            slider_start[0] = OS.GTK_RANGE_SLIDER_START(widget);
            slider_end[0] = OS.GTK_RANGE_SLIDER_END(widget);
        }
    }

    long gtk_value_changed(long adjustment) {
        Event event = new Event();
        this.dragSent = this.detail == 1;
        switch (this.detail) {
            case 0: {
                event.detail = 0;
                break;
            }
            case 1: {
                event.detail = 1;
                break;
            }
            case 14: {
                event.detail = 0x1000007;
                break;
            }
            case 15: {
                event.detail = 0x1000008;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                event.detail = 0x1000006;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                event.detail = 0x1000005;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                event.detail = 0x1000002;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                event.detail = 0x1000001;
            }
        }
        if (!this.dragSent) {
            this.detail = 0;
        }
        this.sendSelectionEvent(13, event, false);
        this.parent.updateScrollBarValue(this);
        return 0L;
    }

    long gtk_event_after(long widget, long gdkEvent) {
        GdkEvent gtkEvent = new GdkEvent();
        OS.memmove(gtkEvent, gdkEvent, (long)GdkEvent.sizeof);
        switch (gtkEvent.type) {
            case 7: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, gdkEvent, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button == 1 && this.detail == 1) {
                    if (!this.dragSent) {
                        Event event = new Event();
                        event.detail = 1;
                        this.sendSelectionEvent(13, event, false);
                    }
                    this.sendSelectionEvent(13);
                }
                this.detail = 0;
                this.dragSent = false;
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.change_value, this.display.getClosure(7), false);
        OS.g_signal_connect_closure(this.adjustmentHandle, OS.value_changed, this.display.getClosure(57), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.getParent().getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.getParent().isVisible();
    }

    void register() {
        super.register();
        if (this.adjustmentHandle != 0L) {
            this.display.addWidget(this.adjustmentHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (this.handle != 0L) {
            OS.gtk_widget_set_sensitive(this.handle, enabled);
        }
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            OS.gtk_adjustment_set_step_increment(this.adjustmentHandle, value);
        } else {
            GtkAdjustment adjustment = new GtkAdjustment();
            OS.memmove(adjustment, this.adjustmentHandle);
            adjustment.step_increment = value;
            OS.memmove(this.adjustmentHandle, adjustment);
            OS.gtk_adjustment_changed(this.adjustmentHandle);
        }
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        this.gtk_adjustment_get(this.adjustmentHandle, adjustment);
        int minimum = (int)adjustment.lower;
        if (value <= minimum) {
            return;
        }
        adjustment.upper = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, value - minimum);
        adjustment.value = Math.min((int)adjustment.value, (int)((double)value - adjustment.page_size));
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        this.gtk_adjustment_configure(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        this.gtk_adjustment_get(this.adjustmentHandle, adjustment);
        int maximum = (int)adjustment.upper;
        if (value >= maximum) {
            return;
        }
        adjustment.lower = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, maximum - value);
        adjustment.value = Math.max((int)adjustment.value, value);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        this.gtk_adjustment_configure(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    void setOrientation(boolean create) {
        super.setOrientation(create);
        if (!((this.parent.style & 0x8000000) == 0 && create || (this.parent.state & 2) == 0 || (this.style & 0x100) == 0)) {
            OS.gtk_range_set_inverted(this.handle, (this.parent.style & 0x4000000) != 0);
        }
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            OS.gtk_adjustment_set_page_increment(this.adjustmentHandle, value);
        } else {
            GtkAdjustment adjustment = new GtkAdjustment();
            OS.memmove(adjustment, this.adjustmentHandle);
            adjustment.page_increment = value;
            OS.memmove(this.adjustmentHandle, adjustment);
            OS.gtk_adjustment_changed(this.adjustmentHandle);
        }
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int selection) {
        this.checkWidget();
        selection = Math.min(selection, this.getMaximum() - this.getThumb());
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_set_value(this.adjustmentHandle, selection);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        this.gtk_adjustment_get(this.adjustmentHandle, adjustment);
        value = Math.min(value, (int)(adjustment.upper - adjustment.lower));
        adjustment.page_size = value;
        adjustment.value = Math.min((int)adjustment.value, (int)(adjustment.upper - (double)value));
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        this.gtk_adjustment_configure(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        GtkAdjustment adjustment = new GtkAdjustment();
        adjustment.lower = minimum;
        adjustment.upper = maximum;
        adjustment.step_increment = increment;
        adjustment.page_increment = pageIncrement;
        adjustment.page_size = thumb;
        adjustment.value = Math.min(Math.max(selection, minimum), maximum - thumb);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        this.gtk_adjustment_configure(this.adjustmentHandle, adjustment);
        OS.gtk_adjustment_value_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.parent.setScrollBarVisible(this, visible)) {
            this.sendEvent(visible ? 22 : 23);
            this.parent.sendEvent(11);
        }
    }
}

