/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.puma;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.puma.Http11Parser;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Http11
extends RubyObject {
    public static final int MAX_FIELD_NAME_LENGTH = 256;
    public static final String MAX_FIELD_NAME_LENGTH_ERR = "HTTP element FIELD_NAME is longer than the 256 allowed length.";
    public static final int MAX_FIELD_VALUE_LENGTH = 81920;
    public static final String MAX_FIELD_VALUE_LENGTH_ERR = "HTTP element FIELD_VALUE is longer than the 81920 allowed length.";
    public static final int MAX_REQUEST_URI_LENGTH = 12288;
    public static final String MAX_REQUEST_URI_LENGTH_ERR = "HTTP element REQUEST_URI is longer than the 12288 allowed length.";
    public static final int MAX_FRAGMENT_LENGTH = 1024;
    public static final String MAX_FRAGMENT_LENGTH_ERR = "HTTP element REQUEST_PATH is longer than the 1024 allowed length.";
    public static final int MAX_REQUEST_PATH_LENGTH = 2048;
    public static final String MAX_REQUEST_PATH_LENGTH_ERR = "HTTP element REQUEST_PATH is longer than the 2048 allowed length.";
    public static final int MAX_QUERY_STRING_LENGTH = 10240;
    public static final String MAX_QUERY_STRING_LENGTH_ERR = "HTTP element QUERY_STRING is longer than the 10240 allowed length.";
    public static final int MAX_HEADER_LENGTH = 114688;
    public static final String MAX_HEADER_LENGTH_ERR = "HTTP element HEADER is longer than the 114688 allowed length.";
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Http11(ruby, rubyClass);
        }
    };
    private Ruby runtime;
    private RubyClass eHttpParserError;
    private Http11Parser hp;
    private RubyString body;
    private Http11Parser.FieldCB http_field = new Http11Parser.FieldCB(){

        public void call(Object object, int n, int n2, int n3, int n4) {
            RubyString rubyString;
            RubyHash rubyHash = (RubyHash)object;
            Http11.this.validateMaxLength(n2, 256, Http11.MAX_FIELD_NAME_LENGTH_ERR);
            Http11.this.validateMaxLength(n4, 81920, Http11.MAX_FIELD_VALUE_LENGTH_ERR);
            ByteList byteList = new ByteList(((Http11)Http11.this).hp.parser.buffer, n, n2);
            int n5 = byteList.length();
            for (int i = 0; i < n5; ++i) {
                if ((byteList.get(i) & 0xFF) == 45) {
                    byteList.set(i, 95);
                    continue;
                }
                byteList.set(i, (int)((byte)Character.toUpperCase((char)byteList.get(i))));
            }
            String string = byteList.toString();
            if (string.equals("CONTENT_LENGTH") || string.equals("CONTENT_TYPE")) {
                rubyString = RubyString.newString((Ruby)Http11.this.runtime, (ByteList)byteList);
            } else {
                rubyString = RubyString.newString((Ruby)Http11.this.runtime, (String)"HTTP_");
                rubyString.cat(byteList);
            }
            byteList = new ByteList(((Http11)Http11.this).hp.parser.buffer, n3, n4);
            IRubyObject iRubyObject = rubyHash.op_aref(rubyHash.getRuntime().getCurrentContext(), (IRubyObject)rubyString);
            if (iRubyObject.isNil()) {
                rubyHash.op_aset(rubyHash.getRuntime().getCurrentContext(), (IRubyObject)rubyString, (IRubyObject)RubyString.newString((Ruby)Http11.this.runtime, (ByteList)byteList));
            } else {
                RubyString rubyString2 = iRubyObject.convertToString();
                rubyString2.cat(RubyString.newString((Ruby)Http11.this.runtime, (String)", "));
                rubyString2.cat(byteList);
            }
        }
    };
    private Http11Parser.ElementCB request_method = new Http11Parser.ElementCB(){

        public void call(Object object, int n, int n2) {
            RubyHash rubyHash = (RubyHash)object;
            RubyString rubyString = RubyString.newString((Ruby)Http11.this.runtime, (ByteList)new ByteList(((Http11)Http11.this).hp.parser.buffer, n, n2));
            rubyHash.op_aset(rubyHash.getRuntime().getCurrentContext(), (IRubyObject)Http11.this.runtime.newString("REQUEST_METHOD"), (IRubyObject)rubyString);
        }
    };
    private Http11Parser.ElementCB request_uri = new Http11Parser.ElementCB(){

        public void call(Object object, int n, int n2) {
            RubyHash rubyHash = (RubyHash)object;
            Http11.this.validateMaxLength(n2, 12288, Http11.MAX_REQUEST_URI_LENGTH_ERR);
            RubyString rubyString = RubyString.newString((Ruby)Http11.this.runtime, (ByteList)new ByteList(((Http11)Http11.this).hp.parser.buffer, n, n2));
            rubyHash.op_aset(rubyHash.getRuntime().getCurrentContext(), (IRubyObject)Http11.this.runtime.newString("REQUEST_URI"), (IRubyObject)rubyString);
        }
    };
    private Http11Parser.ElementCB fragment = new Http11Parser.ElementCB(){

        public void call(Object object, int n, int n2) {
            RubyHash rubyHash = (RubyHash)object;
            Http11.this.validateMaxLength(n2, 1024, Http11.MAX_FRAGMENT_LENGTH_ERR);
            RubyString rubyString = RubyString.newString((Ruby)Http11.this.runtime, (ByteList)new ByteList(((Http11)Http11.this).hp.parser.buffer, n, n2));
            rubyHash.op_aset(rubyHash.getRuntime().getCurrentContext(), (IRubyObject)Http11.this.runtime.newString("FRAGMENT"), (IRubyObject)rubyString);
        }
    };
    private Http11Parser.ElementCB request_path = new Http11Parser.ElementCB(){

        public void call(Object object, int n, int n2) {
            RubyHash rubyHash = (RubyHash)object;
            Http11.this.validateMaxLength(n2, 2048, Http11.MAX_REQUEST_PATH_LENGTH_ERR);
            RubyString rubyString = RubyString.newString((Ruby)Http11.this.runtime, (ByteList)new ByteList(((Http11)Http11.this).hp.parser.buffer, n, n2));
            rubyHash.op_aset(rubyHash.getRuntime().getCurrentContext(), (IRubyObject)Http11.this.runtime.newString("REQUEST_PATH"), (IRubyObject)rubyString);
        }
    };
    private Http11Parser.ElementCB query_string = new Http11Parser.ElementCB(){

        public void call(Object object, int n, int n2) {
            RubyHash rubyHash = (RubyHash)object;
            Http11.this.validateMaxLength(n2, 10240, Http11.MAX_QUERY_STRING_LENGTH_ERR);
            RubyString rubyString = RubyString.newString((Ruby)Http11.this.runtime, (ByteList)new ByteList(((Http11)Http11.this).hp.parser.buffer, n, n2));
            rubyHash.op_aset(rubyHash.getRuntime().getCurrentContext(), (IRubyObject)Http11.this.runtime.newString("QUERY_STRING"), (IRubyObject)rubyString);
        }
    };
    private Http11Parser.ElementCB http_version = new Http11Parser.ElementCB(){

        public void call(Object object, int n, int n2) {
            RubyHash rubyHash = (RubyHash)object;
            RubyString rubyString = RubyString.newString((Ruby)Http11.this.runtime, (ByteList)new ByteList(((Http11)Http11.this).hp.parser.buffer, n, n2));
            rubyHash.op_aset(rubyHash.getRuntime().getCurrentContext(), (IRubyObject)Http11.this.runtime.newString("HTTP_VERSION"), (IRubyObject)rubyString);
        }
    };
    private Http11Parser.ElementCB header_done = new Http11Parser.ElementCB(){

        public void call(Object object, int n, int n2) {
            Http11.this.body = RubyString.newString((Ruby)Http11.this.runtime, (ByteList)new ByteList(((Http11)Http11.this).hp.parser.buffer, n, n2));
        }
    };

    public static void createHttp11(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Puma");
        rubyModule.defineClassUnder("HttpParserError", ruby.getClass("IOError"), ruby.getClass("IOError").getAllocator());
        RubyClass rubyClass = rubyModule.defineClassUnder("HttpParser", ruby.getObject(), ALLOCATOR);
        rubyClass.defineAnnotatedMethods(Http11.class);
    }

    public Http11(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.runtime = ruby;
        this.eHttpParserError = (RubyClass)ruby.getModule("Puma").getConstant("HttpParserError");
        this.hp = new Http11Parser();
        this.hp.parser.http_field = this.http_field;
        this.hp.parser.request_method = this.request_method;
        this.hp.parser.request_uri = this.request_uri;
        this.hp.parser.fragment = this.fragment;
        this.hp.parser.request_path = this.request_path;
        this.hp.parser.query_string = this.query_string;
        this.hp.parser.http_version = this.http_version;
        this.hp.parser.header_done = this.header_done;
        this.hp.parser.init();
    }

    public void validateMaxLength(int n, int n2, String string) {
        if (n > n2) {
            throw new RaiseException(this.runtime, this.eHttpParserError, string, true);
        }
    }

    @JRubyMethod
    public IRubyObject initialize() {
        this.hp.parser.init();
        return this;
    }

    @JRubyMethod
    public IRubyObject reset() {
        this.hp.parser.init();
        return this.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject finish() {
        this.hp.finish();
        return this.hp.is_finished() ? this.runtime.getTrue() : this.runtime.getFalse();
    }

    @JRubyMethod
    public IRubyObject execute(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        ByteList byteList;
        int n = 0;
        n = RubyNumeric.fix2int((IRubyObject)iRubyObject3);
        if (n >= (byteList = ((RubyString)iRubyObject2).getByteList()).length()) {
            throw new RaiseException(this.runtime, this.eHttpParserError, "Requested start is after data buffer end.", true);
        }
        this.hp.parser.data = iRubyObject;
        this.hp.execute(byteList, n);
        this.validateMaxLength(this.hp.parser.nread, 114688, MAX_HEADER_LENGTH_ERR);
        if (this.hp.has_error()) {
            throw new RaiseException(this.runtime, this.eHttpParserError, "Invalid HTTP format, parsing fails.", true);
        }
        return this.runtime.newFixnum(this.hp.parser.nread);
    }

    @JRubyMethod(name={"error?"})
    public IRubyObject has_error() {
        return this.hp.has_error() ? this.runtime.getTrue() : this.runtime.getFalse();
    }

    @JRubyMethod(name={"finished?"})
    public IRubyObject is_finished() {
        return this.hp.is_finished() ? this.runtime.getTrue() : this.runtime.getFalse();
    }

    @JRubyMethod
    public IRubyObject nread() {
        return this.runtime.newFixnum(this.hp.parser.nread);
    }

    @JRubyMethod
    public IRubyObject body() {
        return this.body;
    }
}

