/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.util.Formatter;
import oracle.jrockit.jfr.MsgLevel;

@Deprecated
final class Logger {
    private static final ThreadLocal<Formatter> formatterLocal = new ThreadLocal<Formatter>(){

        @Override
        protected Formatter initialValue() {
            return new Formatter();
        }
    };
    private final String name;

    private Logger(String string) {
        this.name = string;
    }

    static Logger loggerFor(String string) {
        return new Logger(string);
    }

    static native void output0(int var0, String var1);

    boolean isLevel(MsgLevel msgLevel) {
        return true;
    }

    void output(MsgLevel msgLevel, String string) {
        Logger.output0(msgLevel.level(), string);
    }

    private void output(MsgLevel msgLevel, Throwable throwable) {
        String string = throwable.getClass().getName() + ":" + throwable.getMessage();
        this.output(msgLevel, string);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        this.output(msgLevel, stackTraceElementArray);
        if (throwable.getCause() != null) {
            this.output(msgLevel, "Caused by: ", throwable.getCause());
        }
    }

    private void output(MsgLevel msgLevel, StackTraceElement[] stackTraceElementArray) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            this.output(msgLevel, "   " + stackTraceElement.toString());
        }
    }

    void output(MsgLevel msgLevel, String string, Throwable throwable) {
        this.output(msgLevel, string);
        this.output(msgLevel, throwable);
    }

    void output(MsgLevel msgLevel, String string, StackTraceElement[] stackTraceElementArray) {
        this.output(msgLevel, string);
        this.output(msgLevel, stackTraceElementArray);
    }

    void output(MsgLevel msgLevel, String string, Object[] objectArray) {
        Formatter formatter = formatterLocal.get();
        formatter.format(string, objectArray);
        formatter.flush();
        this.output(msgLevel, formatter.toString());
        ((StringBuilder)formatter.out()).setLength(0);
    }

    void output(MsgLevel msgLevel, Throwable throwable, String string, Object[] objectArray) {
        this.output(msgLevel, string, objectArray);
        this.output(msgLevel, throwable);
    }

    void output(MsgLevel msgLevel, StackTraceElement[] stackTraceElementArray, String string, Object[] objectArray) {
        this.output(msgLevel, string, objectArray);
        this.output(msgLevel, stackTraceElementArray);
    }

    boolean isDebug() {
        return this.isLevel(MsgLevel.DEBUG);
    }

    boolean isInfo() {
        return this.isLevel(MsgLevel.INFO);
    }

    boolean isWarn() {
        return this.isLevel(MsgLevel.WARN);
    }

    boolean isTrace() {
        return this.isLevel(MsgLevel.TRACE);
    }

    boolean isQuiet() {
        return this.isLevel(MsgLevel.QUIET);
    }

    boolean isError() {
        return this.isLevel(MsgLevel.ERROR);
    }

    void info(String string) {
        if (!this.isInfo()) {
            return;
        }
        this.output(MsgLevel.INFO, string);
    }

    void info(String string, Throwable throwable) {
        if (!this.isInfo()) {
            return;
        }
        this.output(MsgLevel.INFO, string, throwable);
    }

    void info(String string, StackTraceElement[] stackTraceElementArray) {
        if (!this.isInfo()) {
            return;
        }
        this.output(MsgLevel.INFO, string, stackTraceElementArray);
    }

    void debug(String string) {
        if (!this.isDebug()) {
            return;
        }
        this.output(MsgLevel.DEBUG, string);
    }

    void debug(String string, Throwable throwable) {
        if (!this.isDebug()) {
            return;
        }
        this.output(MsgLevel.DEBUG, string, throwable);
    }

    void debug(String string, StackTraceElement[] stackTraceElementArray) {
        if (!this.isDebug()) {
            return;
        }
        this.output(MsgLevel.DEBUG, string, stackTraceElementArray);
    }

    void warn(String string) {
        if (!this.isWarn()) {
            return;
        }
        this.output(MsgLevel.WARN, string);
    }

    void warn(String string, Throwable throwable) {
        if (!this.isWarn()) {
            return;
        }
        this.output(MsgLevel.WARN, string, throwable);
    }

    void warn(String string, StackTraceElement[] stackTraceElementArray) {
        if (!this.isWarn()) {
            return;
        }
        this.output(MsgLevel.WARN, string, stackTraceElementArray);
    }

    void error(String string) {
        if (!this.isError()) {
            return;
        }
        this.output(MsgLevel.ERROR, string);
    }

    void error(String string, Throwable throwable) {
        if (!this.isError()) {
            return;
        }
        this.output(MsgLevel.ERROR, string, throwable);
    }

    void error(String string, StackTraceElement[] stackTraceElementArray) {
        if (!this.isError()) {
            return;
        }
        this.output(MsgLevel.ERROR, string, stackTraceElementArray);
    }

    void trace(String string) {
        if (!this.isTrace()) {
            return;
        }
        this.output(MsgLevel.TRACE, string);
    }

    void trace(String string, Throwable throwable) {
        if (!this.isTrace()) {
            return;
        }
        this.output(MsgLevel.TRACE, string, throwable);
    }

    void trace(String string, StackTraceElement[] stackTraceElementArray) {
        if (!this.isTrace()) {
            return;
        }
        this.output(MsgLevel.TRACE, string, stackTraceElementArray);
    }

    void forceLog(MsgLevel msgLevel, String string, Object ... objectArray) {
        if (objectArray.length == 0) {
            this.output(msgLevel, string);
        } else {
            this.output(msgLevel, string, objectArray);
        }
    }

    void forceLog(MsgLevel msgLevel, Throwable throwable, String string, Object ... objectArray) {
        if (objectArray.length == 0) {
            this.output(msgLevel, string, throwable);
        } else {
            this.output(msgLevel, throwable, string, objectArray);
        }
    }

    void forceLog(MsgLevel msgLevel, StackTraceElement[] stackTraceElementArray, String string, Object ... objectArray) {
        if (objectArray.length == 0) {
            this.output(msgLevel, string, stackTraceElementArray);
        } else {
            this.output(msgLevel, stackTraceElementArray, string, objectArray);
        }
    }

    void log(MsgLevel msgLevel, String string, Object ... objectArray) {
        if (!this.isLevel(msgLevel)) {
            return;
        }
        this.forceLog(msgLevel, string, objectArray);
    }

    void log(MsgLevel msgLevel, Throwable throwable, String string, Object ... objectArray) {
        if (!this.isLevel(msgLevel)) {
            return;
        }
        this.forceLog(msgLevel, throwable, string, objectArray);
    }

    void log(MsgLevel msgLevel, StackTraceElement[] stackTraceElementArray, String string, Object ... objectArray) {
        if (!this.isLevel(msgLevel)) {
            return;
        }
        this.forceLog(msgLevel, stackTraceElementArray, string, objectArray);
    }
}

