/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.MsgLevel;

@Deprecated
final class RepositoryChunk {
    private final Logger logger;
    private Date startTime;
    private Date endTime;
    private final File tempFile;
    private final File destFile;
    private int refCount = 1;
    private long size;
    private FileChannel outputChannel;
    private FileOutputStream outputStream;
    static boolean rename_overwrites;
    static boolean checked_overwrites;

    RepositoryChunk(Logger logger, File file) {
        JFR.checkControl();
        this.logger = logger;
        this.tempFile = file;
        String string = file.getPath();
        this.destFile = new File(string.substring(0, string.length() - ".part".length()));
        this.startTime = null;
        if (System.getSecurityManager() == null) {
            assert (this.tempFile.exists());
            assert (this.destFile.exists());
        }
    }

    public void finish(long l, long l2) throws IOException {
        this.finish(new Date(l), new Date(l2));
    }

    private void finish(Date date, Date date2) throws IOException {
        if (this.outputChannel != null) {
            this.outputChannel.force(true);
            this.outputChannel.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        if (!checked_overwrites) {
            try {
                rename_overwrites = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws IOException {
                        File file = File.createTempFile("test1", "tst");
                        File file2 = File.createTempFile("test2", "tst");
                        boolean bl = false;
                        if (file.renameTo(file2)) {
                            bl = true;
                        }
                        file.delete();
                        file2.delete();
                        return bl;
                    }
                }, null, new FilePermission(JFR.JAVA_IO_TMPDIR + "/*", "read, write, delete"));
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw (RuntimeException)exception;
            }
            checked_overwrites = true;
        }
        assert (this.tempFile != null);
        if (!rename_overwrites && !this.privilegedDelete(this.destFile)) {
            throw new IOException("Could not delete " + this.destFile);
        }
        Permission[] permissionArray = new FilePermission[]{new FilePermission(this.tempFile.getPath(), "read, write"), new FilePermission(this.destFile.getPath(), "read, write")};
        try {
            this.size = AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws IOException {
                    if (!RepositoryChunk.this.tempFile.renameTo(RepositoryChunk.this.destFile)) {
                        throw new IOException("Could not rename " + RepositoryChunk.this.tempFile + " to " + RepositoryChunk.this.destFile);
                    }
                    return RepositoryChunk.this.destFile.length();
                }
            }, null, permissionArray);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (RuntimeException)exception;
        }
        this.endTime = date2;
        this.startTime = date;
        this.logger.debug("Chunk finished: " + this.destFile);
    }

    public Date getStartTime() {
        return this.startTime != null ? (Date)this.startTime.clone() : null;
    }

    public Date getEndTime() {
        return this.endTime != null ? (Date)this.endTime.clone() : null;
    }

    private boolean privilegedDelete(final File file) {
        assert (file != null);
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (!file.delete() && file.exists()) {
                    return false;
                }
                return true;
            }
        }, null, new FilePermission(file.getPath(), "read, delete"));
    }

    private void destroy() {
        if (!this.isFinished()) {
            try {
                this.finish(0L, 0L);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (int i = 0; i < 2; ++i) {
            final File file = i == 0 ? this.tempFile : this.destFile;
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return file.exists();
                }
            }, null, new FilePermission(file.getPath(), "read"));
            if (!bl) continue;
            boolean bl2 = this.privilegedDelete(file);
            String string = String.format("Repository chunk %s%s deleted.", file.toString(), bl2 ? "" : " not");
            this.logger.log(bl2 ? MsgLevel.DEBUG : MsgLevel.ERROR, string, new Object[0]);
        }
    }

    public synchronized void use() {
        ++this.refCount;
        this.logger.debug("Use chunk " + this.toString() + " ref count now " + this.refCount);
    }

    public synchronized void release() {
        --this.refCount;
        this.logger.debug("Release chunk " + this.toString() + " ref count now " + this.refCount);
        if (this.refCount == 0) {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        boolean bl = false;
        RepositoryChunk repositoryChunk = this;
        synchronized (repositoryChunk) {
            if (this.refCount > 0) {
                bl = true;
            }
        }
        if (bl) {
            this.destroy();
        }
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFinished() {
        return this.endTime != null;
    }

    public String toString() {
        if (this.isFinished()) {
            return this.destFile.getPath();
        }
        return this.tempFile.getPath();
    }

    InputStream newInputStream() throws IOException {
        if (!this.isFinished()) {
            throw new IOException("Chunk not finished");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws FileNotFoundException {
                    return new FileInputStream(RepositoryChunk.this.destFile);
                }
            }, null, new FilePermission(this.destFile.getPath(), "read"));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (RuntimeException)exception;
        }
    }
}

