/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import com.oracle.jrockit.jfr.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import oracle.jrockit.jfr.parser.ChunkParser;
import oracle.jrockit.jfr.parser.ContentTypeDescriptor;
import oracle.jrockit.jfr.parser.FLRStruct;
import oracle.jrockit.jfr.parser.FLRValueInfo;
import oracle.jrockit.jfr.parser.ProducerData;
import oracle.jrockit.jfr.parser.SubStruct;
import oracle.jrockit.jfr.parser.ValueData;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Deprecated
abstract class AbstractStructProxy
implements FLRStruct {
    protected final ChunkParser chunkParser;
    protected final Object[] values;

    public AbstractStructProxy(ChunkParser chunkParser, Object[] objectArray) {
        this.chunkParser = chunkParser;
        this.values = objectArray;
    }

    @Override
    public Object getValue(int n) {
        return this.values[n];
    }

    private Object resolveValue(Object object, ValueData valueData) {
        int n = valueData.getContentTypeOrdinal();
        if (object == null || n <= 6 || n == 11) {
            return object;
        }
        long l = this.timestamp();
        Object[] objectArray = this.chunkParser.resolve(n, (Number)object, l);
        if (objectArray == null) {
            return null;
        }
        ContentTypeDescriptor contentTypeDescriptor = this.chunkParser.contentDescs.get(n);
        return new SubStruct(this.chunkParser, objectArray, contentTypeDescriptor.producer.id, l, contentTypeDescriptor.structIndex);
    }

    @Override
    public Object getResolvedValue(int n) {
        Object object = this.values[n];
        ValueData valueData = this.valueData()[n];
        DataType dataType = valueData.getDataType();
        switch (dataType) {
            default: {
                return this.resolveValue(object, valueData);
            }
            case ARRAY: {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = new Object[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = this.resolveValue(objectArray[i], valueData);
                }
                return objectArray2;
            }
            case STRUCT: {
                return new SubStruct(this.chunkParser, (Object[])object, this.producer().id, this.timestamp(), valueData.getInnerType());
            }
            case STRUCTARRAY: 
        }
        Object[] objectArray = (Object[])object;
        FLRStruct[] fLRStructArray = new FLRStruct[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            fLRStructArray[i] = new SubStruct(this.chunkParser, (Object[])objectArray[i], this.producer().id, this.timestamp(), valueData.getInnerType());
        }
        return fLRStructArray;
    }

    @Override
    public List<?> getResolvedValues() {
        int n = this.values.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getResolvedValue(i));
        }
        return arrayList;
    }

    protected abstract long timestamp();

    protected abstract ProducerData producer();

    protected abstract ValueData[] valueData();

    private Object getValue(String string, boolean bl) {
        ValueData[] valueDataArray = this.valueData();
        int n = 0;
        for (ValueData valueData : valueDataArray) {
            if (valueData.getId().equals(string)) {
                return bl ? this.getResolvedValue(n) : this.getValue(n);
            }
            ++n;
        }
        throw new NoSuchElementException(string);
    }

    @Override
    public FLRValueInfo getValueInfo(int n) {
        return this.valueData()[n];
    }

    @Override
    public FLRValueInfo getValueInfo(String string) {
        for (ValueData valueData : this.valueData()) {
            if (!valueData.getId().equals(string)) continue;
            return valueData;
        }
        throw new NoSuchElementException(string);
    }

    @Override
    public final Object getValue(String string) {
        return this.getValue(string, false);
    }

    @Override
    public final Object getResolvedValue(String string) {
        return this.getValue(string, true);
    }

    @Override
    public List<?> getValues() {
        return Arrays.asList(this.values);
    }

    @Override
    public List<? extends FLRValueInfo> getValueInfos() {
        return Arrays.asList(this.valueData());
    }

    String producerURI() {
        return this.producer().uri.toString();
    }

    void xmlSnippet(ContentHandler contentHandler) throws SAXException {
        ValueData[] valueDataArray = this.valueData();
        String string = this.producerURI();
        int n = 0;
        int n2 = valueDataArray.length;
        for (ValueData valueData : valueDataArray) {
            Object object = this.getResolvedValue(n);
            if (n2 > 1) {
                contentHandler.startElement(string, valueData.xmlname, valueData.qname, ChunkParser.empty);
            }
            switch (valueData.getDataType()) {
                case ARRAY: {
                    Object object2;
                    Object object3 = (Object[])object;
                    for (Object object4 : object3) {
                        contentHandler.startElement("http://www.oracle.com/hotspot/jvm/", "elem", "jfr:elem", ChunkParser.empty);
                        object2 = String.valueOf(object4);
                        contentHandler.characters(((String)object2).toCharArray(), 0, ((String)object2).length());
                        contentHandler.endElement("http://www.oracle.com/hotspot/jvm/", "elem", "jfr:elem");
                    }
                    break;
                }
                case STRUCTARRAY: {
                    Object object2;
                    Object object3 = (Object[])object;
                    for (Object object4 : object3) {
                        object2 = (AbstractStructProxy)object4;
                        contentHandler.startElement("http://www.oracle.com/hotspot/jvm/", "elem", "jfr:elem", ChunkParser.empty);
                        ((AbstractStructProxy)object2).xmlSnippet(contentHandler);
                        contentHandler.endElement("http://www.oracle.com/hotspot/jvm/", "elem", "jfr:elem");
                    }
                    break;
                }
                default: {
                    Object object3;
                    if (object instanceof FLRStruct) {
                        object3 = (AbstractStructProxy)object;
                        ((AbstractStructProxy)object3).xmlSnippet(contentHandler);
                        break;
                    }
                    object3 = String.valueOf(object);
                    contentHandler.characters(((String)object3).toCharArray(), 0, ((String)object3).length());
                }
            }
            if (n2 > 1) {
                contentHandler.endElement(string, valueData.xmlname, valueData.qname);
            }
            ++n;
        }
    }

    private void indent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("   ");
        }
    }

    void print(StringBuilder stringBuilder, int n) {
        ValueData[] valueDataArray = this.valueData();
        int n2 = 0;
        int n3 = valueDataArray.length;
        if (n3 > 1) {
            stringBuilder.append("{\n");
        }
        for (ValueData valueData : valueDataArray) {
            Object object = this.getResolvedValue(n2);
            if (n3 > 1) {
                this.indent(stringBuilder, n + 1);
                stringBuilder.append(valueData.getName()).append(" = ");
            }
            switch (valueData.getDataType()) {
                case ARRAY: {
                    Object object2 = (Object[])object;
                    stringBuilder.append(Arrays.toString((Object[])object2));
                    break;
                }
                case STRUCTARRAY: {
                    Object object2 = (Object[])object;
                    int n4 = 0;
                    for (Object object3 : object2) {
                        AbstractStructProxy abstractStructProxy = (AbstractStructProxy)object3;
                        abstractStructProxy.print(stringBuilder, n + 1);
                        if (++n4 >= ((Object)object2).length) continue;
                        stringBuilder.append(",\n");
                        this.indent(stringBuilder, n + 1);
                    }
                    break;
                }
                default: {
                    Object object2;
                    if (object instanceof FLRStruct) {
                        object2 = (AbstractStructProxy)object;
                        ((AbstractStructProxy)object2).print(stringBuilder, n + 1);
                        break;
                    }
                    stringBuilder.append(object);
                    this.describeValue(stringBuilder, valueData, object);
                }
            }
            ++n2;
            if (n3 <= 1) continue;
            stringBuilder.append('\n');
        }
        if (n3 > 1) {
            this.indent(stringBuilder, n);
            stringBuilder.append("}");
        }
    }

    private void describeValue(StringBuilder stringBuilder, ValueData valueData, Object object) {
        if (valueData.getContentTypeImpl().getOrdinal() == 5) {
            stringBuilder.append(" (");
            stringBuilder.append(this.chunkParser.ticksToMillis((Long)object));
            stringBuilder.append(" ms)");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.print(stringBuilder, 0);
        return stringBuilder.toString();
    }
}

