/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.model.internal;

import com.jrockit.mc.common.Callback;
import com.jrockit.mc.common.ICopyable;
import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.common.util.IImageResource;
import com.jrockit.mc.common.util.Resource;
import com.jrockit.mc.core.labelingrules.NameConverter;
import com.jrockit.mc.core.security.ICredentials;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerDescriptor;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.ServerDescriptor;
import com.jrockit.mc.rjmx.ServerHandle;
import com.jrockit.mc.rjmx.actionprovider.ActionProviderRepository;
import com.jrockit.mc.rjmx.actionprovider.IActionProvider;
import com.jrockit.mc.rjmx.model.IDiscoveryInfo;
import com.jrockit.mc.rjmx.model.IServer;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;

public class Server
implements IServer,
ICopyable,
IImageResource {
    private final ICredentials credentials;
    private final IDiscoveryInfo discoveryInfo;
    private final JMXServiceURL url;
    private final Resource imageResource;
    private IActionProvider actionProvider;
    private String path;
    private ServerHandle serverHandle;
    private Callback<? super Server> observer;
    private final Runnable listener = new Runnable(){

        @Override
        public void run() {
            Callback<? super Server> o = Server.this.getObserver();
            if (o != null) {
                try {
                    o.call((Object)Server.this);
                }
                catch (Exception e) {
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Notify Server observer " + o + " failed", e);
                }
            }
        }
    };

    public Server(String path, JMXServiceURL url, ICredentials credentials, IDiscoveryInfo discoveryInfo, IServerDescriptor serverDesc, IConnectionDescriptor connector) {
        this.discoveryInfo = discoveryInfo;
        this.credentials = credentials;
        this.path = path;
        this.url = url;
        JVMDescriptor jvmInfo = serverDesc.getJvmInfo();
        this.imageResource = jvmInfo != null ? NameConverter.getInstance().getImageResource(jvmInfo) : null;
        this.serverHandle = new ServerHandle(serverDesc, connector, this.listener);
        this.actionProvider = ActionProviderRepository.buildActionProvider(this.serverHandle, this.listener);
    }

    public synchronized void setObserver(Callback<? super Server> observer) {
        this.observer = observer;
    }

    public synchronized Callback<? super Server> getObserver() {
        return this.observer;
    }

    @Override
    public IDiscoveryInfo getDiscoveryInfo() {
        return this.discoveryInfo;
    }

    @Override
    public ICredentials getCredentials() {
        return this.credentials;
    }

    public synchronized void setPath(String path) {
        this.path = path;
    }

    @Override
    public synchronized String getPath() {
        return this.path;
    }

    @Override
    public synchronized ServerHandle getServerHandle() {
        return this.serverHandle;
    }

    @Override
    public synchronized IActionProvider getActionProvider() {
        return this.actionProvider;
    }

    @Override
    public synchronized IConnectionHandle[] getConnectionHandles() {
        return this.serverHandle.getConnectionHandles();
    }

    public boolean isCopyable() {
        return this.url != null;
    }

    @Override
    public JMXServiceURL getConnectionUrl() {
        return this.url;
    }

    public synchronized Object copy() {
        IServerDescriptor originalSd = this.serverHandle.getServerDescriptor();
        ServerDescriptor desc = new ServerDescriptor(null, originalSd.getDisplayName(), originalSd.getJvmInfo());
        return new Server(this.path, this.url, this.credentials, null, desc, this.serverHandle.getConnectionDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        ServerHandle oldHandle;
        Server server = this;
        synchronized (server) {
            oldHandle = this.serverHandle;
            this.serverHandle = new ServerHandle(oldHandle.getServerDescriptor(), oldHandle.getConnectionDescriptor(), this.listener);
            this.actionProvider = ActionProviderRepository.buildActionProvider(this.serverHandle, this.listener);
        }
        oldHandle.dispose(true);
    }

    public Resource getImageResource() {
        return this.imageResource;
    }
}

