/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import com.jrockit.mc.rjmx.triggers.internal.Messages;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluationException;
import java.util.logging.Logger;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public final class ValueEvaluatorNumberMin
implements IValueEvaluator {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static final String XML_ELEMENT_MINVALUE = "minvalue";
    private static final String XML_ELEMENT_CONTENTTYPE = "contenttype";
    private IQuantity m_min;

    public ValueEvaluatorNumberMin() {
    }

    public ValueEvaluatorNumberMin(IQuantity min) {
        this.m_min = min;
    }

    @Override
    public boolean triggerOn(Object val) throws Exception {
        if (!(val instanceof IQuantity)) {
            String logMessage = "ValueEvaluatorNumberMin: " + val + " does not have a content type set";
            LOGGER.info(logMessage);
            throw new ValueEvaluationException(logMessage, NLS.bind((String)Messages.ValueEvaluatorNumber_VALUE_NOT_A_QUANTITY, (Object)val));
        }
        return this.triggerOn((IQuantity)val);
    }

    private boolean triggerOn(IQuantity val) throws Exception {
        if (!val.getUnit().getContentType().equals(this.m_min.getUnit().getContentType())) {
            String logMessage = "ValueEvaluatorNumberMin: " + val.persistableString() + " is not of the same content type as limit " + this.m_min.persistableString();
            LOGGER.info(logMessage);
            throw new ValueEvaluationException(logMessage, NLS.bind((String)Messages.ValueEvaluatorNumber_VALUE_NOT_OF_THE_SAME_TYPE, (Object)val.displayUsing("exact"), (Object)this.m_min.displayUsing("exact")));
        }
        boolean result = val.compareTo((Object)this.m_min) < 0;
        LOGGER.info("ValueEvaluatorNumberMin: " + val.persistableString() + " < " + this.m_min.persistableString() + " = " + result);
        return result;
    }

    public IQuantity getMin() {
        return this.m_min;
    }

    public void setMin(IQuantity minValue) {
        this.m_min = minValue;
    }

    @Override
    public void initializeEvaluatorFromXml(Element node) {
        ContentType contentType = UnitLookup.getContentType((String)XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_CONTENTTYPE, (String)""));
        if (!(contentType instanceof KindOfQuantity)) {
            contentType = UnitLookup.NUMBER;
        }
        String persistedQuantity = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_MINVALUE, (String)"0");
        try {
            this.setMin(((KindOfQuantity)contentType).parsePersisted(persistedQuantity));
        }
        catch (QuantityConversionException e) {
            LOGGER.warning(e.getMessage());
            this.setMin(((KindOfQuantity)contentType).getDefaultUnit().quantity(0L));
        }
    }

    @Override
    public void exportEvaluatorToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)XML_ELEMENT_CONTENTTYPE, (String)this.getMin().getUnit().getContentType().getIdentifier());
        XmlToolkit.setSetting((Element)node, (String)XML_ELEMENT_MINVALUE, (String)this.getMin().persistableString());
    }

    public String toString() {
        return "value < " + this.m_min.persistableString();
    }

    @Override
    public String getOperatorString() {
        return "<";
    }

    @Override
    public String getEvaluationConditionString() {
        return "< " + this.m_min.displayUsing("exact");
    }
}

